/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.worldgen.vanillaore;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import org.gtreimagined.gtlib.util.TagUtils;
import org.gtreimagined.gtlib.worldgen.IWorldgenObject;
import org.gtreimagined.gtlib.worldgen.OreObject;

public record VanillaVein(ResourceLocation id, OreObject primary, OreObject secondary, float secondaryChance, float discardOnExposureChance, int minY, int maxY, int weight, int size, int probability, boolean triangle, int plateau, boolean spawnOnOceanFloor, List<ResourceKey<Level>> dimensions, List<String> biomes, boolean biomeBlacklist) implements IWorldgenObject<VanillaVein>
{
    public static final Codec<VanillaVein> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.fieldOf("id").forGetter(VanillaVein::id), (App)OreObject.CODEC.fieldOf("primary").forGetter(VanillaVein::primary), (App)OreObject.CODEC.fieldOf("secondary").forGetter(VanillaVein::secondary), (App)Codec.FLOAT.fieldOf("secondaryChance").forGetter(VanillaVein::secondaryChance), (App)Codec.FLOAT.fieldOf("discardOnExposureChance").forGetter(VanillaVein::discardOnExposureChance), (App)Codec.INT.fieldOf("minY").forGetter(VanillaVein::minY), (App)Codec.INT.fieldOf("maxY").forGetter(VanillaVein::maxY), (App)Codec.INT.fieldOf("weight").forGetter(VanillaVein::weight), (App)Codec.INT.fieldOf("size").forGetter(VanillaVein::size), (App)Codec.INT.fieldOf("probability").forGetter(VanillaVein::probability), (App)Codec.BOOL.fieldOf("triangle").forGetter(VanillaVein::triangle), (App)Codec.INT.fieldOf("plateau").forGetter(VanillaVein::plateau), (App)Codec.BOOL.fieldOf("spawnOnOceanFloor").forGetter(VanillaVein::spawnOnOceanFloor), (App)ResourceKey.m_195966_((ResourceKey)Registry.f_122819_).listOf().fieldOf("dimensions").forGetter(VanillaVein::dimensions), (App)Codec.STRING.listOf().optionalFieldOf("biomes", List.of()).forGetter(VanillaVein::biomes), (App)Codec.BOOL.optionalFieldOf("biomeBlacklist", (Object)true).forGetter(VanillaVein::biomeBlacklist)).apply((Applicative)instance, VanillaVein::new));

    @Override
    public boolean isBiomeValid(Holder<Biome> biome) {
        if (this.biomes.isEmpty()) {
            return this.biomeBlacklist;
        }
        Predicate<String> predicate = s -> {
            if (s.contains("#")) {
                return biome.m_203656_(TagUtils.getBiomeTag(new ResourceLocation(s.replace("#", ""))));
            }
            return biome.m_203565_(ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)new ResourceLocation(s)));
        };
        return this.biomeBlacklist ? this.biomes.stream().anyMatch(predicate) : this.biomes.stream().noneMatch(predicate);
    }

    @Override
    public ResourceLocation getLoc() {
        return this.id;
    }

    @Override
    public String getSubDirectory() {
        return "vanilla_veins";
    }

    @Override
    public Codec<VanillaVein> getCodec() {
        return CODEC;
    }

    @Override
    public List<ResourceKey<Level>> getDimensions() {
        return this.dimensions;
    }
}

