/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.util;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;

public class TagUtils {
    private static final Map<Class, Map<ResourceLocation, TagKey>> TAG_MAP = new Object2ObjectOpenHashMap();

    public static TagKey<Block> itemToBlockTag(TagKey<Item> tag) {
        return TagUtils.createTag(tag.f_203868_(), Block.class, name -> TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)name));
    }

    public static TagKey<Item> blockToItemTag(TagKey<Block> tag) {
        return TagUtils.createTag(tag.f_203868_(), Item.class, name -> TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)name));
    }

    public static TagKey<Block> getBlockTag(ResourceLocation loc) {
        return TagUtils.createTag(loc, Block.class, name -> TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)name));
    }

    public static Map<ResourceLocation, TagKey> getTags(Class clazz) {
        return TAG_MAP.getOrDefault(clazz, Collections.emptyMap());
    }

    public static TagKey<Block> getForgelikeBlockTag(String name) {
        return TagUtils.getBlockTag(new ResourceLocation("forge", name));
    }

    public static TagKey<Item> getItemTag(ResourceLocation loc) {
        return TagUtils.createTag(loc, Item.class, name -> TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)name));
    }

    public static TagKey<Item> getForgelikeItemTag(String name) {
        return TagUtils.getItemTag(new ResourceLocation("forge", name));
    }

    public static TagKey<Fluid> getForgelikeFluidTag(String name) {
        return TagUtils.createTag(new ResourceLocation("forge", name), Fluid.class, fluidName -> TagKey.m_203882_((ResourceKey)Registry.f_122899_, (ResourceLocation)fluidName));
    }

    public static TagKey<Fluid> getFluidTag(ResourceLocation name) {
        return TagUtils.createTag(name, Fluid.class, fluidName -> TagKey.m_203882_((ResourceKey)Registry.f_122899_, (ResourceLocation)fluidName));
    }

    public static TagKey<Biome> getBiomeTag(ResourceLocation name) {
        return TagUtils.createTag(name, Biome.class, biomeName -> TagKey.m_203882_((ResourceKey)Registry.f_122885_, (ResourceLocation)biomeName));
    }

    public static <T> TagKey<T> getTag(ResourceLocation name, Class<T> clazz, Registry<T> registry) {
        return TagUtils.createTag(name, clazz, biomeName -> TagKey.m_203882_((ResourceKey)registry.m_123023_(), (ResourceLocation)biomeName));
    }

    public static List<Item> nc(TagKey<Item> tag) {
        ObjectArrayList list = new ObjectArrayList();
        Registry.f_122827_.m_206058_(tag).iterator().forEachRemaining(arg_0 -> TagUtils.lambda$nc$8((List)list, arg_0));
        return list;
    }

    public static TagKey<Item> nc(ResourceLocation tag) {
        return new TagKey(Registry.f_122904_, tag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static <T> TagKey<T> createTag(ResourceLocation loc, Class<T> clazz, Function<ResourceLocation, TagKey<T>> fn) {
        TagKey[] tag = new TagKey[1];
        Map<Class, Map<ResourceLocation, TagKey>> map = TAG_MAP;
        synchronized (map) {
            TAG_MAP.compute(clazz, (k, v) -> {
                if (v == null) {
                    v = new Object2ObjectOpenHashMap();
                }
                tag[0] = v.computeIfAbsent(loc, a -> (TagKey)fn.apply(loc));
                return v;
            });
        }
        return tag[0];
    }

    private static /* synthetic */ void lambda$nc$8(List list, Holder t) {
        list.add((Item)t.m_203334_());
    }
}

