/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.pipe.types;

import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import net.minecraft.world.level.block.Block;
import org.gtreimagined.gtlib.blockentity.pipe.BlockEntityCable;
import org.gtreimagined.gtlib.machine.Tier;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.material.MaterialTags;
import org.gtreimagined.gtlib.pipe.BlockCable;
import org.gtreimagined.gtlib.pipe.PipeSize;
import org.gtreimagined.gtlib.pipe.types.PipeType;

public class Cable<T extends Cable<T>>
extends PipeType<T> {
    protected double loss;
    protected Tier tier;
    protected int[] amps;

    public Cable(String domain, Material material, double loss, Tier tier) {
        super(domain, material, BlockEntityCable::new);
        this.loss = loss;
        this.tier = tier;
        material.flags(MaterialTags.CABLE);
    }

    public Cable(String domain, Material material, int loss, Tier tier) {
        this(domain, material, (double)loss, tier);
    }

    @Override
    public String getType() {
        return "cable";
    }

    @Override
    public String getTypeName() {
        return "energy";
    }

    @Override
    public Set<Block> getBlocks() {
        return this.sizes.stream().map(s -> new BlockCable<Cable>(this, (PipeSize)s, true)).collect(Collectors.toSet());
    }

    public int getAmps(PipeSize size) {
        return this.amps[size.ordinal()];
    }

    public T amps(int baseAmps) {
        this.amps = new int[]{baseAmps, baseAmps * 2, baseAmps * 4, baseAmps * 8, baseAmps * 12, baseAmps * 16};
        return (T)this;
    }

    public T amps(int ... amps) {
        this.amps = amps;
        return (T)this;
    }

    public T loss(double loss) {
        this.loss = loss;
        return (T)this;
    }

    @Generated
    public double getLoss() {
        return this.loss;
    }

    @Generated
    public Tier getTier() {
        return this.tier;
    }
}

