/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.ore;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Supplier;
import lombok.Generated;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.block.BlockStone;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.registration.IRegistryEntryProvider;
import org.gtreimagined.gtlib.registration.ISharedGTObject;
import org.gtreimagined.gtlib.texture.Texture;

public class StoneType
implements ISharedGTObject,
IRegistryEntryProvider {
    private final String domain;
    private final String id;
    private boolean gravity;
    private boolean requiresTool;
    public boolean generateBlock;
    public boolean generateOre = true;
    private final Material material;
    private Texture[] textures;
    protected Texture defaultTexture;
    private final SoundType soundType;
    private BlockState state;
    private Supplier<BlockState> stateSupplier;
    private int harvestLevel;
    private int fallingDustColor;
    private float hardness;
    private float resistence;
    private TagKey<Block> toolType;
    private net.minecraft.world.level.material.Material blockMaterial;
    private boolean sandLike = false;

    public StoneType(String domain, String id, Material material, Texture texture, SoundType soundType, boolean generateBlock) {
        this.domain = domain;
        this.id = id;
        this.material = material;
        this.defaultTexture = texture;
        this.soundType = soundType;
        this.generateBlock = generateBlock;
        this.gravity = false;
        this.harvestLevel = 0;
        this.requiresTool = true;
        this.hardness = 1.5f;
        this.resistence = 6.0f;
        this.toolType = BlockTags.f_144282_;
        this.fallingDustColor = -16777216;
        this.blockMaterial = net.minecraft.world.level.material.Material.f_76278_;
    }

    public StoneType setHarvestLevel(int harvestLevel) {
        this.harvestLevel = harvestLevel;
        return this;
    }

    public StoneType setHardnessAndResistance(float hardnessAndResistence) {
        this.hardness = hardnessAndResistence;
        this.resistence = hardnessAndResistence;
        return this;
    }

    public StoneType setHardnessAndResistance(float hardness, float resistence) {
        this.hardness = hardness;
        this.resistence = resistence;
        return this;
    }

    public StoneType setGravity(boolean gravity) {
        this.gravity = gravity;
        return this;
    }

    public StoneType setRequiresTool(boolean requiresTool) {
        this.requiresTool = requiresTool;
        return this;
    }

    public StoneType setFallingDustColor(int fallingDustColor) {
        this.fallingDustColor = fallingDustColor;
        return this;
    }

    public StoneType setSandLike(boolean sandLike) {
        if (sandLike) {
            this.setHardnessAndResistance(0.5f).setRequiresTool(false).setType((TagKey<Block>)BlockTags.f_144283_).setGravity(true).setBlockMaterial(net.minecraft.world.level.material.Material.f_76317_);
        }
        this.sandLike = sandLike;
        return this;
    }

    public StoneType setGenerateOre(boolean generateOre) {
        this.generateOre = generateOre;
        return this;
    }

    public StoneType setType(TagKey<Block> type) {
        this.toolType = type;
        return this;
    }

    public StoneType setBlockMaterial(net.minecraft.world.level.material.Material material) {
        this.blockMaterial = material;
        return this;
    }

    public StoneType setTextures(Texture ... textures) {
        this.textures = textures;
        return this;
    }

    @Override
    public void onRegistryBuild(IForgeRegistry<?> registry) {
        if (this.generateBlock && registry == ForgeRegistries.BLOCKS) {
            this.setState(new BlockStone(this));
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    public Texture getTexture() {
        return this.defaultTexture;
    }

    public Texture[] getTextures() {
        Texture[] textureArray;
        if (this.textures != null) {
            textureArray = this.textures;
        } else {
            Texture[] textureArray2 = new Texture[1];
            textureArray = textureArray2;
            textureArray2[0] = this.getTexture();
        }
        return textureArray;
    }

    public boolean doesGenerateBlock() {
        return this.generateBlock;
    }

    public boolean doesGenerateOre() {
        return this.generateOre;
    }

    public boolean doesRequireTool() {
        return this.requiresTool;
    }

    public StoneType setState(Block block) {
        this.state = block.m_49966_();
        return this;
    }

    public StoneType setState(BlockState blockState) {
        this.state = blockState;
        return this;
    }

    public StoneType setStateSupplier(Supplier<BlockState> blockState) {
        this.stateSupplier = blockState;
        return this;
    }

    public boolean getGravity() {
        return this.gravity;
    }

    public static Collection<Collection<Texture>> getAllTextures() {
        ObjectArrayList textures = new ObjectArrayList();
        for (StoneType type : StoneType.getAllGeneratingBlock()) {
            textures.add(Arrays.asList(type.getTextures()));
        }
        return textures;
    }

    public static StoneType[] getAllGeneratingBlock() {
        return (StoneType[])GTAPI.all(StoneType.class).stream().filter(s -> s.generateBlock).toArray(StoneType[]::new);
    }

    public void initSuppliedState() {
        if (this.state == null && this.stateSupplier != null) {
            this.state = this.stateSupplier.get();
        }
    }

    public static StoneType get(String id) {
        return GTAPI.get(StoneType.class, id);
    }

    public static StoneType fromBlock(Block block) {
        return GTAPI.all(StoneType.class).stream().filter(s -> s.getState().m_60734_() == block).findFirst().orElse(null);
    }

    @Override
    @Generated
    public String getDomain() {
        return this.domain;
    }

    @Generated
    public Material getMaterial() {
        return this.material;
    }

    @Generated
    public SoundType getSoundType() {
        return this.soundType;
    }

    @Generated
    public BlockState getState() {
        return this.state;
    }

    @Generated
    public int getHarvestLevel() {
        return this.harvestLevel;
    }

    @Generated
    public int getFallingDustColor() {
        return this.fallingDustColor;
    }

    @Generated
    public float getHardness() {
        return this.hardness;
    }

    @Generated
    public float getResistence() {
        return this.resistence;
    }

    @Generated
    public TagKey<Block> getToolType() {
        return this.toolType;
    }

    @Generated
    public net.minecraft.world.level.material.Material getBlockMaterial() {
        return this.blockMaterial;
    }

    @Generated
    public boolean isSandLike() {
        return this.sandLike;
    }
}

