/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.integration.jei.category;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fluids.FluidStack;
import org.gtreimagined.gtlib.Data;
import org.gtreimagined.gtlib.gui.BarDir;
import org.gtreimagined.gtlib.gui.GuiData;
import org.gtreimagined.gtlib.gui.SlotData;
import org.gtreimagined.gtlib.gui.SlotType;
import org.gtreimagined.gtlib.gui.slot.AbstractSlot;
import org.gtreimagined.gtlib.integration.xei.renderer.IRecipeInfoRenderer;
import org.gtreimagined.gtlib.item.ScannerItem;
import org.gtreimagined.gtlib.machine.Tier;
import org.gtreimagined.gtlib.recipe.IRecipe;
import org.gtreimagined.gtlib.recipe.ingredient.FluidIngredient;
import org.gtreimagined.gtlib.recipe.ingredient.RecipeIngredient;
import org.gtreimagined.gtlib.recipe.map.IRecipeMap;
import org.gtreimagined.gtlib.recipe.map.RecipeMap;
import org.gtreimagined.gtlib.recipe.map.SubCategory;
import org.gtreimagined.gtlib.util.FluidUtils;
import org.gtreimagined.gtlib.util.RegistryUtils;
import org.gtreimagined.gtlib.util.Utils;
import org.gtreimagined.gtlib.util.int4;

public class RecipeMapCategory
implements IRecipeCategory<IRecipe> {
    protected static int JEI_OFFSET_X = 1;
    protected static int JEI_OFFSET_Y = 1;
    public static IGuiHelper guiHelper;
    protected String title;
    protected final ResourceLocation loc;
    protected final RecipeType<IRecipe> type;
    protected IDrawable background;
    protected IDrawable icon;
    protected IDrawable progressBackground;
    protected IDrawableAnimated progressBar;
    protected GuiData gui;
    protected Tier guiTier;
    private final IRecipeInfoRenderer infoRenderer;

    public RecipeMapCategory(IRecipeMap map, RecipeType<IRecipe> type, GuiData gui, Tier defaultTier, ResourceLocation iconId) {
        this.loc = map.getLoc();
        this.type = type;
        this.guiTier = map.getGuiTier() == null ? defaultTier : map.getGuiTier();
        this.title = map.getDisplayName().getString();
        int4 area = gui.getArea();
        int4 progress = new int4(0, gui.getMachineData().getProgressSize().y, gui.getMachineData().getProgressSize().x, gui.getMachineData().getProgressSize().y);
        this.background = guiHelper.drawableBuilder(gui.getTexture(this.guiTier, "machine"), area.x, area.y, area.z, area.w).addPadding(0, map.getInfoRenderer().getRows() <= 0 ? 0 : 7 + 10 * map.getInfoRenderer().getRows(), 0, 0).build();
        this.progressBar = guiHelper.drawableBuilder(gui.getMachineData().getProgressTexture(this.guiTier), progress.x, progress.y, progress.z, progress.w).setTextureSize(progress.z, progress.w * 2).buildAnimated(50, this.fromDir(gui.getMachineData().getDir()), !gui.getMachineData().doesBarFill());
        this.progressBackground = guiHelper.drawableBuilder(gui.getMachineData().getProgressTexture(this.guiTier), 0, 0, progress.z, progress.w).setTextureSize(progress.z, progress.w * 2).build();
        Object icon = map.getIcon();
        if (icon != null) {
            if (icon instanceof ItemStack) {
                ItemStack itemStack = (ItemStack)icon;
                this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)itemStack);
            }
            if (icon instanceof ItemLike) {
                ItemLike item = (ItemLike)icon;
                this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack(item));
            }
        } else {
            ScannerItem item;
            ScannerItem scannerItem = item = iconId == null ? Data.DEBUG_SCANNER : RegistryUtils.getItemFromID(iconId);
            if (item == Items.f_41852_) {
                item = Data.DEBUG_SCANNER;
            }
            this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)item, 1));
        }
        this.gui = gui;
        this.infoRenderer = map.getInfoRenderer();
    }

    public RecipeMapCategory(IRecipeMap map, RecipeType<IRecipe> type, GuiData gui, Tier defaultTier, ResourceLocation subCategoryId, SubCategory subCategory) {
        this.loc = subCategoryId;
        this.type = type;
        this.guiTier = map.getGuiTier() == null ? defaultTier : map.getGuiTier();
        this.title = Utils.translatable(subCategory.langKey(), new Object[0]).getString();
        int4 area = gui.getArea();
        int4 progress = new int4(0, gui.getMachineData().getProgressSize().y, gui.getMachineData().getProgressSize().x, gui.getMachineData().getProgressSize().y);
        this.background = guiHelper.drawableBuilder(gui.getTexture(this.guiTier, "machine"), area.x, area.y, area.z, area.w).addPadding(0, map.getInfoRenderer().getRows() <= 0 ? 0 : 7 + 10 * map.getInfoRenderer().getRows(), 0, 0).build();
        this.progressBar = guiHelper.drawableBuilder(gui.getMachineData().getProgressTexture(this.guiTier), progress.x, progress.y, progress.z, progress.w).setTextureSize(progress.z, progress.w * 2).buildAnimated(50, this.fromDir(gui.getMachineData().getDir()), !gui.getMachineData().doesBarFill());
        this.progressBackground = guiHelper.drawableBuilder(gui.getMachineData().getProgressTexture(this.guiTier), 0, 0, progress.z, progress.w).setTextureSize(progress.z, progress.w * 2).build();
        Object icon = subCategory.icon().get();
        if (icon != null) {
            if (icon instanceof ItemStack) {
                ItemStack itemStack = (ItemStack)icon;
                this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)itemStack);
            }
            if (icon instanceof ItemLike) {
                ItemLike item = (ItemLike)icon;
                this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack(item));
            }
            if (icon instanceof ResourceLocation) {
                ResourceLocation resourceLocation = (ResourceLocation)icon;
                this.icon = guiHelper.drawableBuilder(resourceLocation, 0, 0, 16, 16).setTextureSize(16, 16).build();
            }
        } else {
            ScannerItem item = Data.DEBUG_SCANNER;
            this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)item, 1));
        }
        this.gui = gui;
        this.infoRenderer = map.getInfoRenderer();
    }

    private IDrawableAnimated.StartDirection fromDir(BarDir dir) {
        return switch (dir) {
            default -> throw new IncompatibleClassChangeError();
            case BarDir.TOP -> IDrawableAnimated.StartDirection.TOP;
            case BarDir.BOTTOM -> IDrawableAnimated.StartDirection.BOTTOM;
            case BarDir.LEFT -> IDrawableAnimated.StartDirection.LEFT;
            case BarDir.RIGHT -> IDrawableAnimated.StartDirection.RIGHT;
        };
    }

    public RecipeType<IRecipe> getRecipeType() {
        return this.type;
    }

    public ResourceLocation getUid() {
        return this.loc;
    }

    public Component getTitle() {
        return Utils.literal(this.title);
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, IRecipe recipe, IFocusGroup focuses) {
        IRecipeSlotBuilder slot;
        int s;
        List<SlotData<AbstractSlot>> slots;
        int slotCount;
        List inputs = recipe.hasInputItems() ? recipe.getInputItems().stream().map(t -> Arrays.asList(t.m_43908_())).toList() : Collections.emptyList();
        List outputs = recipe.hasOutputItems() ? Arrays.stream(recipe.getOutputItems(false)).toList() : Collections.emptyList();
        boolean groupIndex = false;
        int offsetX = this.gui.getArea().x + JEI_OFFSET_X;
        int offsetY = this.gui.getArea().y + JEI_OFFSET_Y;
        int inputItems = 0;
        int inputFluids = 0;
        if (recipe.hasInputItems() && (slotCount = (slots = this.gui.getSlots().getSlots(SlotType.IT_IN, this.guiTier)).size()) > 0) {
            if (!inputs.isEmpty()) {
                slotCount = Math.min(slotCount, inputs.size());
                for (s = 0; s < slotCount; ++s) {
                    slot = builder.addSlot(RecipeIngredientRole.INPUT, slots.get(s).getX() - (offsetX - 1), slots.get(s).getY() - (offsetY - 1));
                    List input = (List)inputs.get(s);
                    if (input.isEmpty()) {
                        ObjectArrayList st = new ObjectArrayList(1);
                        st.add(new ItemStack((ItemLike)Data.DEBUG_SCANNER, 1).m_41714_((Component)Utils.literal("Empty tag")));
                        slot.addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, (List)st);
                        continue;
                    }
                    slot.addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, input);
                    int ss = s;
                    slot.addTooltipCallback((ing, list) -> {
                        Ingredient patt9459$temp = recipe.getInputItems().get(ss);
                        if (patt9459$temp instanceof RecipeIngredient) {
                            Ingredient i;
                            RecipeIngredient ri = (RecipeIngredient)patt9459$temp;
                            if (ri.ignoreConsume()) {
                                list.add(Utils.literal("Does not get consumed in the process.").m_130940_(ChatFormatting.WHITE));
                            }
                            if (ri.ignoreNbt()) {
                                list.add(Utils.literal("Ignores NBT.").m_130940_(ChatFormatting.WHITE));
                            }
                            if (RecipeMap.isIngredientSpecial(i = recipe.getInputItems().get(ss))) {
                                list.add(Utils.literal("Special ingredient. Class name: ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Utils.literal(i.getClass().getSimpleName()).m_130940_(ChatFormatting.GOLD)));
                            }
                        }
                        if (recipe.hasInputChances() && recipe.getInputChances()[ss] < 10000) {
                            list.add(Utils.literal("Consumption Chance: " + (float)recipe.getInputChances()[ss] / 100.0f + "%").m_130940_(ChatFormatting.WHITE));
                        }
                    });
                    ++inputItems;
                }
            }
        }
        if (recipe.hasOutputItems() && (slotCount = (slots = this.gui.getSlots().getSlots(SlotType.IT_OUT, this.guiTier)).size()) > 0) {
            slotCount = Math.min(slotCount, outputs.size());
            s = 0;
            while (s < slotCount) {
                slot = builder.addSlot(RecipeIngredientRole.OUTPUT, slots.get(s).getX() - (offsetX - 1), slots.get(s).getY() - (offsetY - 1));
                slot.addIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)((ItemStack)outputs.get(s)));
                int ss = s++;
                slot.addTooltipCallback((ing, list) -> {
                    if (recipe.hasOutputChances() && recipe.getOutputChances()[ss] < 10000) {
                        list.add(Utils.literal("Output Chance: " + (float)recipe.getOutputChances()[ss] / 100.0f + "%").m_130940_(ChatFormatting.WHITE));
                    }
                });
            }
        }
        if (recipe.hasInputFluids() && (slotCount = (slots = this.gui.getSlots().getSlots(SlotType.FL_IN, this.guiTier)).size()) > 0) {
            List<FluidIngredient> fluids = recipe.getInputFluids();
            slotCount = Math.min(slotCount, fluids.size());
            int s2 = 0;
            while (s2 < slotCount) {
                IRecipeSlotBuilder slot2 = builder.addSlot(RecipeIngredientRole.INPUT, slots.get(s2).getX() - (offsetX - 1), slots.get(s2).getY() - (offsetY - 1));
                slot2.addIngredients((IIngredientType)ForgeTypes.FLUID_STACK, Arrays.asList(fluids.get(s2).getStacks()));
                slot2.setFluidRenderer(fluids.get(s2).getAmount(), true, 16, 16);
                int finalS = s2++;
                slot2.addTooltipCallback((ing, list) -> {
                    FluidStack stack = ((FluidIngredient)fluids.get(finalS)).getStacks()[0];
                    this.createFluidTooltip(ing, list, stack);
                });
                ++inputFluids;
            }
        }
        if (recipe.hasOutputFluids() && (slotCount = (slots = this.gui.getSlots().getSlots(SlotType.FL_OUT, this.guiTier)).size()) > 0) {
            FluidStack[] fluids = recipe.getOutputFluids();
            slotCount = Math.min(slotCount, fluids.length);
            int s3 = 0;
            while (s3 < slotCount) {
                IRecipeSlotBuilder slot3 = builder.addSlot(RecipeIngredientRole.OUTPUT, slots.get(s3).getX() - (offsetX - 1), slots.get(s3).getY() - (offsetY - 1));
                slot3.setFluidRenderer(fluids[s3].getAmount(), true, 16, 16);
                slot3.addIngredients((IIngredientType)ForgeTypes.FLUID_STACK, Collections.singletonList(fluids[s3]));
                int finalS = s3++;
                slot3.addTooltipCallback((ing, list) -> {
                    FluidStack stack = fluids[finalS];
                    this.createFluidTooltip(ing, list, stack);
                });
            }
        }
    }

    private void createFluidTooltip(IRecipeSlotView ing, List<Component> list, FluidStack stack) {
        Component component = list.get(2);
        list.remove(2);
        list.remove(1);
        int mb = stack.getAmount();
        list.add((Component)Utils.translatable("gtlib.tooltip.fluid.amount", mb + " L").m_130940_(ChatFormatting.BLUE));
        list.add((Component)Utils.translatable("gtlib.tooltip.fluid.temp", FluidUtils.getFluidTemperature(stack.getFluid())).m_130940_(ChatFormatting.RED));
        String liquid = !FluidUtils.isFluidGaseous(stack.getFluid()) ? "liquid" : "gas";
        list.add((Component)Utils.translatable("gtlib.tooltip.fluid." + liquid, new Object[0]).m_130940_(ChatFormatting.GREEN));
        if (Utils.hasNoConsumeTag((FluidStack)((ITypedIngredient)ing.getDisplayedIngredient().get()).getIngredient((IIngredientType)ForgeTypes.FLUID_STACK).get())) {
            list.add((Component)Utils.literal("Does not get consumed in the process").m_130940_(ChatFormatting.WHITE));
        }
        list.add(component);
    }

    public Class getRecipeClass() {
        return IRecipe.class;
    }

    public void draw(IRecipe recipe, IRecipeSlotsView recipeSlotsView, PoseStack stack, double mouseX, double mouseY) {
        String ch;
        int i;
        List<SlotData<AbstractSlot>> slots;
        List views;
        if (this.progressBackground != null) {
            this.progressBackground.draw(stack, this.gui.getMachineData().getProgressPos().x + this.gui.getArea().x, this.gui.getMachineData().getProgressPos().y + this.gui.getArea().y);
        }
        if (this.progressBar != null) {
            this.progressBar.draw(stack, this.gui.getMachineData().getProgressPos().x + this.gui.getArea().x, this.gui.getMachineData().getProgressPos().y + this.gui.getArea().y);
        }
        this.gui.getSlots().getRecipeSlots(this.guiTier).forEach(s -> {
            IDrawableStatic drawable = guiHelper.drawableBuilder(s.getTexture(), 0, 0, 18, 18).setTextureSize(18, 18).build();
            drawable.draw(stack, s.getX() - 4, s.getY() - 4);
        });
        this.infoRenderer.render(stack, recipe, Minecraft.m_91087_().f_91062_, JEI_OFFSET_X, this.gui.getArea().y + JEI_OFFSET_Y + this.gui.getArea().z / 2);
        int offsetX = this.gui.getArea().x + JEI_OFFSET_X;
        int offsetY = this.gui.getArea().y + JEI_OFFSET_Y;
        if (recipe.hasOutputChances()) {
            views = recipeSlotsView.getSlotViews(RecipeIngredientRole.OUTPUT);
            slots = this.gui.getSlots().getSlots(SlotType.IT_OUT, this.guiTier);
            for (i = 0; i < recipe.getOutputChances().length; ++i) {
                if (recipe.getOutputChances()[i] >= 10000) continue;
                if (i >= slots.size()) break;
                RenderSystem.m_69461_();
                RenderSystem.m_69465_();
                stack.m_85836_();
                stack.m_85841_(0.5f, 0.5f, 1.0f);
                ch = recipe.getOutputChances()[i] / 100 + "%";
                Minecraft.m_91087_().f_91062_.m_92750_(stack, ch, 2.0f * ((float)slots.get(i).getX() - (float)(offsetX - 1)), 2.0f * ((float)slots.get(i).getY() - (float)(offsetY - 1)), 0xFFFF00);
                stack.m_85849_();
                RenderSystem.m_69478_();
                RenderSystem.m_69482_();
            }
        }
        if (recipe.hasInputChances()) {
            views = recipeSlotsView.getSlotViews(RecipeIngredientRole.INPUT);
            slots = this.gui.getSlots().getSlots(SlotType.IT_IN, this.guiTier);
            for (i = 0; i < recipe.getInputChances().length; ++i) {
                if (recipe.getInputChances()[i] >= 10000) continue;
                if (i >= slots.size()) break;
                RenderSystem.m_69461_();
                RenderSystem.m_69465_();
                stack.m_85836_();
                stack.m_85841_(0.5f, 0.5f, 1.0f);
                ch = recipe.getInputChances()[i] / 100 + "%";
                Minecraft.m_91087_().f_91062_.m_92750_(stack, ch, 2.0f * ((float)slots.get(i).getX() - (float)(offsetX - 1)), 2.0f * ((float)slots.get(i).getY() - (float)(offsetY - 1)), 0xFFFF00);
                stack.m_85849_();
                RenderSystem.m_69478_();
                RenderSystem.m_69482_();
            }
        }
    }

    public static void setGuiHelper(IGuiHelper helper) {
        guiHelper = helper;
    }
}

