/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import lombok.Generated;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.gtreimagined.gtlib.gui.GuiInstance;
import org.gtreimagined.gtlib.gui.IGuiElement;
import org.gtreimagined.gtlib.gui.widget.WidgetSupplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Widget
implements IGuiElement {
    public final GuiInstance gui;
    public final boolean isRemote;
    protected IGuiElement parent;
    private Component message = TextComponent.f_131282_;
    public final int id;
    protected boolean enabled = true;
    protected boolean shouldRender = true;
    protected boolean isClicking = false;
    private int depth;
    private int x;
    private int y;
    private int w;
    private int h = 0;
    private int realX;
    private int realY;

    protected Widget(@NotNull GuiInstance gui, @Nullable IGuiElement parent) {
        this.gui = gui;
        this.isRemote = gui.isRemote;
        this.parent = parent;
        this.id = 0;
        this.updateSize();
    }

    @OnlyIn(value=Dist.CLIENT)
    protected static void fillGradient(Matrix4f matrix, BufferBuilder builder, int x1, int y1, int x2, int y2, int z, int colorA, int colorB) {
        float f = (float)(colorA >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(colorA >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(colorA >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(colorA & 0xFF) / 255.0f;
        float f4 = (float)(colorB >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(colorB >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(colorB >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(colorB & 0xFF) / 255.0f;
        builder.m_85982_(matrix, (float)x2, (float)y1, (float)z).m_85950_(f1, f2, f3, f).m_5752_();
        builder.m_85982_(matrix, (float)x1, (float)y1, (float)z).m_85950_(f1, f2, f3, f).m_5752_();
        builder.m_85982_(matrix, (float)x1, (float)y2, (float)z).m_85950_(f5, f6, f7, f4).m_5752_();
        builder.m_85982_(matrix, (float)x2, (float)y2, (float)z).m_85950_(f5, f6, f7, f4).m_5752_();
    }

    public void init() {
    }

    @Override
    public int depth() {
        return this.depth;
    }

    public void setEnabled(boolean enabled) {
        if (enabled != this.enabled) {
            this.enabled = enabled;
            this.gui.updateWidgetStatus(this);
        }
    }

    public void setVisible(boolean visible) {
        this.shouldRender = visible;
    }

    public void setParent(IGuiElement parent) {
        this.parent = parent;
        this.updateSize();
    }

    public void updateSize() {
        int oldX = this.realX;
        int oldY = this.realY;
        this.realX = this.parent != null ? this.parent.realX() + this.x : this.x;
        this.realY = this.parent != null ? this.parent.realY() + this.y : this.y;
        this.gui.rescaleWidget(this, oldX, oldY, this.getW(), this.getH());
        if (this.parent != null) {
            this.parent.onChildSizeChange(this);
        }
    }

    public boolean isInside(double mouseX, double mouseY) {
        int realX = this.realX();
        int realY = this.realY();
        return mouseX >= (double)realX && mouseX <= (double)(realX + this.getW()) && mouseY >= (double)realY && mouseY <= (double)(realY + this.getH());
    }

    public boolean isInside(int x, int y, int w, int h, double mouseX, double mouseY) {
        int realX = this.realX() + x;
        int realY = this.realY() + y;
        return mouseX >= (double)realX && mouseX <= (double)(realX + w) && mouseY >= (double)realY && mouseY <= (double)(realY + h);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void renderTooltip(PoseStack matrixStack, Component text, double mouseX, double mouseY) {
        this.gui.screen.m_96597_(matrixStack, Collections.singletonList(text), (int)mouseX, (int)mouseY);
    }

    @Override
    public int realX() {
        return this.realX;
    }

    @Override
    public int realY() {
        return this.realY;
    }

    public void onClick(double mouseX, double mouseY, int button) {
    }

    public void onRelease(double mouseX, double mouseY) {
        this.isClicking = false;
    }

    protected void onDrag(double mouseX, double mouseY, double dragX, double dragY) {
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers, double mouseX, double mouseY) {
        return false;
    }

    public boolean keyReleased(int keyCode, int scanCode, int modifiers, double mouseX, double mouseY) {
        return false;
    }

    public boolean charTyped(char codePoint, int modifiers, double mouseX, double mouseY) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public abstract void render(PoseStack var1, double var2, double var4, float var6);

    public boolean isVisible() {
        return this.shouldRender;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.isEnabled() && this.isInside(mouseX, mouseY)) {
            this.clickSound(Minecraft.m_91087_().m_91106_());
            this.onClick(mouseX, mouseY, button);
            return true;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (!this.isInside(mouseX, mouseY)) {
            return false;
        }
        this.isClicking = false;
        this.onRelease(mouseX, mouseY);
        return true;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double delta) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void mouseOver(PoseStack stack, double mouseX, double mouseY, float partialTicks) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clickSound(SoundManager handler) {
        handler.m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void update(double mouseX, double mouseY) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        this.onDrag(mouseX, mouseY, dragX, dragY);
        return true;
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public void setX(int x) {
        this.x = x;
        this.updateSize();
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public void setY(int y) {
        this.y = y;
        this.updateSize();
    }

    @Override
    public int getW() {
        return this.w;
    }

    @Override
    public void setW(int w) {
        this.w = w;
    }

    @Override
    public int getH() {
        return this.h;
    }

    @Override
    public void setH(int h) {
        this.h = h;
    }

    @Override
    public IGuiElement parent() {
        return this.parent;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void fillGradient(PoseStack matrixStack, int x1, int y1, int width, int height, int colorFrom, int colorTo) {
        RenderSystem.m_69472_();
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        Widget.fillGradient(matrixStack.m_85850_().m_85861_(), bufferbuilder, x1, y1, x1 + width, y1 + height, 0, colorFrom, colorTo);
        tesselator.m_85914_();
        RenderSystem.m_69461_();
        RenderSystem.m_69493_();
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void drawHoverText(List<Component> textLines, int x, int y, Font font, PoseStack matrixStack) {
        this.gui.screen.m_96597_(matrixStack, textLines, x, y);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int drawText(PoseStack matrixStack, Component text, float x, float y, int color) {
        return Minecraft.m_91087_().f_91062_.m_92889_(matrixStack, text, x, y, color);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void drawTexture(PoseStack stack, ResourceLocation loc, int left, int top, int x, int y, int sizeX, int sizeY) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)loc);
        GuiComponent.m_93143_((PoseStack)stack, (int)left, (int)top, (int)0, (float)x, (float)y, (int)sizeX, (int)sizeY, (int)256, (int)256);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void drawTexture(PoseStack stack, ResourceLocation loc, int left, int top, int x, int y, int sizeX, int sizeY, int textureHeight, int textureWidth) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)loc);
        GuiComponent.m_93143_((PoseStack)stack, (int)left, (int)top, (int)0, (float)x, (float)y, (int)sizeX, (int)sizeY, (int)textureHeight, (int)textureWidth);
    }

    public static WidgetSupplier builder(BiFunction<GuiInstance, IGuiElement, Widget> source) {
        return new WidgetSupplier(source);
    }

    @Generated
    public Component getMessage() {
        return this.message;
    }

    @Generated
    public void setMessage(Component message) {
        this.message = message;
    }

    @Generated
    public boolean isEnabled() {
        return this.enabled;
    }

    @Generated
    public void setDepth(int depth) {
        this.depth = depth;
    }
}

