/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.datagen.providers;

import net.minecraft.core.Registry;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.data.GTLibTags;
import org.gtreimagined.gtlib.datagen.IGTLibProvider;
import org.gtreimagined.gtlib.datagen.providers.GTTagProvider;
import org.gtreimagined.gtlib.fluid.GTFluid;
import org.gtreimagined.gtlib.fluid.GTMaterialFluid;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.material.MaterialTags;
import org.gtreimagined.gtlib.util.TagUtils;

public class GTFluidTagProvider
extends GTTagProvider<Fluid>
implements IGTLibProvider {
    private final boolean replace;

    public GTFluidTagProvider(String providerDomain, String providerName, boolean replace) {
        super(Registry.f_122822_, providerDomain, providerName, "fluids");
        this.replace = replace;
    }

    @Override
    protected void processTags(String domain) {
        GTAPI.all(GTFluid.class, domain).forEach(f -> {
            this.tag(TagUtils.getForgelikeFluidTag(f.getId())).add((Fluid)f.getFluid()).replace(this.replace);
            if (f instanceof GTMaterialFluid) {
                Material m = ((GTMaterialFluid)f).getMaterial();
                this.tag(TagUtils.getForgelikeFluidTag(m.getId())).add((Fluid)f.getFluid()).replace(this.replace);
                if (m.has(MaterialTags.ACID)) {
                    this.tag(GTLibTags.ACID).add((Fluid)f.getFluid());
                }
            }
        });
        if (domain.equals("antimatter_shared")) {
            this.tag(TagUtils.getForgelikeFluidTag("water")).add((Fluid)Fluids.f_76193_);
        }
    }
}

