/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.data;

import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.block.BlockFrame;
import org.gtreimagined.gtlib.block.BlockStorage;
import org.gtreimagined.gtlib.block.BlockSurfaceRock;
import org.gtreimagined.gtlib.cover.CoverFactory;
import org.gtreimagined.gtlib.cover.CoverPlate;
import org.gtreimagined.gtlib.data.GTLibMaterials;
import org.gtreimagined.gtlib.data.VanillaStoneTypes;
import org.gtreimagined.gtlib.fluid.GTFluid;
import org.gtreimagined.gtlib.fluid.GTMaterialFluid;
import org.gtreimagined.gtlib.item.CoverMaterialItem;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.material.MaterialItem;
import org.gtreimagined.gtlib.material.MaterialTags;
import org.gtreimagined.gtlib.material.MaterialType;
import org.gtreimagined.gtlib.material.MaterialTypeBlock;
import org.gtreimagined.gtlib.material.MaterialTypeFluid;
import org.gtreimagined.gtlib.material.MaterialTypeItem;
import org.gtreimagined.gtlib.ore.BlockOre;
import org.gtreimagined.gtlib.ore.BlockOreStone;
import org.gtreimagined.gtlib.ore.StoneType;
import org.gtreimagined.gtlib.texture.Texture;
import org.gtreimagined.gtlib.util.Utils;

public class GTMaterialTypes {
    public static MaterialTypeItem<?> DUST = new MaterialTypeItem("dust", 2, true, 18144000L);
    public static MaterialTypeItem<?> SMALL_DUST = new MaterialTypeItem("dust_small", 2, true, 4536000L);
    public static MaterialTypeItem<?> TINY_DUST = new MaterialTypeItem("dust_tiny", 2, true, 2016000L);
    public static MaterialTypeItem<?> IMPURE_DUST = new MaterialTypeItem("dust_impure", 2, true, -1L);
    public static MaterialTypeItem<?> PURE_DUST = new MaterialTypeItem("dust_pure", 2, true, -1L);
    public static MaterialTypeItem<?> CRUSHED_ORE = new MaterialTypeItem("crushed", 2, true, -1L);
    public static MaterialTypeItem<?> PURIFIED_ORE = new MaterialTypeItem("crushed_purified", 2, true, -1L);
    public static MaterialTypeItem<?> REFINED_ORE = new MaterialTypeItem("crushed_refined", 2, true, -1L);
    public static MaterialTypeItem<?> CHIPPED_GEM = new MaterialTypeItem("gem_chipped", 2, true, 4536000L);
    public static MaterialTypeItem<?> FLAWED_GEM = new MaterialTypeItem("gem_flawed", 2, true, 9072000L);
    public static MaterialTypeItem<?> GEM = new MaterialTypeItem("gem", 2, true, 18144000L);
    public static MaterialTypeItem<?> FLAWLESS_GEM = new MaterialTypeItem("gem_flawless", 2, true, 36288000L);
    public static MaterialTypeItem<?> EXQUISITE_GEM = new MaterialTypeItem("gem_exquisite", 2, true, 72576000L);
    public static MaterialTypeItem<?> NUGGET = new MaterialTypeItem("nugget", 2, true, 2016000L);
    public static MaterialTypeItem<?> CHUNK = new MaterialTypeItem("chunk", 2, true, 4536000L);
    public static MaterialTypeItem<?> INGOT = new MaterialTypeItem("ingot", 2, true, 18144000L);
    public static MaterialTypeItem<?> HOT_INGOT = new MaterialTypeItem("ingot_hot", 2, true, 18144000L);
    public static MaterialTypeItem<?> TINY_PLATE = new MaterialTypeItem("plate_tiny", 2, true, 2016000L);
    public static MaterialTypeItem<?> PLATE = new MaterialTypeItem("plate", 2, true, 18144000L, (a, b, c) -> CoverFactory.builder((u, v, t, w) -> new CoverPlate(u, v, t, w, b, c)).item((u, v) -> new CoverMaterialItem(u.getDomain(), (MaterialType<?>)b, (CoverFactory)u, c)).build("gtlib", "plate_" + c.getId()));
    public static MaterialTypeItem<?> DENSE_PLATE = new MaterialTypeItem("plate_dense", 2, true, 163296000L);
    public static MaterialTypeItem<MaterialTypeBlock.IOreGetter> BEARING_ROCK = new MaterialTypeItem("bearing_rock", 2, false, 4536000L, (domain, type, mat) -> {
        GTAPI.all(StoneType.class).stream().filter(StoneType::doesGenerateOre).forEach(s -> GTAPI.register(BlockSurfaceRock.class, new BlockSurfaceRock(domain, mat, (StoneType)s)));
        new MaterialItem(domain, type, mat);
    });
    public static MaterialTypeItem<MaterialTypeBlock.IBlockGetter> ROCK = new MaterialTypeItem("rock", 2, false, 4536000L, (domain, type, mat) -> {
        StoneType type1 = GTAPI.get(StoneType.class, mat.getId());
        if (type1 != null) {
            GTAPI.register(BlockSurfaceRock.class, new BlockSurfaceRock(domain, Material.NULL, type1));
        }
        new MaterialItem(domain, type, mat);
    });
    public static MaterialTypeItem<?> RAW_ORE = new MaterialTypeItem("raw_ore", 2, true, -1L);
    public static MaterialTypeItem<?> SMALL_GEAR = new MaterialTypeItem("gear_small", 2, true, 18144000L);
    public static MaterialTypeItem<?> GEAR = new MaterialTypeItem("gear", 2, true, 72576000L);
    public static MaterialTypeItem<?> ROTOR = new MaterialTypeItem("rotor", 2, true, 77112000L);
    public static MaterialTypeItem<?> ROD = new MaterialTypeItem("rod", 2, true, 9072000L);
    public static MaterialTypeItem<?> LONG_ROD = new MaterialTypeItem("rod_long", 2, true, 18144000L);
    public static MaterialTypeItem<?> SPRING = new MaterialTypeItem("spring", 2, true, 18144000L);
    public static MaterialTypeItem<?> LENS = new MaterialTypeItem("lens", 2, true, 13608000L);
    public static MaterialTypeItem<?> BOLT = new MaterialTypeItem("bolt", 2, true, 2268000L);
    public static MaterialTypeItem<?> SCREW = new MaterialTypeItem("screw", 2, true, 2268000L);
    public static MaterialTypeItem<?> RING = new MaterialTypeItem("ring", 2, true, 4536000L);
    public static MaterialTypeItem<?> FOIL = new MaterialTypeItem("foil", 2, true, 4536000L);
    public static MaterialTypeItem<?> ITEM_CASING = new MaterialTypeItem("casing_item", 1, true, 9072000L);
    public static MaterialTypeItem<?> FINE_WIRE = new MaterialTypeItem("wire_fine", 2, true, 2268000L);
    public static final MaterialTypeItem<?> SWORD_BLADE = new MaterialTypeItem("sword_blade", 2, true, 36288000L);
    public static final MaterialTypeItem<?> PICKAXE_HEAD = new MaterialTypeItem("pickaxe_head", 2, true, 54432000L);
    public static final MaterialTypeItem<?> SHOVEL_HEAD = new MaterialTypeItem("shovel_head", 2, true, 18144000L);
    public static final MaterialTypeItem<?> AXE_HEAD = new MaterialTypeItem("axe_head", 2, true, 54432000L);
    public static final MaterialTypeItem<?> HOE_HEAD = new MaterialTypeItem("hoe_head", 2, true, 36288000L);
    public static final MaterialTypeItem<?> HAMMER_HEAD = new MaterialTypeItem("hammer_head", 2, true, 108864000L);
    public static final MaterialTypeItem<?> FILE_HEAD = new MaterialTypeItem("file_head", 2, true, 36288000L);
    public static final MaterialTypeItem<?> KNIFE_BLADE = new MaterialTypeItem("knife_blade", 2, true, 18144000L);
    public static final MaterialTypeItem<?> SAW_BLADE = new MaterialTypeItem("saw_blade", 2, true, 36288000L);
    public static MaterialTypeItem<?> DRILL_BIT = new MaterialTypeItem("drill_bit", 2, true, 72576000L);
    public static MaterialTypeItem<?> CHAINSAW_BIT = new MaterialTypeItem("chainsaw_bit", 2, true, 36288000L);
    public static MaterialTypeItem<?> WRENCH_BIT = new MaterialTypeItem("wrench_bit", 2, true, 72576000L);
    public static final MaterialTypeItem<?> SCREWDRIVER_TIP = new MaterialTypeItem("screwdriver_tip", 2, true, 18144000L);
    public static final MaterialTypeItem<?> SCYTHE_BLADE = new MaterialTypeItem("scythe_blade", 2, true, 54432000L);
    public static MaterialTypeItem<?> BUZZSAW_BLADE = new MaterialTypeItem("buzzsaw_blade", 2, true, 72576000L);
    public static MaterialTypeBlock<MaterialTypeBlock.IOreGetter> ORE = new MaterialTypeBlock("ore", 1, true, -1L, (domain, type, mat) -> GTAPI.all(StoneType.class).stream().filter(StoneType::doesGenerateOre).filter(s -> !GTAPI.hasReplacement(((MaterialTypeBlock)type).getMaterialTag(mat, (StoneType)s))).forEach(s -> new BlockOre(domain, mat, (StoneType)s, type)));
    public static MaterialTypeBlock<MaterialTypeBlock.IOreGetter> SMALL_ORE = new MaterialTypeBlock("ore_small", 1, false, -1L, (domain, type, mat) -> GTAPI.all(StoneType.class).stream().filter(StoneType::doesGenerateOre).filter(s -> !GTAPI.hasReplacement(((MaterialTypeBlock)type).getMaterialTag(mat, (StoneType)s))).forEach(s -> new BlockOre(domain, mat, (StoneType)s, type)));
    public static MaterialTypeBlock<MaterialTypeBlock.IBlockGetter> ORE_STONE = new MaterialTypeBlock("ore_stone", 1, true, -1L, (domain, type, mat) -> new BlockOreStone(domain, mat));
    public static MaterialTypeBlock<MaterialTypeBlock.IBlockGetter> BLOCK = new MaterialTypeBlock("block", 1, false, 163296000L, BlockStorage::new);
    public static MaterialTypeBlock<MaterialTypeBlock.IBlockGetter> RAW_ORE_BLOCK = new MaterialTypeBlock("raw_ore_block", 2, false, -1L, BlockStorage::new);
    public static MaterialTypeBlock<MaterialTypeBlock.IBlockGetter> FRAME = new MaterialTypeBlock("frame", 1, true, 36288000L, BlockFrame::new);
    public static MaterialTypeFluid<MaterialTypeFluid.IFluidGetter> LIQUID = new MaterialTypeFluid("liquid", 1, true, -1L);
    public static MaterialTypeFluid<MaterialTypeFluid.IFluidGetter> GAS = new MaterialTypeFluid("gas", 1, true, -1L);
    public static final BiFunction<MaterialType<?>, Material, String> UNSPLIT_FUNCTION = (t, m) -> m.getDisplayNameString() + " " + Utils.lowerUnderscoreToUpperSpaced(t.getId());

    public static void init() {
        GTMaterialTypes.replacements();
        GTMaterialTypes.dependents();
        Function<Material, String> d = m -> m.has(MaterialTags.RUBBERTOOLS) ? "Pulp" : "Dust";
        DUST.setLang(m -> m.getDisplayNameString() + " " + (String)d.apply((Material)m));
        TINY_DUST.setLang(m -> "Tiny " + m.getDisplayNameString() + " " + (String)d.apply((Material)m)).setHidden();
        SMALL_DUST.setLang(m -> "Small " + m.getDisplayNameString() + " " + (String)d.apply((Material)m)).setHidden();
        IMPURE_DUST.setLang(m -> "Impure " + m.getDisplayNameString() + " " + (String)d.apply((Material)m));
        PURE_DUST.setLang(m -> "Pure " + m.getDisplayNameString() + " " + (String)d.apply((Material)m));
        Function<Material, String> n = m -> m.getElement() != null ? "Native " : "";
        BEARING_ROCK.unSplitName().setLang(m -> (String)n.apply((Material)m) + m.getDisplayNameString() + " Bearing Rock").setIgnoreTextureSets();
        ROCK.unSplitName().setIgnoreTextureSets();
        CRUSHED_ORE.setLang(m -> "Crushed " + (String)n.apply((Material)m) + m.getDisplayNameString() + " Ore");
        PURIFIED_ORE.setLang(m -> "Purified " + (String)n.apply((Material)m) + m.getDisplayNameString() + " Ore");
        REFINED_ORE.setLang(m -> "Refined " + (String)n.apply((Material)m) + m.getDisplayNameString() + " Ore");
        RAW_ORE.unSplitName().setLang(m -> "Raw " + (String)n.apply((Material)m) + m.getDisplayNameString());
        INGOT.setLang(m -> m.getDisplayNameString() + " " + (m.has(MaterialTags.RUBBERTOOLS) ? "Bar" : "Ingot"));
        NUGGET.setLang(m -> m.getDisplayNameString() + " " + (m.has(MaterialTags.RUBBERTOOLS) ? "Chip" : "Nugget"));
        GEM.setLang(Material::getDisplayNameString);
        EXQUISITE_GEM.setLang(m -> "Exquisite " + m.getDisplayNameString());
        FLAWLESS_GEM.setLang(m -> "Flawless " + m.getDisplayNameString());
        FLAWED_GEM.setLang(m -> "Flawed " + m.getDisplayNameString());
        CHIPPED_GEM.setLang(m -> "Chipped " + m.getDisplayNameString());
        Function<Material, String> p = m -> m == GTLibMaterials.Wood ? "Plank" : (m.has(MaterialTags.RUBBERTOOLS) ? "Sheet" : "Plate");
        PLATE.setLang(m -> m.getDisplayNameString() + " " + (String)p.apply((Material)m));
        DENSE_PLATE.setLang(m -> "Dense " + m.getDisplayNameString() + " " + (String)p.apply((Material)m));
        TINY_PLATE.setLang(m -> "Tiny " + m.getDisplayNameString() + " " + (String)p.apply((Material)m));
        ITEM_CASING.setLang(m -> m.getDisplayNameString() + " Item Casings");
        FOIL.setLang(m -> (m.has(MaterialTags.RUBBERTOOLS) ? "Thin " : "") + m.getDisplayNameString() + " " + (m.has(MaterialTags.RUBBERTOOLS) ? "Sheet" : "Foil"));
        FINE_WIRE.setIgnoreTextureSets();
        DRILL_BIT.unSplitName().setLang(UNSPLIT_FUNCTION).setIgnoreTextureSets();
        CHAINSAW_BIT.unSplitName().setLang(UNSPLIT_FUNCTION).setIgnoreTextureSets();
        WRENCH_BIT.unSplitName().setLang(UNSPLIT_FUNCTION).setIgnoreTextureSets();
        BUZZSAW_BLADE.unSplitName().setLang(UNSPLIT_FUNCTION).setIgnoreTextureSets();
        PICKAXE_HEAD.unSplitName().setLang(UNSPLIT_FUNCTION).setIgnoreTextureSets();
        SHOVEL_HEAD.unSplitName().setLang(UNSPLIT_FUNCTION).setIgnoreTextureSets();
        SWORD_BLADE.unSplitName().setLang(UNSPLIT_FUNCTION).setIgnoreTextureSets();
        AXE_HEAD.unSplitName().setLang(UNSPLIT_FUNCTION).setIgnoreTextureSets();
        HOE_HEAD.unSplitName().setLang(UNSPLIT_FUNCTION).setIgnoreTextureSets();
        KNIFE_BLADE.unSplitName().setLang(UNSPLIT_FUNCTION).setIgnoreTextureSets();
        HAMMER_HEAD.unSplitName().setLang(UNSPLIT_FUNCTION).setIgnoreTextureSets();
        FILE_HEAD.unSplitName().setLang(UNSPLIT_FUNCTION).setIgnoreTextureSets();
        SAW_BLADE.unSplitName().setLang(UNSPLIT_FUNCTION).setIgnoreTextureSets();
        SCREWDRIVER_TIP.unSplitName().setLang(UNSPLIT_FUNCTION).setIgnoreTextureSets();
        SCYTHE_BLADE.unSplitName().setLang(UNSPLIT_FUNCTION).setIgnoreTextureSets();
        RAW_ORE_BLOCK.unSplitName().setLang(m -> "Block of Raw " + (String)n.apply((Material)m) + m.getDisplayNameString());
        BLOCK.setLang(m -> "Block of " + m.getDisplayNameString());
    }

    private static void replacements() {
        NUGGET.replacement(GTLibMaterials.Iron, () -> Items.f_42749_);
        NUGGET.replacement(GTLibMaterials.Gold, () -> Items.f_42587_);
        INGOT.replacement(GTLibMaterials.Iron, () -> Items.f_42416_);
        INGOT.replacement(GTLibMaterials.Gold, () -> Items.f_42417_);
        INGOT.replacement(GTLibMaterials.Netherite, () -> Items.f_42418_);
        INGOT.replacement(GTLibMaterials.Copper, () -> Items.f_151052_);
        INGOT.replacement(GTLibMaterials.NetheriteScrap, () -> Items.f_42419_);
        DUST.replacement(GTLibMaterials.Redstone, () -> Items.f_42451_);
        DUST.replacement(GTLibMaterials.Glowstone, () -> Items.f_42525_);
        DUST.replacement(GTLibMaterials.Blaze, () -> Items.f_42593_);
        DUST.replacement(GTLibMaterials.Sugar, () -> Items.f_42501_);
        RAW_ORE.replacement(GTLibMaterials.Iron, () -> Items.f_151050_);
        RAW_ORE.replacement(GTLibMaterials.Copper, () -> Items.f_151051_);
        RAW_ORE.replacement(GTLibMaterials.Gold, () -> Items.f_151053_);
        GEM.replacement(GTLibMaterials.Flint, () -> Items.f_42484_);
        GEM.replacement(GTLibMaterials.Diamond, () -> Items.f_42415_);
        GEM.replacement(GTLibMaterials.Emerald, () -> Items.f_42616_);
        GEM.replacement(GTLibMaterials.Lapis, () -> Items.f_42534_);
        GEM.replacement(GTLibMaterials.Quartz, () -> Items.f_42692_);
        GEM.replacement(GTLibMaterials.Coal, () -> Items.f_42413_);
        GEM.replacement(GTLibMaterials.Charcoal, () -> Items.f_42414_);
        GEM.replacement(GTLibMaterials.EnderEye, () -> Items.f_42545_);
        GEM.replacement(GTLibMaterials.EnderPearl, () -> Items.f_42584_);
        ROD.replacement(GTLibMaterials.Blaze, () -> Items.f_42585_);
        ROD.replacement(GTLibMaterials.Bone, () -> Items.f_42500_);
        ROD.replacement(GTLibMaterials.Wood, () -> Items.f_42398_);
        BLOCK.replacement(GTLibMaterials.Coal, () -> Items.f_42200_);
        BLOCK.replacement(GTLibMaterials.Iron, () -> Items.f_41913_);
        BLOCK.replacement(GTLibMaterials.Copper, () -> Items.f_151000_);
        BLOCK.replacement(GTLibMaterials.Gold, () -> Items.f_41912_);
        BLOCK.replacement(GTLibMaterials.Diamond, () -> Items.f_41959_);
        BLOCK.replacement(GTLibMaterials.Emerald, () -> Items.f_42110_);
        BLOCK.replacement(GTLibMaterials.Lapis, () -> Items.f_41854_);
        BLOCK.replacement(GTLibMaterials.Netherite, () -> Items.f_42791_);
        RAW_ORE_BLOCK.replacement(GTLibMaterials.Iron, () -> Items.f_150995_);
        RAW_ORE_BLOCK.replacement(GTLibMaterials.Copper, () -> Items.f_150996_);
        RAW_ORE_BLOCK.replacement(GTLibMaterials.Gold, () -> Items.f_150997_);
        ORE.replacement(GTLibMaterials.Coal, VanillaStoneTypes.STONE, () -> Items.f_41835_);
        ORE.replacement(GTLibMaterials.Coal, VanillaStoneTypes.DEEPSLATE, () -> Items.f_150963_);
        ORE.replacement(GTLibMaterials.Iron, VanillaStoneTypes.STONE, () -> Items.f_41834_);
        ORE.replacement(GTLibMaterials.Iron, VanillaStoneTypes.DEEPSLATE, () -> Items.f_150964_);
        ORE.replacement(GTLibMaterials.Copper, VanillaStoneTypes.STONE, () -> Items.f_150965_);
        ORE.replacement(GTLibMaterials.Copper, VanillaStoneTypes.DEEPSLATE, () -> Items.f_150966_);
        ORE.replacement(GTLibMaterials.Gold, VanillaStoneTypes.STONE, () -> Items.f_41833_);
        ORE.replacement(GTLibMaterials.Gold, VanillaStoneTypes.DEEPSLATE, () -> Items.f_150967_);
        ORE.replacement(GTLibMaterials.Redstone, VanillaStoneTypes.STONE, () -> Items.f_41977_);
        ORE.replacement(GTLibMaterials.Redstone, VanillaStoneTypes.DEEPSLATE, () -> Items.f_150968_);
        ORE.replacement(GTLibMaterials.Emerald, VanillaStoneTypes.STONE, () -> Items.f_42107_);
        ORE.replacement(GTLibMaterials.Emerald, VanillaStoneTypes.DEEPSLATE, () -> Items.f_150969_);
        ORE.replacement(GTLibMaterials.Lapis, VanillaStoneTypes.STONE, () -> Items.f_41853_);
        ORE.replacement(GTLibMaterials.Lapis, VanillaStoneTypes.DEEPSLATE, () -> Items.f_150993_);
        ORE.replacement(GTLibMaterials.Diamond, VanillaStoneTypes.STONE, () -> Items.f_42010_);
        ORE.replacement(GTLibMaterials.Diamond, VanillaStoneTypes.DEEPSLATE, () -> Items.f_150994_);
        ORE.replacement(GTLibMaterials.Quartz, VanillaStoneTypes.NETHERRACK, () -> Items.f_42154_);
    }

    private static void dependents() {
        ROTOR.dependents(PLATE, SCREW, RING);
        SCREW.dependents(BOLT);
        BOLT.dependents(ROD);
        RING.dependents(ROD);
        LONG_ROD.dependents(ROD);
        CRUSHED_ORE.dependents(PURIFIED_ORE, REFINED_ORE, IMPURE_DUST);
        PURE_DUST.dependents(DUST);
        IMPURE_DUST.dependents(PURE_DUST);
        DUST.dependents(SMALL_DUST, TINY_DUST);
        SMALL_GEAR.dependents(PLATE);
        GEAR.dependents(PLATE, ROD);
        EXQUISITE_GEM.dependents(FLAWLESS_GEM, FLAWED_GEM, CHIPPED_GEM, GEM);
    }

    public static void postInit() {
        LIQUID.all().stream().filter(l -> !l.getId().equals("water") && !l.getId().equals("lava")).forEach(m -> GTAPI.register(GTFluid.class, new GTMaterialFluid("antimatter_shared", (Material)m, (MaterialType<?>)LIQUID)));
        GAS.all().forEach(m -> GTAPI.register(GTFluid.class, new GTMaterialFluid("antimatter_shared", (Material)m, (MaterialType<?>)GAS)));
        ORE_STONE.all().forEach(m -> GTAPI.register(StoneType.class, new StoneType("gtlib", m.getId(), (Material)m, new Texture(m.materialDomain(), "block/stone/" + m.getId()), SoundType.f_56742_, false).setGenerateOre(false).setStateSupplier(() -> ((MaterialTypeBlock.IBlockGetter)ORE_STONE.get()).get((Material)m).asState())));
    }

    static {
        BEARING_ROCK.set((m, s) -> {
            if (m == null || s == null || !s.doesGenerateOre() || !BEARING_ROCK.allowGen(m)) {
                return MaterialTypeBlock.getEmptyBlockAndLog(BEARING_ROCK, m, s);
            }
            BlockSurfaceRock rock = GTAPI.get(BlockSurfaceRock.class, "surface_rock_" + m.getId() + "_" + s.getId());
            return new MaterialTypeBlock.Container(rock != null ? rock.m_49966_() : Blocks.f_50016_.m_49966_());
        });
        ROCK.set(m -> {
            StoneType s = GTAPI.get(StoneType.class, m.getId());
            if (s == null || !ROCK.allowGen(m)) {
                return MaterialTypeBlock.getEmptyBlockAndLog(ROCK, m, s);
            }
            BlockSurfaceRock rock = GTAPI.get(BlockSurfaceRock.class, "surface_rock_" + s.getId());
            return new MaterialTypeBlock.Container(rock != null ? rock.m_49966_() : Blocks.f_50016_.m_49966_());
        });
        ORE.set((m, s) -> {
            Item item;
            if (m != null && s != null && (item = GTAPI.getReplacement(ORE, m, s, new String[0])) instanceof BlockItem) {
                return new MaterialTypeBlock.Container(((BlockItem)item).m_40614_().m_49966_());
            }
            if (m == null || s == null || !s.doesGenerateOre() || !ORE.allowGen(m)) {
                return MaterialTypeBlock.getEmptyBlockAndLog(ORE, m, s);
            }
            BlockOre block = GTAPI.get(BlockOre.class, ORE.getId() + "_" + m.getId() + "_" + s.getId());
            return new MaterialTypeBlock.Container(block != null ? block.m_49966_() : Blocks.f_50016_.m_49966_());
        }).blockType();
        SMALL_ORE.set((m, s) -> {
            Item item;
            if (m != null && s != null && (item = GTAPI.getReplacement(SMALL_ORE, m, s, new String[0])) instanceof BlockItem) {
                return new MaterialTypeBlock.Container(((BlockItem)item).m_40614_().m_49966_());
            }
            if (m == null || s == null || !SMALL_ORE.allowGen(m)) {
                return MaterialTypeBlock.getEmptyBlockAndLog(SMALL_ORE, m, s);
            }
            BlockOre block = GTAPI.get(BlockOre.class, SMALL_ORE.getId() + "_" + m.getId() + "_" + Utils.getConventionalStoneType(s));
            return new MaterialTypeBlock.Container(block != null ? block.m_49966_() : Blocks.f_50016_.m_49966_());
        }).blockType();
        ORE_STONE.set(m -> {
            if (m == null || !ORE_STONE.allowGen(m)) {
                return MaterialTypeBlock.getEmptyBlockAndLog(ORE_STONE, m);
            }
            BlockOreStone block = GTAPI.get(BlockOreStone.class, ORE_STONE.getId() + "_" + m.getId());
            return new MaterialTypeBlock.Container(block != null ? block.m_49966_() : Blocks.f_50016_.m_49966_());
        }).blockType();
        BLOCK.set(m -> {
            Item item;
            if (m != null && (item = GTAPI.getReplacement(BLOCK, m, new String[0])) instanceof BlockItem) {
                return new MaterialTypeBlock.Container(((BlockItem)item).m_40614_().m_49966_());
            }
            if (m == null || !BLOCK.allowGen(m)) {
                return MaterialTypeBlock.getEmptyBlockAndLog(BLOCK, m);
            }
            BlockStorage block = GTAPI.get(BlockStorage.class, BLOCK.getId() + "_" + m.getId());
            return new MaterialTypeBlock.Container(block != null ? block.m_49966_() : Blocks.f_50016_.m_49966_());
        }).blockType();
        RAW_ORE_BLOCK.set(m -> {
            Item item;
            if (m != null && (item = GTAPI.getReplacement(RAW_ORE_BLOCK, m, new String[0])) instanceof BlockItem) {
                return new MaterialTypeBlock.Container(((BlockItem)item).m_40614_().m_49966_());
            }
            if (m == null || !RAW_ORE_BLOCK.allowGen(m)) {
                return MaterialTypeBlock.getEmptyBlockAndLog(RAW_ORE_BLOCK, m);
            }
            BlockStorage block = GTAPI.get(BlockStorage.class, RAW_ORE_BLOCK.getId() + "_" + m.getId());
            return new MaterialTypeBlock.Container(block != null ? block.m_49966_() : Blocks.f_50016_.m_49966_());
        }).blockType();
        FRAME.set(m -> {
            if (m == null || !FRAME.allowGen(m)) {
                return MaterialTypeBlock.getEmptyBlockAndLog(FRAME, m);
            }
            BlockFrame block = GTAPI.get(BlockFrame.class, FRAME.getId() + "_" + m.getId());
            return new MaterialTypeBlock.Container(block != null ? block.m_49966_() : Blocks.f_50016_.m_49966_());
        }).blockType();
        LIQUID.set((m, i) -> {
            if (m == null || !LIQUID.allowGen(m)) {
                return MaterialTypeFluid.getEmptyFluidAndLog(LIQUID, m);
            }
            if (m.getId().equals("water")) {
                return new FluidStack((Fluid)Fluids.f_76193_, i);
            }
            if (m.getId().equals("lava")) {
                return new FluidStack((Fluid)Fluids.f_76195_, i);
            }
            GTFluid fluid = GTAPI.get(GTFluid.class, LIQUID.getId() + "_" + m.getId());
            if (fluid == null) {
                throw new IllegalStateException("Tried to get null fluid");
            }
            return new FluidStack((Fluid)fluid.getFluid(), i);
        });
        GAS.set((m, i) -> {
            if (m == null || !GAS.allowGen(m)) {
                return MaterialTypeFluid.getEmptyFluidAndLog(GAS, m);
            }
            GTFluid fluid = GTAPI.get(GTFluid.class, GAS.getId() + "_" + m.getId());
            if (fluid == null) {
                throw new IllegalStateException("Tried to get null fluid");
            }
            return new FluidStack((Fluid)fluid.getFluid(), i);
        });
    }
}

