/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.client.model.loader;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import org.gtreimagined.gtlib.client.model.GTGroupedModel;
import org.gtreimagined.gtlib.client.model.VanillaProxy;
import org.gtreimagined.gtlib.client.model.loader.GTModelLoader;
import org.jetbrains.annotations.NotNull;

public class BlockBenchLoader
extends GTModelLoader<GTGroupedModel> {
    public BlockBenchLoader(ResourceLocation loc) {
        super(loc);
    }

    @NotNull
    public GTGroupedModel read(JsonDeserializationContext context, JsonObject json) {
        try {
            ResourceLocation particle = json.has("particle") ? new ResourceLocation(json.get("particle").getAsString()) : MissingTextureAtlasSprite.m_118071_();
            Object2ObjectOpenHashMap offsets = new Object2ObjectOpenHashMap();
            if (json.has("groups")) {
                for (JsonElement jsonelement : GsonHelper.m_13933_((JsonObject)json, (String)"groups")) {
                    if (!jsonelement.isJsonObject()) continue;
                    JsonObject obj = jsonelement.getAsJsonObject();
                    String name = obj.get("name").getAsString();
                    JsonArray children = obj.get("children").getAsJsonArray();
                    for (JsonElement child : children) {
                        offsets.put(child.getAsInt(), name);
                    }
                }
            }
            Object2ObjectOpenHashMap map = new Object2ObjectOpenHashMap();
            if (json.has("elements")) {
                int index = 0;
                for (JsonElement jsonelement : GsonHelper.m_13933_((JsonObject)json, (String)"elements")) {
                    String name;
                    map.computeIfAbsent((name = (String)offsets.get(index++)) == null ? "" : name, a -> new ObjectArrayList()).add((BlockElement)context.deserialize(jsonelement, BlockElement.class));
                }
            }
            return new GTGroupedModel(particle, map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, k -> new VanillaProxy((List)k.getValue()))));
        }
        catch (Exception e) {
            throw new RuntimeException("Caught error deserializing model : " + e);
        }
    }
}

