/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.tool;

import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.gtreimagined.gtlib.datagen.builder.GTItemModelBuilder;
import org.gtreimagined.gtlib.datagen.providers.GTItemModelProvider;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.material.MaterialTags;
import org.gtreimagined.gtlib.registration.IColorHandler;
import org.gtreimagined.gtlib.registration.IGTObject;
import org.gtreimagined.gtlib.registration.IModelProvider;
import org.gtreimagined.gtlib.registration.ITextureProvider;
import org.gtreimagined.gtlib.texture.Texture;
import org.gtreimagined.gtlib.tool.IAbstractToolMethods;
import org.gtreimagined.gtlib.tool.armor.GTArmorType;
import org.jetbrains.annotations.Nullable;

public interface IGTArmor
extends IGTObject,
IColorHandler,
ITextureProvider,
IModelProvider,
IAbstractToolMethods {
    public GTArmorType getGTArmorType();

    public Material getMat();

    public ItemStack asItemStack();

    default public Item getItem() {
        return (Item)this;
    }

    default public ItemStack resolveStack() {
        Item item = (Item)this;
        ItemStack stack = new ItemStack((ItemLike)item);
        ImmutableMap<Enchantment, Integer> mainEnchants = MaterialTags.ARMOR.get(this.getMat()).toolEnchantment();
        if (!mainEnchants.isEmpty()) {
            mainEnchants.entrySet().stream().filter(e -> ((Enchantment)e.getKey()).m_6081_(stack)).forEach(e -> stack.m_41663_((Enchantment)e.getKey(), ((Integer)e.getValue()).intValue()));
            return stack;
        }
        return stack;
    }

    default public void onGenericAddInformation(ItemStack stack, List<Component> tooltip, TooltipFlag flag) {
        if (this.getGTArmorType().getTooltip().size() != 0) {
            tooltip.addAll(this.getGTArmorType().getTooltip());
        }
    }

    @Override
    default public int getItemColor(ItemStack stack, @Nullable Block block, int i) {
        return i == 0 && this.getMat() != null ? this.getMat().getRGB() : -1;
    }

    @Override
    default public Texture[] getTextures() {
        ObjectArrayList textures = new ObjectArrayList();
        int layers = this.getGTArmorType().getOverlayLayers();
        textures.add(new Texture("gtlib", "item/tool/".concat(this.getGTArmorType().getId())));
        if (layers == 1) {
            textures.add(new Texture("gtlib", "item/tool/overlay/".concat(this.getGTArmorType().getId())));
        }
        if (layers > 1) {
            for (int i = 1; i <= layers; ++i) {
                textures.add(new Texture("gtlib", String.join((CharSequence)"", "item/tool/overlay/", this.getGTArmorType().getId(), "_", Integer.toString(i))));
            }
        }
        return textures.toArray(new Texture[textures.size()]);
    }

    @Override
    default public void onItemModelBuild(ItemLike item, GTItemModelProvider prov) {
        if (this.getGTArmorType().getSlot() == EquipmentSlot.HEAD) {
            String id = this.getId();
            GTItemModelBuilder builder = (GTItemModelBuilder)prov.getBuilder(id + "_probe");
            builder.parent(new ResourceLocation("minecraft", "item/handheld"));
            Texture[] textures = this.getTextures();
            for (int i = 0; i < textures.length + 1; ++i) {
                if (i == textures.length) {
                    builder.texture("layer" + i, new Texture("gtlib", "item/tool/overlay/".concat(this.getGTArmorType().getId()).concat("_probe")));
                    continue;
                }
                builder.texture("layer" + i, textures[i]);
            }
            prov.tex(item, "minecraft:item/handheld", (ResourceLocation[])this.getTextures()).override().predicate(new ResourceLocation("gtlib", "probe"), 1.0f).model(new ResourceLocation("antimatter_shared", "item/" + id + "_probe")).end();
            return;
        }
        prov.tex(item, "minecraft:item/handheld", (ResourceLocation[])this.getTextures());
    }
}

