/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.structure;

import com.google.common.collect.ImmutableMap;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import it.unimi.dsi.fastutil.Pair;
import java.util.Map;
import java.util.function.BiFunction;
import lombok.Generated;
import org.gtreimagined.gtlib.blockentity.multi.BlockEntityBasicMultiMachine;
import org.gtreimagined.gtlib.util.int2;
import org.gtreimagined.gtlib.util.int3;

public class Structure<T extends BlockEntityBasicMultiMachine<T>> {
    private final IStructureDefinition<T> structureDefinition;
    private final Map<String, Pair<Integer, Integer>> minMaxMap;
    private final Map<String, Pair<int2, BiFunction<Integer, int3, int3>>> partRequirements;
    private final int3 offset;
    StructurePartCheckCallback<T> callback;

    protected Structure(IStructureDefinition<T> structureDefinition, ImmutableMap<String, Pair<int2, BiFunction<Integer, int3, int3>>> partRequirements, ImmutableMap<String, Pair<Integer, Integer>> minMaxMap, int3 offset, StructurePartCheckCallback<T> callback) {
        this.structureDefinition = structureDefinition;
        this.partRequirements = partRequirements;
        this.minMaxMap = minMaxMap;
        this.offset = offset;
        this.callback = callback;
    }

    public boolean check(T tile) {
        int i = 0;
        int successful = 0;
        block0: for (Map.Entry<String, Pair<int2, BiFunction<Integer, int3, int3>>> entry : this.partRequirements.entrySet()) {
            String s = entry.getKey();
            Pair<int2, BiFunction<Integer, int3, int3>> v = entry.getValue();
            for (int j = 0; j < ((int2)v.left()).y; ++j) {
                int3 newOffset = (int3)((Object)((BiFunction)v.right()).apply(i, this.offset.copy()));
                boolean success = this.callback.check(this.structureDefinition, tile, s, i, newOffset);
                if (success) {
                    ++successful;
                }
                if (j >= ((int2)v.left()).x && !success) continue block0;
                ++i;
            }
        }
        return i == successful;
    }

    @Generated
    public IStructureDefinition<T> getStructureDefinition() {
        return this.structureDefinition;
    }

    @Generated
    public Map<String, Pair<Integer, Integer>> getMinMaxMap() {
        return this.minMaxMap;
    }

    public static interface StructurePartCheckCallback<T extends BlockEntityBasicMultiMachine<T>> {
        public boolean check(IStructureDefinition<T> var1, T var2, String var3, int var4, int3 var5);
    }
}

