/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.material;

import com.google.common.collect.HashBiMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Supplier;
import lombok.Generated;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.IForgeRegistry;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.material.MaterialType;
import org.gtreimagined.gtlib.ore.StoneType;
import org.gtreimagined.gtlib.recipe.ingredient.RecipeIngredient;
import org.gtreimagined.gtlib.registration.IGTObject;
import org.gtreimagined.gtlib.util.TagUtils;
import org.gtreimagined.gtlib.util.Utils;

public class MaterialTypeBlock<T>
extends MaterialType<T> {
    protected final Map<Material, Map<StoneType, Supplier<Item>>> oreReplacements = HashBiMap.create();
    private final BlockSupplier supplier;

    public MaterialTypeBlock(String id, int layers, boolean visible, long unitValue, BlockSupplier supplier) {
        super(id, layers, visible, unitValue);
        GTAPI.register(MaterialTypeBlock.class, this);
        this.supplier = supplier;
    }

    public void replacement(Material mat, StoneType type, Supplier<Item> replacement) {
        if (!mat.enabled) {
            return;
        }
        if (this.get() instanceof IOreGetter) {
            Map subMap = this.oreReplacements.computeIfAbsent(mat, m -> new Object2ObjectArrayMap());
            subMap.put(type, replacement);
            this.add(mat);
            GTAPI.addReplacement(this.getMaterialTag(mat, type), replacement);
        }
    }

    public static Container getEmptyBlockAndLog(MaterialType<?> type, IGTObject ... objects) {
        Utils.onInvalidData("Tried to create " + type.getId() + " for objects: " + Arrays.toString(Arrays.stream(objects).map(IGTObject::getId).toArray(String[]::new)));
        return new Container(Blocks.f_50016_.m_49966_());
    }

    @Override
    public RecipeIngredient getMaterialIngredient(Material m, int count) {
        return RecipeIngredient.of(this.getMaterialTag(m), count);
    }

    public RecipeIngredient getMaterialIngredient(Material m, StoneType s, int count) {
        return RecipeIngredient.of(this.getMaterialTag(m, s), count);
    }

    public TagKey<Block> getBlockMaterialTag(Material m) {
        return TagUtils.getForgelikeBlockTag(String.join((CharSequence)"", Utils.getConventionalMaterialType(this), "/", this.getId().equals("raw_ore_block") ? "raw_" : "", m.getId()));
    }

    public TagKey<Item> getMaterialTag(Material m, StoneType s) {
        if (!(this.get() instanceof IOreGetter)) {
            return this.getMaterialTag(m);
        }
        return TagUtils.getForgelikeItemTag(s.getId() + "_" + Utils.getConventionalMaterialType(this) + "/" + m.getId());
    }

    public boolean allowBlockGen(Material material) {
        return !this.replacements.containsKey((Object)material) && this.allowGen(material);
    }

    @Override
    public void onRegistryBuild(IForgeRegistry<?> registry) {
        super.onRegistryBuild(registry);
        if (this.doRegister()) {
            for (Material material : this.materials) {
                if (!material.enabled || !this.allowBlockGen(material)) continue;
                this.supplier.createBlocks(material.materialDomain(), this, material);
            }
        }
    }

    @Generated
    public Map<Material, Map<StoneType, Supplier<Item>>> getOreReplacements() {
        return this.oreReplacements;
    }

    public static interface BlockSupplier {
        public void createBlocks(String var1, MaterialType<?> var2, Material var3);
    }

    public static interface IOreGetter {
        public Container get(Material var1, StoneType var2);
    }

    public static class Container {
        protected BlockState state;

        public Container(BlockState state) {
            this.state = state;
        }

        public BlockState asState() {
            return this.state;
        }

        public Block asBlock() {
            return this.state.m_60734_();
        }

        public Item asItem() {
            return this.asBlock().m_5456_();
        }

        public ItemStack asStack(int count) {
            return new ItemStack((ItemLike)this.asItem(), count);
        }

        public ItemStack asStack() {
            return this.asStack(1);
        }

        public RecipeIngredient asIngredient() {
            return RecipeIngredient.of(this.asStack(1));
        }
    }

    public static interface IBlockGetter {
        public Container get(Material var1);
    }
}

