/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.gui.container;

import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.gtreimagined.gtlib.cover.ICover;
import org.gtreimagined.gtlib.gui.MenuHandlerCover;
import org.gtreimagined.gtlib.gui.SlotData;
import org.gtreimagined.gtlib.gui.container.GTContainer;

public class ContainerCover
extends GTContainer {
    protected BlockEntity onEntity;
    private final ICover c;
    private final MenuHandlerCover<?> m;

    public ContainerCover(ICover on, Inventory playerInv, MenuHandlerCover<?> menuHandler, int windowId) {
        super(on, menuHandler.getContainerType(), windowId, playerInv, ContainerCover.getInvSize(on));
        this.c = on;
        this.m = menuHandler;
        this.addSlots(this.c);
        if (this.c.getGui().enablePlayerSlots()) {
            this.addPlayerSlots();
        }
        this.onEntity = (BlockEntity)Objects.requireNonNull(on.source().getTile());
    }

    private static int getInvSize(ICover cover) {
        if (cover.getGui().getSlots() != null) {
            List<SlotData<?>> slots = cover.getTier() == null ? cover.getGui().getSlots().getAnySlots() : cover.getGui().getSlots().getSlots(cover.getTier());
            return slots.size();
        }
        return 0;
    }

    protected void addSlots(ICover cover) {
        Object2IntOpenHashMap slotIndexMap = new Object2IntOpenHashMap();
        if (cover.getGui().getSlots() != null) {
            List<SlotData<?>> slots = cover.getTier() == null ? cover.getGui().getSlots().getAnySlots() : cover.getGui().getSlots().getSlots(cover.getTier());
            for (SlotData<?> slot : slots) {
                slotIndexMap.computeIntIfAbsent((Object)slot.getType().getId(), k -> 0);
                Object supplier = slot.getType().getSlotSupplier().get(slot.getType(), cover, cover.getAll(), slotIndexMap.getInt((Object)slot.getType().getId()), slot);
                this.m_38897_((Slot)supplier);
                slotIndexMap.computeInt((Object)slot.getType().getId(), (a, b) -> {
                    if (b == null) {
                        return 0;
                    }
                    return b + 1;
                });
            }
        }
    }

    public ICover getCover() {
        return this.c;
    }

    public boolean m_6875_(Player playerIn) {
        return ContainerCover.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)this.onEntity.m_58904_(), (BlockPos)this.onEntity.m_58899_()), (Player)playerIn, (Block)this.onEntity.m_58900_().m_60734_());
    }
}

