/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.cover;

import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import lombok.Generated;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.gtreimagined.gtlib.Data;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.GTRemapping;
import org.gtreimagined.gtlib.capability.ICoverHandler;
import org.gtreimagined.gtlib.cover.ICover;
import org.gtreimagined.gtlib.gui.MenuHandler;
import org.gtreimagined.gtlib.machine.Tier;
import org.gtreimagined.gtlib.registration.IGTObject;
import org.gtreimagined.gtlib.texture.Texture;
import org.jetbrains.annotations.Nullable;

public class CoverFactory
implements IGTObject {
    final String id;
    final String domain;
    private final CoverSupplier supplier;
    private Map<Tier, Item> itemStacks = Collections.emptyMap();
    private Item itemStack;
    private List<Texture> textures;
    private MenuHandler<?> menuHandler = Data.COVER_MENU_HANDLER;
    private Predicate<BlockEntity> isValid = b -> true;
    protected boolean gui = false;

    protected CoverFactory(String domain, String id, CoverSupplier supplier) {
        this.id = id;
        this.supplier = supplier;
        this.domain = domain;
        GTAPI.register(CoverFactory.class, this);
    }

    public final CoverSupplier get() {
        return this.supplier;
    }

    public ItemStack getItem(Tier tier) {
        return tier == null ? this.getItem() : this.itemStacks.getOrDefault(tier, Items.f_41852_).m_7968_();
    }

    public Tier getValidTier() {
        return this.itemStacks.size() > 1 ? this.itemStacks.keySet().iterator().next() : null;
    }

    public List<Texture> getTextures() {
        return this.textures == null ? Collections.emptyList() : this.textures;
    }

    public ItemStack getItem() {
        return this.itemStack == null ? ItemStack.f_41583_ : this.itemStack.m_7968_();
    }

    void setItems(Map<Tier, Item> stacks) {
        this.itemStack = stacks.remove(null);
        if (this.itemStack == null) {
            this.itemStack = Items.f_41852_;
        }
        this.itemStacks = ImmutableMap.copyOf(stacks);
    }

    void addTextures(List<Texture> textures) {
        this.textures = textures;
    }

    void setHasGui() {
        this.gui = true;
    }

    void setMenuHandler(MenuHandler<?> handler) {
        this.menuHandler = handler;
    }

    void setIsValid(Predicate<BlockEntity> isValid) {
        this.isValid = isValid;
    }

    public boolean hasGui() {
        return this.gui;
    }

    @Override
    public String getDomain() {
        return this.domain;
    }

    public static Builder builder(CoverSupplier supplier) {
        return new Builder(supplier);
    }

    @Override
    public String getId() {
        return this.id;
    }

    public static CompoundTag writeCover(CompoundTag nbt, ICover cover, Direction dir, boolean stackDrop) {
        CompoundTag inner;
        CoverFactory factory = cover.getFactory();
        nbt.m_128359_(dir.m_122411_() + "d", factory.getDomain());
        nbt.m_128359_(dir.m_122411_() + "i", factory.getId());
        if (cover.getTier() != null) {
            nbt.m_128359_(dir.m_122411_() + "t", cover.getTier().getId());
        }
        CompoundTag compoundTag = inner = stackDrop ? cover.serializeStack(new CompoundTag()) : cover.serialize();
        if (!inner.m_128456_()) {
            nbt.m_128365_(dir.m_122411_() + "c", (Tag)inner);
        }
        return nbt;
    }

    public static ICover readCover(ICoverHandler<?> source, Direction dir, CompoundTag nbt, boolean stackDrop) {
        CoverFactory factory;
        if (!nbt.m_128441_(dir.m_122411_() + "d")) {
            return null;
        }
        String domain = nbt.m_128461_(dir.m_122411_() + "d");
        String id = nbt.m_128461_(dir.m_122411_() + "i");
        ResourceLocation location = new ResourceLocation(domain, id);
        if (GTRemapping.getCoverRemappingMap().containsKey(location)) {
            location = GTRemapping.getCoverRemappingMap().get(location);
        }
        if ((factory = GTAPI.get(CoverFactory.class, location)) == null) {
            throw new IllegalStateException("Reading a cover with null factory, game in bad state");
        }
        Tier tier = nbt.m_128441_(dir.m_122411_() + "t") ? GTAPI.get(Tier.class, nbt.m_128461_(dir.m_122411_() + "t")) : null;
        ICover cover = factory.supplier.get(source, tier, dir, factory);
        cover.onCreate();
        if (nbt.m_128441_(dir.m_122411_() + "c")) {
            if (!stackDrop) {
                cover.deserialize((CompoundTag)nbt.m_128423_(dir.m_122411_() + "c"));
            } else {
                cover.deserializeStack((CompoundTag)nbt.m_128423_(dir.m_122411_() + "c"));
            }
        }
        return cover;
    }

    public static ICover readCoverRotated(ICoverHandler<?> source, Direction dir, Direction rotated, CompoundTag nbt) {
        CoverFactory factory;
        if (!nbt.m_128441_(dir.m_122411_() + "d")) {
            return null;
        }
        String domain = nbt.m_128461_(dir.m_122411_() + "d");
        String id = nbt.m_128461_(dir.m_122411_() + "i");
        ResourceLocation location = new ResourceLocation(domain, id);
        if (GTRemapping.getCoverRemappingMap().containsKey(location)) {
            location = GTRemapping.getCoverRemappingMap().get(location);
        }
        if ((factory = GTAPI.get(CoverFactory.class, location)) == null) {
            throw new IllegalStateException("Reading a cover with null factory, game in bad state");
        }
        Tier tier = nbt.m_128441_(dir.m_122411_() + "t") ? GTAPI.get(Tier.class, nbt.m_128461_(dir.m_122411_() + "t")) : null;
        ICover cover = factory.supplier.get(source, tier, rotated, factory);
        cover.onCreate();
        if (nbt.m_128441_(dir.m_122411_() + "c")) {
            cover.deserializeStack((CompoundTag)nbt.m_128423_(dir.m_122411_() + "c"));
        }
        return cover;
    }

    @Generated
    public MenuHandler<?> getMenuHandler() {
        return this.menuHandler;
    }

    @Generated
    public Predicate<BlockEntity> getIsValid() {
        return this.isValid;
    }

    public static interface CoverSupplier {
        public ICover get(ICoverHandler<?> var1, @Nullable Tier var2, Direction var3, CoverFactory var4);
    }

    public static class Builder {
        List<Tier> tiers = Collections.singletonList(null);
        final CoverSupplier supplier;
        BiFunction<CoverFactory, Tier, Item> itemBuilder;
        boolean gui = false;
        List<Texture> textures;
        MenuHandler<?> menuHandler;
        Predicate<BlockEntity> isValid;

        public Builder(CoverSupplier supplier) {
            this.supplier = supplier;
        }

        public Builder setTiers(Tier ... tiers) {
            this.tiers = Arrays.asList(tiers);
            return this;
        }

        public Builder item(BiFunction<CoverFactory, Tier, Item> item) {
            this.itemBuilder = item;
            return this;
        }

        public Builder gui() {
            this.gui = true;
            return this;
        }

        public Builder setMenuHandler(MenuHandler<?> handler) {
            this.menuHandler = handler;
            return this;
        }

        public Builder addTextures(List<Texture> textures) {
            this.textures = textures;
            return this;
        }

        public Builder addTextures(Texture ... textures) {
            this.textures = Arrays.asList(textures);
            return this;
        }

        public Builder setIsValid(Predicate<BlockEntity> isValid) {
            this.isValid = isValid;
            return this;
        }

        public CoverFactory build(String domain, String id) {
            CoverFactory factory = new CoverFactory(domain, id, this.supplier);
            if (this.itemBuilder != null) {
                Object2ObjectOpenHashMap map = new Object2ObjectOpenHashMap();
                for (Tier tier : this.tiers) {
                    Item stack = this.itemBuilder.apply(factory, tier);
                    map.put(tier, stack);
                }
                factory.setItems((Map<Tier, Item>)map);
            }
            if (this.gui) {
                factory.setHasGui();
                if (this.menuHandler != null) {
                    factory.setMenuHandler(this.menuHandler);
                }
            }
            if (this.textures != null) {
                factory.addTextures(this.textures);
            }
            if (this.isValid != null) {
                factory.setIsValid(this.isValid);
            }
            return factory;
        }
    }
}

