/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.capability.machine;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.core.Direction;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import org.gtreimagined.gtlib.blockentity.BlockEntityMachine;
import org.gtreimagined.gtlib.capability.Dispatch;
import org.gtreimagined.gtlib.capability.FluidHandler;
import org.gtreimagined.gtlib.capability.fluid.FluidHandlerNullSideWrapper;
import org.gtreimagined.gtlib.capability.fluid.FluidHandlerSidedWrapper;
import org.gtreimagined.gtlib.capability.fluid.FluidTanks;
import org.gtreimagined.gtlib.capability.machine.MachineItemHandler;
import org.gtreimagined.gtlib.gui.SlotType;
import org.gtreimagined.gtlib.machine.Tier;
import org.gtreimagined.gtlib.machine.event.IMachineEvent;
import org.gtreimagined.gtlib.recipe.IRecipe;
import org.gtreimagined.gtlib.recipe.ingredient.FluidIngredient;
import org.gtreimagined.gtlib.util.FluidUtils;
import org.gtreimagined.gtlib.util.Utils;
import org.jetbrains.annotations.NotNull;

public class MachineFluidHandler<T extends BlockEntityMachine<T>>
extends FluidHandler<T>
implements Dispatch.Sided<IFluidHandler> {
    private boolean fillingCell = false;
    protected boolean filledLastTick = false;
    private int lastCellSlot = 0;

    public MachineFluidHandler(T tile, int capacity) {
        this(tile, capacity, ((BlockEntityMachine)tile).has("gui") ? ((BlockEntityMachine)tile).getMachineType().getSlots(SlotType.FL_IN, ((BlockEntityMachine)tile).getMachineTier()).size() : 0, ((BlockEntityMachine)tile).has("gui") ? ((BlockEntityMachine)tile).getMachineType().getSlots(SlotType.FL_OUT, ((BlockEntityMachine)tile).getMachineTier()).size() : 0);
    }

    public MachineFluidHandler(T tile, int capacity, int inputCount, int outputCount) {
        super(tile, capacity, inputCount, outputCount);
    }

    public MachineFluidHandler(T tile) {
        this(tile, 32000);
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.filledLastTick) {
            this.tryFillCell(this.lastCellSlot, -1);
        }
    }

    public void fillCell(int cellSlot, int maxFill) {
        if (this.fillingCell) {
            return;
        }
        this.fillingCell = true;
        this.filledLastTick = this.getInputTanks() != null ? ((BlockEntityMachine)this.tile).itemHandler.map(ih -> {
            if (ih.getCellInputHandler() == null) {
                return false;
            }
            ItemStack cell = ih.getCellInputHandler().getStackInSlot(cellSlot);
            if (cell.m_41619_()) {
                return false;
            }
            boolean success = false;
            Predicate<ItemStack> predicate = s -> MachineItemHandler.insertIntoOutput((IItemHandler)ih.getCellOutputHandler(), cellSlot, s, true).m_41619_();
            Consumer<ItemStack> consumer = s -> {
                MachineItemHandler.insertIntoOutput((IItemHandler)ih.getCellOutputHandler(), cellSlot, s, false);
                MachineItemHandler.extractFromInput((IItemHandler)ih.getCellInputHandler(), cellSlot, 1, false);
            };
            if (FluidUtils.fillItemFromContainer(maxFill, Utils.ca(1, cell), this.getCellAccessibleTanks(), predicate, consumer)) {
                success = true;
                this.lastCellSlot = cellSlot;
            } else if (FluidUtils.emptyItemIntoContainer(maxFill, Utils.ca(1, cell), this.getCellAccessibleTanks(), predicate, consumer)) {
                success = true;
                this.lastCellSlot = cellSlot;
            }
            return success;
        }).orElse(false) : false;
        this.fillingCell = false;
    }

    protected FluidTanks getCellAccessibleTanks() {
        return this.getAllTanks();
    }

    @Override
    protected boolean checkValidFluid(FluidStack fluid) {
        IRecipe recipe;
        if (((BlockEntityMachine)this.tile).has("generator") && (recipe = ((BlockEntityMachine)this.tile).getMachineType().getRecipeMap(((BlockEntityMachine)this.tile).getMachineTier()).find(new ItemStack[0], new FluidStack[]{fluid}, Tier.ULV, r -> true)) != null) {
            return true;
        }
        return true;
    }

    protected void tryFillCell(int slot, int maxFill) {
        if (((BlockEntityMachine)this.tile).itemHandler.map(MachineItemHandler::getCellCount).orElse(0) > 0) {
            this.fillCell(slot, maxFill);
        }
    }

    @Override
    public int fill(FluidStack fluid, IFluidHandler.FluidAction action) {
        if (!((BlockEntityMachine)this.tile).recipeHandler.map(t -> t.accepts(fluid)).orElse(true).booleanValue()) {
            return 0;
        }
        return super.fill(fluid, action);
    }

    @Override
    public void onMachineEvent(IMachineEvent event, Object ... data) {
        super.onMachineEvent(event, data);
        if (event instanceof SlotType) {
            if (event == SlotType.CELL_IN || event == SlotType.CELL_OUT) {
                if (data[0] instanceof Integer) {
                    this.tryFillCell((Integer)data[0], -1);
                }
            } else if (event == SlotType.FL_IN || event == SlotType.FL_OUT) {
                Object object = data[0];
                if (object instanceof Integer) {
                    Integer integer = (Integer)object;
                    this.tryFillCell(integer, -1);
                } else {
                    for (int i = 0; i < ((BlockEntityMachine)this.tile).itemHandler.map(MachineItemHandler::getCellCount).orElse(0); ++i) {
                        this.fillCell(i, -1);
                    }
                }
                if (((BlockEntityMachine)this.tile).getMachineType().rendersContainedLiquids()) {
                    ((BlockEntityMachine)this.tile).sidedSync(true);
                }
            }
        }
    }

    public boolean canFluidBeAutoOutput(FluidStack fluid) {
        return true;
    }

    public boolean canOutputsFit(FluidStack[] outputs) {
        return this.getSpaceForOutputs(outputs) >= outputs.length;
    }

    public int getSpaceForOutputs(FluidStack[] outputs) {
        int matchCount = 0;
        if (this.getOutputTanks() != null) {
            for (FluidStack output : outputs) {
                int tank = this.getOutputTanks().getFirstAvailableTank(output, false);
                if (tank < 0 || this.getOutputTanks().getTank(tank).fill(output, IFluidHandler.FluidAction.SIMULATE) != output.getAmount()) continue;
                ++matchCount;
            }
        }
        return matchCount;
    }

    public void addOutputs(FluidStack ... fluids) {
        if (this.getOutputTanks() == null) {
            return;
        }
        if (fluids != null) {
            for (FluidStack input : fluids) {
                this.fillOutput(input, IFluidHandler.FluidAction.EXECUTE);
            }
        }
    }

    public int getTankForTag(TagKey<Fluid> tag, int min) {
        FluidStack[] inputs = this.getInputs();
        for (int i = min; i < inputs.length; ++i) {
            FluidStack input = inputs[i];
            if (!input.getFluid().m_205069_().m_203656_(tag)) continue;
            return i;
        }
        return -1;
    }

    @NotNull
    public FluidStack consumeTaggedInput(TagKey<Fluid> input, int amount, boolean simulate) {
        FluidTanks inputs = this.getInputTanks();
        if (inputs == null) {
            return FluidStack.EMPTY;
        }
        int id = this.getTankForTag(input, 0);
        if (id == -1) {
            return FluidStack.EMPTY;
        }
        return inputs.drain(new FluidStack(inputs.getFluidInTank(id).getFluid(), amount), simulate ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE);
    }

    @NotNull
    public List<FluidStack> consumeAndReturnInputs(List<FluidIngredient> inputs, boolean simulate) {
        if (this.getInputTanks() == null) {
            return Collections.emptyList();
        }
        ObjectArrayList consumed = new ObjectArrayList();
        ObjectArrayList fluidIngredients = new ObjectArrayList();
        if (inputs != null) {
            for (FluidIngredient input : inputs) {
                List<FluidStack> inner = input.drain(this, true, true);
                if (inner.stream().mapToLong(FluidStack::getAmount).sum() != (long)input.getAmount()) {
                    return Collections.emptyList();
                }
                fluidIngredients.add(input);
                consumed.addAll(inner);
            }
        }
        if (!simulate) {
            fluidIngredients.forEach(f -> f.drain(this, true, false));
        }
        return consumed;
    }

    public FluidStack[] exportAndReturnOutputs(FluidStack ... outputs) {
        if (this.getOutputTanks() == null) {
            return new FluidStack[0];
        }
        ObjectArrayList notExported = new ObjectArrayList();
        for (int i = 0; i < outputs.length; ++i) {
            int result = this.fill(outputs[i], IFluidHandler.FluidAction.EXECUTE);
            if (result == 0) {
                notExported.add(outputs[i]);
                continue;
            }
            outputs[i] = Utils.ca(result, outputs[i]);
        }
        return notExported.toArray(new FluidStack[0]);
    }

    @Override
    public boolean canOutput(Direction direction) {
        if (((BlockEntityMachine)this.tile).getFacing().m_122411_() == direction.m_122411_() && !((BlockEntityMachine)this.tile).getMachineType().allowsFrontIO()) {
            return false;
        }
        return super.canOutput();
    }

    @Override
    public boolean canInput(Direction direction) {
        if (((BlockEntityMachine)this.tile).getFacing().m_122411_() == direction.m_122411_() && !((BlockEntityMachine)this.tile).getMachineType().allowsFrontIO()) {
            return false;
        }
        return super.canInput();
    }

    @Override
    public int getPriority(Direction direction) {
        return ((BlockEntityMachine)this.tile).coverHandler.map(c -> c.get(direction).getPriority(IFluidHandler.class)).orElse(0);
    }

    @Override
    public LazyOptional<? extends IFluidHandler> forNullSide() {
        return LazyOptional.of(() -> new FluidHandlerNullSideWrapper(this));
    }

    @Override
    public LazyOptional<IFluidHandler> forSide(Direction side) {
        return LazyOptional.of(() -> new FluidHandlerSidedWrapper(this, ((BlockEntityMachine)this.tile).coverHandler.map(c -> c).orElse(null), side));
    }

    public IFluidHandler getGuiHandler() {
        return new IFluidHandler(){

            public int getTanks() {
                return MachineFluidHandler.this.getTanks();
            }

            @NotNull
            public FluidStack getFluidInTank(int i) {
                return MachineFluidHandler.this.getFluidInTank(i);
            }

            public int getTankCapacity(int i) {
                return MachineFluidHandler.this.getTankCapacity(i);
            }

            public boolean isFluidValid(int i, @NotNull FluidStack fluidStack) {
                return MachineFluidHandler.this.isFluidValid(i, fluidStack);
            }

            public int fill(FluidStack fluidStack, IFluidHandler.FluidAction fluidAction) {
                return MachineFluidHandler.this.fill(fluidStack, fluidAction);
            }

            @NotNull
            public FluidStack drain(FluidStack fluidStack, IFluidHandler.FluidAction fluidAction) {
                return MachineFluidHandler.this.drain(fluidStack, fluidAction);
            }

            @NotNull
            public FluidStack drain(int i, IFluidHandler.FluidAction fluidAction) {
                return MachineFluidHandler.this.drain(i, fluidAction);
            }
        };
    }
}

