/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.fluid;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.fluids.FluidAttributes;
import org.gtreimagined.gtlib.data.GTMaterialTypes;
import org.gtreimagined.gtlib.fluid.GTFluid;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.material.MaterialTags;
import org.gtreimagined.gtlib.material.MaterialType;

public class GTMaterialFluid
extends GTFluid {
    protected Material material;
    protected MaterialType<?> type;

    public GTMaterialFluid(String domain, Material material, MaterialType<?> type, FluidAttributes.Builder builder, BlockBehaviour.Properties blockProperties) {
        super(domain, type.getId() + "_" + material.getId(), builder, blockProperties);
        this.material = material;
        this.type = type;
    }

    public GTMaterialFluid(String domain, Material material, MaterialType<?> type, ResourceLocation stillLoc, ResourceLocation flowLoc) {
        super(domain, type.getId() + "_" + material.getId(), stillLoc, flowLoc);
        this.material = material;
        this.type = type;
    }

    public GTMaterialFluid(String domain, Material material, MaterialType<?> type) {
        this(domain, material, type, GTMaterialFluid.prepareAttributes(domain, material, type), GTMaterialFluid.prepareProperties(material));
    }

    public Material getMaterial() {
        return this.material;
    }

    public MaterialType<?> getType() {
        return this.type;
    }

    private static FluidAttributes.Builder prepareAttributes(String domain, Material material, MaterialType<?> type) {
        int density;
        int n = material.has(MaterialTags.FLUID_DENSITY) ? MaterialTags.FLUID_DENSITY.getInt(material) : (type == GTMaterialTypes.GAS ? 1 : (density = material.has(MaterialTags.MOLTEN) ? 3000 : 1000));
        if (type == GTMaterialTypes.GAS) {
            return FluidAttributes.builder((ResourceLocation)GAS_TEXTURE, (ResourceLocation)GAS_FLOW_TEXTURE).overlay(OVERLAY_TEXTURE).color(0x46000000 | material.getRGB() & 0xFFFFFF).viscosity(200).density(density).gaseous().temperature(MaterialTags.GAS_TEMPERATURE.getInt(material)).sound(SoundEvents.f_11781_, SoundEvents.f_11778_);
        }
        FluidAttributes.Builder b = GTMaterialFluid.getDefaultAttributesBuilder(material.has(MaterialTags.MOLTEN)).density(density);
        if (material.has(MaterialTags.MOLTEN)) {
            b.viscosity(6000).luminosity(15);
        }
        int alpha = material.has(MaterialTags.MOLTEN) ? -16777216 : -1694498816;
        return b.color(alpha | material.getRGB() & 0xFFFFFF).temperature(MaterialTags.LIQUID_TEMPERATURE.getInt(material));
    }

    private static BlockBehaviour.Properties prepareProperties(Material material) {
        return GTMaterialFluid.getDefaultBlockProperties().m_60953_(s -> material.has(MaterialTags.MOLTEN) ? 15 : 0);
    }

    @Override
    public String getLang(String lang) {
        if (lang.equals("en_us")) {
            String display = this.material.getDisplayNameString();
            if (this.isGasType()) {
                return display;
            }
            String liquid = this.material.has(MaterialTags.MOLTEN) ? "Molten " : "";
            return liquid + display;
        }
        return super.getLang(lang);
    }

    private boolean isGasType() {
        return this.type == GTMaterialTypes.GAS || this.getAttributes().isGaseous();
    }
}

