/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.capability.machine;

import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.ForgeHooks;
import org.gtreimagined.gtlib.blockentity.BlockEntityMachine;
import org.gtreimagined.gtlib.capability.machine.MachineRecipeHandler;
import org.gtreimagined.gtlib.recipe.ingredient.impl.Ingredients;

public class CookingRecipeHandler<T extends BlockEntityMachine<T>>
extends MachineRecipeHandler<T> {
    protected int burnDuration = 0;
    protected static final Supplier<List<Ingredient>> BURNABLE = () -> Collections.singletonList(Ingredients.BURNABLES);
    private final float burnMultiplier;

    public CookingRecipeHandler(T tile, float burnMultiplier) {
        super(tile);
        this.burnMultiplier = burnMultiplier;
    }

    private boolean consume(boolean simulate) {
        if (simulate) {
            List stack = this.tile.itemHandler.map(t -> t.consumeInputs(BURNABLE.get(), true)).orElse(Collections.emptyList());
            return !stack.isEmpty();
        }
        List stack = this.tile.itemHandler.map(t -> t.consumeInputs(BURNABLE.get(), false)).orElse(Collections.emptyList());
        if (!stack.isEmpty()) {
            this.burnDuration = (int)((float)this.burnDuration + (float)ForgeHooks.getBurnTime((ItemStack)((ItemStack)stack.get(0)), null) * this.burnMultiplier);
            return true;
        }
        return false;
    }

    @Override
    public boolean consumePower(boolean simulate) {
        if (simulate) {
            return this.consume(true);
        }
        if (this.burnDuration == 0) {
            if (!this.consume(false)) {
                return false;
            }
        } else {
            --this.burnDuration;
            return this.burnDuration >= 0;
        }
        return this.burnDuration > 0;
    }

    @Override
    protected void recipeFailure() {
    }

    @Override
    public CompoundTag serialize() {
        CompoundTag nbt = super.serialize();
        nbt.m_128405_("burn", this.burnDuration);
        return nbt;
    }

    @Override
    public void getInfo(List<String> builder) {
        super.getInfo(builder);
        if (this.burnDuration > 0) {
            builder.add("Current burn time left: " + this.burnDuration);
        }
    }

    @Override
    public boolean accepts(ItemStack stack) {
        return super.accepts(stack) || Ingredients.BURNABLES.test(stack);
    }

    @Override
    public void deserialize(CompoundTag nbt) {
        super.deserialize(nbt);
        this.burnDuration = nbt.m_128451_("burn");
    }
}

