package org.gtreimagined.gtlib.capability.machine;

import org.gtreimagined.gtlib.blockentity.BlockEntityMachine;
import org.gtreimagined.gtlib.recipe.ingredient.impl.Ingredients;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.ForgeHooks;

import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;

public class CookingRecipeHandler<T extends BlockEntityMachine<T>> extends MachineRecipeHandler<T> {

    protected int burnDuration = 0;
    protected static final Supplier<List<Ingredient>> BURNABLE = () -> Collections.singletonList(Ingredients.BURNABLES);
    private final float burnMultiplier;

    public CookingRecipeHandler(T tile, float burnMultiplier) {
        super(tile);
        this.burnMultiplier = burnMultiplier;
    }

    private boolean consume(boolean simulate) {
        List<ItemStack> stack;
        if (simulate) {
            stack = tile.itemHandler.map(t -> t.consumeInputs(BURNABLE.get(), true)).orElse(Collections.emptyList());
            return !stack.isEmpty();
        }
        if (!(stack = tile.itemHandler.map(t -> t.consumeInputs(BURNABLE.get(), false)).orElse(Collections.emptyList())).isEmpty()) {
            burnDuration += ForgeHooks.getBurnTime(stack.get(0), null) * burnMultiplier;
            return true;
        }
        return false;
    }

    /*@Override
    public IIntArray getProgressData() {
        IIntArray sup = super.getProgressData();
        return new IIntArray() {
            @Override
            public int get(int index) {
                if (index == sup.size()) {
                    return CookingRecipeHandler.this.burnDuration;
                }
                return sup.get(index);
            }

            @Override
            public void set(int index, int value) {
                if (index == sup.size()) {
                    CookingRecipeHandler.this.burnDuration = value;
                    return;
                }
                sup.set(index, value);
            }

            @Override
            public int size() {
                return sup.size() + 1;
            }
        };
    }*/

    @Override
    public boolean consumePower(boolean simulate) {
        if (simulate) return consume(true);
        if (burnDuration == 0) {
            if (!consume(false)) return false;
        } else {
            burnDuration--;
            return burnDuration >= 0;
        }
        return burnDuration > 0;
    }

    @Override
    protected void recipeFailure() {

    }

    @Override
    public CompoundTag serialize() {
        CompoundTag nbt = super.serialize();
        nbt.putInt("burn", burnDuration);
        return nbt;
    }

    @Override
    public void getInfo(List<String> builder) {
        super.getInfo(builder);
        if (burnDuration > 0) builder.add("Current burn time left: " + burnDuration);
    }

    @Override
    public boolean accepts(ItemStack stack) {
        return super.accepts(stack) || Ingredients.BURNABLES.test(stack);
    }

    @Override
    public void deserialize(CompoundTag nbt) {
        super.deserialize(nbt);
        this.burnDuration = nbt.getInt("burn");
    }
}
