/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.pipe.types;

import com.mojang.datafixers.util.Pair;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.blockentity.pipe.BlockEntityItemPipe;
import org.gtreimagined.gtlib.blockentity.pipe.BlockEntityPipe;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.material.MaterialTags;
import org.gtreimagined.gtlib.pipe.BlockItemPipe;
import org.gtreimagined.gtlib.pipe.BlockPipe;
import org.gtreimagined.gtlib.pipe.PipeSize;
import org.gtreimagined.gtlib.pipe.types.PipeType;

public class ItemPipe<T extends ItemPipe<T>>
extends PipeType<T> {
    protected int[] caps;
    protected int[] stepsizes;
    protected Map<PipeSize, Block> registeredRestrictedBlocks;

    public ItemPipe(String domain, Material material) {
        super(domain, material, BlockEntityItemPipe::new);
        material.flags(MaterialTags.ITEMPIPE);
        this.sizes(PipeSize.NORMAL, PipeSize.LARGE, PipeSize.HUGE);
    }

    @Override
    public String getType() {
        return "item_pipe";
    }

    @Override
    public String getTypeName() {
        return "item_pipe";
    }

    @Override
    public Set<Block> getBlocks() {
        return this.sizes.stream().map(s -> new BlockItemPipe<ItemPipe>(this, (PipeSize)s, false)).collect(Collectors.toSet());
    }

    public Set<Block> getRestrictedBlocks() {
        return this.sizes.stream().map(s -> new BlockItemPipe<ItemPipe>(this, (PipeSize)s, true)).collect(Collectors.toSet());
    }

    @Override
    public void onRegistryBuild(IForgeRegistry<?> registry) {
        if (registry != ForgeRegistries.BLOCKS) {
            return;
        }
        Set<Block> blocks = this.getBlocks();
        Set<Block> restrictedBlocks = this.getRestrictedBlocks();
        this.registeredBlocks = blocks.stream().map(t -> new Pair((Object)((BlockPipe)t).getSize(), t)).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond));
        this.registeredRestrictedBlocks = restrictedBlocks.stream().map(t -> new Pair((Object)((BlockPipe)t).getSize(), t)).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond));
        this.tileType = new BlockEntityType((pos, state) -> (BlockEntityPipe)this.tileFunc.create(this, pos, state), Stream.concat(blocks.stream(), restrictedBlocks.stream()).collect(Collectors.toSet()), null);
        GTAPI.register(BlockEntityType.class, this.getId(), this.getDomain(), this.getTileType());
    }

    public Block getRestrictedBlock(PipeSize size) {
        return this.registeredRestrictedBlocks.get(size);
    }

    public int getCapacity(PipeSize size) {
        return this.caps[size.ordinal()];
    }

    public int getStepsize(PipeSize size) {
        return this.stepsizes[size.ordinal()];
    }

    public T caps(int baseCap) {
        this.caps = new int[]{baseCap, baseCap * 2, baseCap * 3, baseCap * 4, baseCap * 5, baseCap * 6};
        return (T)this;
    }

    public T caps(int ... caps) {
        this.caps = caps;
        return (T)this;
    }

    public T stepsize(int baseStepsize) {
        this.stepsizes = new int[]{baseStepsize * 8, baseStepsize * 4, baseStepsize * 2, baseStepsize, baseStepsize / 2, baseStepsize / 4};
        return (T)this;
    }

    public T stepsize(int ... stepsize) {
        this.stepsizes = stepsize;
        return (T)this;
    }
}

