/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.integration.kubejs;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.latvian.mods.kubejs.fluid.FluidStackJS;
import dev.latvian.mods.kubejs.item.ItemStackJS;
import dev.latvian.mods.kubejs.item.ingredient.IngredientJS;
import dev.latvian.mods.kubejs.item.ingredient.IngredientStackJS;
import dev.latvian.mods.kubejs.item.ingredient.MatchAnyIngredientJS;
import dev.latvian.mods.kubejs.recipe.RecipeJS;
import dev.latvian.mods.kubejs.util.ListJS;
import dev.latvian.mods.kubejs.util.MapJS;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.fluids.FluidStack;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.integration.kubejs.RecipeIngredientJS;
import org.gtreimagined.gtlib.integration.rei.REIUtils;
import org.gtreimagined.gtlib.recipe.ingredient.FluidIngredient;
import org.gtreimagined.gtlib.recipe.map.RecipeMap;
import org.gtreimagined.gtlib.recipe.serializer.GTRecipeSerializer;
import org.gtreimagined.gtlib.util.RegistryUtils;
import org.jetbrains.annotations.Nullable;

public class KubeJSRecipe
extends RecipeJS {
    public final List<FluidIngredient> fluidInput = new ObjectArrayList();
    public final List<FluidStack> fluidOutput = new ObjectArrayList();
    private int duration;
    private int special;
    private long power;
    private int amps;
    private boolean hidden;
    private boolean fake;
    private final List<Integer> outputChances = new ObjectArrayList();
    private final List<Integer> inputChances = new ObjectArrayList();
    private String map;

    public void create(ListJS listJS) {
        FluidStackJS fluidStack;
        MapJS map;
        this.map = (String)listJS.get(0);
        RecipeMap rMap = GTAPI.get(RecipeMap.class, this.map);
        if (rMap == null) {
            throw new IllegalArgumentException("Unknown recipe map");
        }
        if (listJS.get(1) != null) {
            for (Object inputItem : ListJS.orSelf((Object)listJS.get(1))) {
                if (inputItem instanceof MapJS) {
                    map = (MapJS)inputItem;
                    this.inputItems.add(RecipeIngredientJS.fromJson((JsonElement)map.toJson()));
                    continue;
                }
                this.inputItems.add(IngredientJS.of(inputItem));
            }
        }
        if (listJS.get(2) != null) {
            for (Object outputItem : ListJS.orSelf((Object)listJS.get(2))) {
                this.outputItems.add(ItemStackJS.of(outputItem));
            }
        }
        if (listJS.get(3) != null) {
            for (Object inputFluid : ListJS.orSelf((Object)listJS.get(3))) {
                if (inputFluid instanceof FluidStackJS) {
                    fluidStack = (FluidStackJS)inputFluid;
                    this.fluidInput.add(FluidIngredient.of(REIUtils.fromREIFluidStack(fluidStack.getFluidStack())));
                    continue;
                }
                if (inputFluid instanceof MapJS) {
                    map = (MapJS)inputFluid;
                    this.fluidInput.add(GTRecipeSerializer.getFluidIngredient((JsonElement)map.toJson()));
                    continue;
                }
                throw new IllegalArgumentException("Invalid entry type in fluid output");
            }
        }
        if (listJS.get(4) != null) {
            for (Object outputFluid : ListJS.orSelf((Object)listJS.get(4))) {
                if (outputFluid instanceof FluidStackJS) {
                    fluidStack = (FluidStackJS)outputFluid;
                    this.fluidOutput.add(REIUtils.fromREIFluidStack(fluidStack.getFluidStack()));
                    continue;
                }
                if (outputFluid instanceof MapJS) {
                    map = (MapJS)outputFluid;
                    this.fluidOutput.add(GTRecipeSerializer.getStack((JsonElement)map.toJson()));
                    continue;
                }
                throw new IllegalArgumentException("Invalid entry type in fluid output");
            }
        }
        this.duration = ((Number)listJS.get(5)).intValue();
        this.power = ((Number)listJS.get(6)).longValue();
        this.hidden = false;
        this.fake = false;
        if (listJS.size() > 7) {
            this.amps = ((Number)listJS.get(7)).intValue();
            this.special = ((Number)listJS.get(8)).intValue();
            if (listJS.size() > 9) {
                for (Object chance : ListJS.orSelf((Object)listJS.get(9))) {
                    this.outputChances.add(((Number)chance).intValue());
                }
            }
            if (listJS.size() > 10) {
                for (Object chance : ListJS.orSelf((Object)listJS.get(9))) {
                    this.inputChances.add(((Number)chance).intValue());
                }
            }
        } else {
            this.amps = 1;
            this.special = 0;
        }
        if (this.inputItems.isEmpty() && this.fluidInput.isEmpty()) {
            throw new IllegalStateException("No input in recipe");
        }
    }

    public void deserialize() {
        this.map = GsonHelper.m_13906_((JsonObject)this.json, (String)"map");
        for (JsonElement e : GsonHelper.m_13832_((JsonObject)this.json, (String)"inputItems", (JsonArray)new JsonArray())) {
            this.inputItems.add(RecipeIngredientJS.fromJson(e));
        }
        for (JsonElement e : GsonHelper.m_13832_((JsonObject)this.json, (String)"outputItems", (JsonArray)new JsonArray())) {
            this.outputItems.add(ItemStackJS.of((Object)e));
        }
        for (JsonElement e : GsonHelper.m_13832_((JsonObject)this.json, (String)"inputFluids", (JsonArray)new JsonArray())) {
            this.fluidInput.add(GTRecipeSerializer.getFluidIngredient(e));
        }
        for (JsonElement e : GsonHelper.m_13832_((JsonObject)this.json, (String)"outputFluids", (JsonArray)new JsonArray())) {
            this.fluidOutput.add(GTRecipeSerializer.getStack(e));
        }
        this.duration = GsonHelper.m_13927_((JsonObject)this.json, (String)"duration");
        this.special = GsonHelper.m_13824_((JsonObject)this.json, (String)"special", (int)0);
        this.power = GsonHelper.m_13927_((JsonObject)this.json, (String)"eu");
        this.amps = GsonHelper.m_13824_((JsonObject)this.json, (String)"amps", (int)1);
        this.hidden = GsonHelper.m_13912_((JsonObject)this.json, (String)"hidden");
        this.fake = GsonHelper.m_13912_((JsonObject)this.json, (String)"fake");
        for (JsonElement e : GsonHelper.m_13832_((JsonObject)this.json, (String)"outputChances", (JsonArray)new JsonArray())) {
            this.outputChances.add(e.getAsInt());
        }
        for (JsonElement e : GsonHelper.m_13832_((JsonObject)this.json, (String)"inputChances", (JsonArray)new JsonArray())) {
            this.inputChances.add(e.getAsInt());
        }
    }

    public static JsonElement serializeStack(FluidStack stack) {
        JsonObject obj = new JsonObject();
        obj.addProperty("fluid", RegistryUtils.getIdFromFluid(stack.getFluid()).toString());
        obj.addProperty("amount", (Number)stack.getAmount());
        if (stack.getTag() != null) {
            obj.add("tag", (JsonElement)NbtOps.f_128958_.convertTo((DynamicOps)JsonOps.INSTANCE, (Tag)stack.getTag()));
        }
        return obj;
    }

    @Nullable
    public JsonElement serializeIngredientStack(IngredientStackJS in) {
        JsonElement element;
        IngredientJS ingredientJS = in.ingredient;
        if (ingredientJS instanceof MatchAnyIngredientJS) {
            MatchAnyIngredientJS js = (MatchAnyIngredientJS)ingredientJS;
            JsonObject object = new JsonObject();
            JsonArray array = new JsonArray();
            js.ingredients.forEach(i -> array.add(i.toJson()));
            object.add("values", (JsonElement)array);
            element = object;
        } else {
            element = in.ingredient.toJson();
        }
        if (element instanceof JsonObject) {
            JsonObject object = (JsonObject)element;
            if (in.getCount() > 1) {
                object.addProperty(in.countKey, (Number)in.getCount());
            }
        }
        return element;
    }

    public static JsonElement serializeFluid(FluidIngredient stack) {
        return stack.toJson();
    }

    public void serialize() {
        JsonArray arr;
        if (!this.inputItems.isEmpty()) {
            arr = new JsonArray();
            this.inputItems.forEach(t -> arr.add(t.toJson()));
            this.json.add("inputItems", (JsonElement)arr);
        }
        if (!this.outputItems.isEmpty()) {
            arr = new JsonArray();
            this.outputItems.forEach(t -> arr.add(t.toResultJson()));
            this.json.add("outputItems", (JsonElement)arr);
        }
        if (!this.fluidInput.isEmpty()) {
            arr = new JsonArray();
            this.fluidInput.forEach(t -> arr.add(KubeJSRecipe.serializeFluid(t)));
            this.json.add("inputFluids", (JsonElement)arr);
        }
        if (!this.fluidOutput.isEmpty()) {
            arr = new JsonArray();
            this.fluidOutput.forEach(t -> arr.add(KubeJSRecipe.serializeStack(t)));
            this.json.add("outputFluids", (JsonElement)arr);
        }
        if (!this.outputChances.isEmpty()) {
            arr = new JsonArray();
            this.outputChances.forEach(arg_0 -> ((JsonArray)arr).add(arg_0));
            this.json.add("outputChances", (JsonElement)arr);
        }
        if (!this.inputChances.isEmpty()) {
            arr = new JsonArray();
            this.inputChances.forEach(arg_0 -> ((JsonArray)arr).add(arg_0));
            this.json.add("inputChances", (JsonElement)arr);
        }
        this.json.addProperty("eu", (Number)this.power);
        this.json.addProperty("duration", (Number)this.duration);
        this.json.addProperty("amps", (Number)this.amps);
        this.json.addProperty("special", (Number)this.special);
        this.json.addProperty("hidden", Boolean.valueOf(this.hidden));
        this.json.addProperty("map", this.map);
        this.json.addProperty("fake", Boolean.valueOf(this.fake));
    }
}

