/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.datagen.loaders;

import com.google.common.collect.ImmutableMap;
import java.util.function.Consumer;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.data.ForgeTags;
import org.gtreimagined.gtlib.data.GTLibMaterials;
import org.gtreimagined.gtlib.data.GTMaterialTypes;
import org.gtreimagined.gtlib.datagen.providers.GTRecipeProvider;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.ore.CobbleStoneType;
import org.gtreimagined.gtlib.ore.StoneType;
import org.gtreimagined.gtlib.ore.VanillaStoneType;
import org.gtreimagined.gtlib.util.TagUtils;

public class StoneRecipes {
    public static void loadRecipes(Consumer<FinishedRecipe> output, GTRecipeProvider provider) {
        provider.addItemRecipe(output, "minecraft", "", "furnaces", (ItemLike)Items.f_41962_, (ImmutableMap<Character, Object>)ImmutableMap.of((Object)Character.valueOf('C'), (Object)ItemTags.f_13166_), "CCC", "C C", "CCC");
        provider.addItemRecipe(output, "minecraft", "", "redstone", (ItemLike)Items.f_42162_, (ImmutableMap<Character, Object>)ImmutableMap.of((Object)Character.valueOf('C'), (Object)ItemTags.f_13166_, (Object)Character.valueOf('R'), GTMaterialTypes.DUST.getMaterialTag(GTLibMaterials.Redstone)), "CCC", "C C", "CRC");
        provider.addItemRecipe(output, "minecraft", "", "redstone", (ItemLike)Items.f_42264_, (ImmutableMap<Character, Object>)ImmutableMap.of((Object)Character.valueOf('C'), (Object)ItemTags.f_13166_, (Object)Character.valueOf('R'), GTMaterialTypes.DUST.getMaterialTag(GTLibMaterials.Redstone), (Object)Character.valueOf('Q'), ForgeTags.GEMS_QUARTZ_ALL), "CCC", "RRQ", "CCC");
        provider.addItemRecipe(output, "minecraft", "", "redstone", (ItemLike)Items.f_41966_, (ImmutableMap<Character, Object>)ImmutableMap.of((Object)Character.valueOf('C'), (Object)ItemTags.f_13166_, (Object)Character.valueOf('R'), GTMaterialTypes.ROD.getMaterialTag(GTLibMaterials.Wood)), "R", "C");
        provider.addItemRecipe(output, "minecraft", "", "redstone", (ItemLike)Items.f_41869_, (ImmutableMap<Character, Object>)ImmutableMap.of((Object)Character.valueOf('C'), (Object)ItemTags.f_13166_, (Object)Character.valueOf('R'), GTMaterialTypes.DUST.getMaterialTag(GTLibMaterials.Redstone), (Object)Character.valueOf('I'), GTMaterialTypes.INGOT.getMaterialTag(GTLibMaterials.Iron), (Object)Character.valueOf('W'), (Object)ItemTags.f_13168_), "WWW", "CIC", "CRC");
        provider.addItemRecipe(output, "minecraft", "", "redstone", (ItemLike)Items.f_41855_, (ImmutableMap<Character, Object>)ImmutableMap.of((Object)Character.valueOf('C'), (Object)ItemTags.f_13166_, (Object)Character.valueOf('R'), GTMaterialTypes.DUST.getMaterialTag(GTLibMaterials.Redstone), (Object)Character.valueOf('B'), (Object)Items.f_42411_), "CCC", "CBC", "CRC");
        provider.addItemRecipe(output, "minecraft", "", "redstone", (ItemLike)Items.f_42350_, (ImmutableMap<Character, Object>)ImmutableMap.of((Object)Character.valueOf('T'), (Object)Items.f_41978_, (Object)Character.valueOf('R'), GTMaterialTypes.DUST.getMaterialTag(GTLibMaterials.Redstone), (Object)Character.valueOf('S'), TagUtils.getForgelikeItemTag("stone")), "TRT", "SSS");
        provider.addItemRecipe(output, "minecraft", "", "redstone", (ItemLike)Items.f_42351_, (ImmutableMap<Character, Object>)ImmutableMap.of((Object)Character.valueOf('T'), (Object)Items.f_41978_, (Object)Character.valueOf('Q'), ForgeTags.GEMS_QUARTZ_ALL, (Object)Character.valueOf('S'), TagUtils.getForgelikeItemTag("stone")), " T ", "TQT", "SSS");
        provider.addItemRecipe(output, "stones", (ItemLike)Items.f_41830_, (ImmutableMap<Character, Object>)ImmutableMap.of((Object)Character.valueOf('S'), GTMaterialTypes.DUST.getMaterialTag(GTLibMaterials.Sand)), "SS", "SS");
        provider.addItemRecipe(output, "stones", (ItemLike)Items.f_41831_, (ImmutableMap<Character, Object>)ImmutableMap.of((Object)Character.valueOf('S'), GTMaterialTypes.DUST.getMaterialTag(GTLibMaterials.RedSand)), "SS", "SS");
        if (GTAPI.isModLoaded("ae2")) {
            provider.removeRecipe(new ResourceLocation("ae2", "misc/vanilla_comparator"));
        }
        GTAPI.all(StoneType.class).forEach(s -> {
            Material m = s.getMaterial();
            if (s instanceof CobbleStoneType) {
                String[] types;
                CobbleStoneType c = (CobbleStoneType)s;
                SimpleCookingRecipeBuilder.m_126272_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{c.getBlock("cobble")}), (ItemLike)c.getBlock(""), (float)0.1f, (int)200).m_142284_("has_cobble", provider.hasSafeItem((ItemLike)c.getBlock("cobble"))).m_142700_(output, new ResourceLocation("gtlib", m.getId() + "_stone"));
                SimpleCookingRecipeBuilder.m_126272_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{c.getBlock("bricks")}), (ItemLike)c.getBlock("bricks_cracked"), (float)0.1f, (int)200).m_142284_("has_bricks", provider.hasSafeItem((ItemLike)c.getBlock("bricks"))).m_142700_(output, new ResourceLocation("gtlib", m.getId() + "_bricks_cracked"));
                for (String type : types = new String[]{"bricks_mossy", "cobble_mossy", "bricks", "cobble", "smooth", ""}) {
                    String[] stringArray;
                    String i = type.isEmpty() ? "" : "_";
                    provider.addStackRecipe(output, "gtlib", "slab_" + m.getId() + i + type, "slabs", new ItemStack((ItemLike)c.getBlock(type + i + "slab"), 6), (ImmutableMap<Character, Object>)ImmutableMap.of((Object)Character.valueOf('S'), (Object)c.getBlock(type)), "SSS");
                    provider.addStackRecipe(output, "gtlib", "stairs_" + m.getId() + i + type, "stairs", new ItemStack((ItemLike)c.getBlock(type + i + "stairs"), 4), (ImmutableMap<Character, Object>)ImmutableMap.of((Object)Character.valueOf('S'), (Object)c.getBlock(type)), "S  ", "SS ", "SSS");
                    provider.addStackRecipe(output, "gtlib", "wall_" + m.getId() + i + type, "walls", new ItemStack((ItemLike)c.getBlock(type + i + "wall"), 6), (ImmutableMap<Character, Object>)ImmutableMap.of((Object)Character.valueOf('S'), (Object)c.getBlock(type)), "SSS", "SSS");
                    if (type.equals("bricks")) {
                        String[] stringArray2 = new String[1];
                        stringArray = stringArray2;
                        stringArray2[0] = "SS";
                    } else {
                        String[] stringArray3 = new String[2];
                        stringArray3[0] = "S";
                        stringArray = stringArray3;
                        stringArray3[1] = "S";
                    }
                    String[] pattern = stringArray;
                    provider.addStackRecipe(output, "gtlib", m.getId() + i + type + "_from_slabs", "slabs", new ItemStack((ItemLike)c.getBlock(type), 1), (ImmutableMap<Character, Object>)ImmutableMap.of((Object)Character.valueOf('S'), (Object)c.getBlock(type + i + "slab")), pattern);
                }
                provider.addStackRecipe(output, "gtlib", "bricks_" + m.getId(), "bricks", new ItemStack((ItemLike)c.getBlock("bricks"), 4), (ImmutableMap<Character, Object>)ImmutableMap.of((Object)Character.valueOf('S'), (Object)c.getBlock("")), "SS", "SS");
                provider.addStackRecipe(output, "gtlib", "polished_" + m.getId(), "bricks", new ItemStack((ItemLike)c.getBlock("smooth"), 2), (ImmutableMap<Character, Object>)ImmutableMap.of((Object)Character.valueOf('S'), (Object)c.getBlock("")), "SS");
                provider.addStackRecipe(output, "gtlib", "bricks_chiseled_" + m.getId(), "bricks", new ItemStack((ItemLike)c.getBlock("bricks_chiseled"), 1), (ImmutableMap<Character, Object>)ImmutableMap.of((Object)Character.valueOf('S'), (Object)c.getBlock("bricks_slab")), "S", "S");
                provider.shapeless(output, "bricks_mossy_" + m.getId(), "bricks", new ItemStack((ItemLike)c.getBlock("bricks_mossy")), c.getBlock("bricks"), Items.f_42029_);
                provider.shapeless(output, "cobble_mossy_" + m.getId(), "bricks", new ItemStack((ItemLike)c.getBlock("cobble_mossy")), c.getBlock("cobble"), Items.f_42029_);
                for (String type : types = new String[]{"stairs", "slab", "wall", "bricks_slab", "bricks_stairs", "bricks_chiseled", "bricks_wall", "bricks", "smooth", "smooth_slab", "smooth_stairs", "smooth_wall"}) {
                    if (s instanceof VanillaStoneType && !type.contains("bricks") && !type.equals("smooth_wall") && (type.contains("slab") || type.contains("stairs") || type.contains("wall"))) continue;
                    int amount = type.contains("slab") ? 2 : 1;
                    SingleItemRecipeBuilder.m_126316_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{c.getBlock("")}), (ItemLike)c.getBlock(type), (int)amount).m_142284_("has_stone", provider.hasSafeItem((ItemLike)c.getBlock(""))).m_142700_(output, new ResourceLocation("gtlib", m.getId() + "_stone_" + type));
                }
                for (String type : CobbleStoneType.SUFFIXES) {
                    Item coverStone;
                    String id = (String)(type.isEmpty() ? c.getId() : c.getId() + "_" + type) + "_cover";
                    Item cover = GTAPI.get(Item.class, id, "antimatter_shared");
                    if (cover == null) continue;
                    SingleItemRecipeBuilder.m_126316_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{c.getBlock(type)}), (ItemLike)cover, (int)4).m_142284_("has_stone", provider.hasSafeItem((ItemLike)c.getBlock(type))).m_142700_(output, new ResourceLocation("gtlib", id));
                    if (!type.equals("bricks") && !type.equals("smooth") && !type.equals("bricks_chiseled") || (coverStone = GTAPI.get(Item.class, c.getId() + "_cover", "antimatter_shared")) == null) continue;
                    SingleItemRecipeBuilder.m_126316_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{coverStone}), (ItemLike)cover, (int)1).m_142284_("has_stone", provider.hasSafeItem((ItemLike)c.getBlock(""))).m_142700_(output, new ResourceLocation("gtlib", id + "_from_regular_cover"));
                }
                SingleItemRecipeBuilder.m_126316_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{c.getBlock("cobble")}), (ItemLike)c.getBlock("cobble_slab"), (int)2).m_142284_("has_cobble", provider.hasSafeItem((ItemLike)c.getBlock("cobble"))).m_142700_(output, new ResourceLocation("gtlib", m.getId() + "_cobble_slab"));
                SingleItemRecipeBuilder.m_126313_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{c.getBlock("cobble")}), (ItemLike)c.getBlock("cobble_stairs")).m_142284_("has_cobble", provider.hasSafeItem((ItemLike)c.getBlock("cobble"))).m_142700_(output, new ResourceLocation("gtlib", m.getId() + "_cobble_stairs"));
                SingleItemRecipeBuilder.m_126313_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{c.getBlock("cobble")}), (ItemLike)c.getBlock("cobble_wall")).m_142284_("has_cobble", provider.hasSafeItem((ItemLike)c.getBlock("cobble"))).m_142700_(output, new ResourceLocation("gtlib", m.getId() + "_cobble_wall"));
                SingleItemRecipeBuilder.m_126316_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{c.getBlock("cobble_mossy")}), (ItemLike)c.getBlock("cobble_mossy_slab"), (int)2).m_142284_("has_cobble_mossy", provider.hasSafeItem((ItemLike)c.getBlock("cobble_mossy"))).m_142700_(output, new ResourceLocation("gtlib", m.getId() + "_cobble_mossy_slab"));
                SingleItemRecipeBuilder.m_126313_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{c.getBlock("cobble_mossy")}), (ItemLike)c.getBlock("cobble_mossy_stairs")).m_142284_("has_cobble_mossy", provider.hasSafeItem((ItemLike)c.getBlock("cobble_mossy"))).m_142700_(output, new ResourceLocation("gtlib", m.getId() + "_cobble_mossy_stairs"));
                SingleItemRecipeBuilder.m_126313_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{c.getBlock("cobble_mossy")}), (ItemLike)c.getBlock("cobble_mossy_wall")).m_142284_("has_cobble_mossy", provider.hasSafeItem((ItemLike)c.getBlock("cobble_mossy"))).m_142700_(output, new ResourceLocation("gtlib", m.getId() + "_cobble_mossy_wall"));
                SingleItemRecipeBuilder.m_126316_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{c.getBlock("bricks")}), (ItemLike)c.getBlock("bricks_slab"), (int)2).m_142284_("has_bricks", provider.hasSafeItem((ItemLike)c.getBlock("bricks"))).m_142700_(output, new ResourceLocation("gtlib", m.getId() + "_bricks_slab2"));
                SingleItemRecipeBuilder.m_126313_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{c.getBlock("bricks")}), (ItemLike)c.getBlock("bricks_stairs")).m_142284_("has_bricks", provider.hasSafeItem((ItemLike)c.getBlock("bricks"))).m_142700_(output, new ResourceLocation("gtlib", m.getId() + "_bricks_stairs2"));
                SingleItemRecipeBuilder.m_126313_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{c.getBlock("bricks")}), (ItemLike)c.getBlock("bricks_wall")).m_142284_("has_bricks", provider.hasSafeItem((ItemLike)c.getBlock("bricks"))).m_142700_(output, new ResourceLocation("gtlib", m.getId() + "_bricks_wall2"));
                SingleItemRecipeBuilder.m_126313_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{c.getBlock("bricks")}), (ItemLike)c.getBlock("bricks_chiseled")).m_142284_("has_bricks", provider.hasSafeItem((ItemLike)c.getBlock("bricks"))).m_142700_(output, new ResourceLocation("gtlib", m.getId() + "_bricks_chiseled2"));
                SingleItemRecipeBuilder.m_126316_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{c.getBlock("bricks_mossy")}), (ItemLike)c.getBlock("bricks_mossy_slab"), (int)2).m_142284_("has_bricks_mossy", provider.hasSafeItem((ItemLike)c.getBlock("bricks_mossy"))).m_142700_(output, new ResourceLocation("gtlib", m.getId() + "_bricks_mossy_slab"));
                SingleItemRecipeBuilder.m_126313_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{c.getBlock("bricks_mossy")}), (ItemLike)c.getBlock("bricks_mossy_stairs")).m_142284_("has_bricks_mossy", provider.hasSafeItem((ItemLike)c.getBlock("bricks_mossy"))).m_142700_(output, new ResourceLocation("gtlib", m.getId() + "_bricks_mossy_stairs"));
                SingleItemRecipeBuilder.m_126313_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{c.getBlock("bricks_mossy")}), (ItemLike)c.getBlock("bricks_mossy_wall")).m_142284_("has_bricks_mossy", provider.hasSafeItem((ItemLike)c.getBlock("bricks_mossy"))).m_142700_(output, new ResourceLocation("gtlib", m.getId() + "_bricks_mossy_wall"));
                if (!(s instanceof VanillaStoneType)) {
                    SingleItemRecipeBuilder.m_126316_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{c.getBlock("smooth")}), (ItemLike)c.getBlock("smooth_slab"), (int)2).m_142284_("has_smooth", provider.hasSafeItem((ItemLike)c.getBlock("smooth"))).m_142700_(output, new ResourceLocation("gtlib", m.getId() + "_smooth_slab"));
                    SingleItemRecipeBuilder.m_126313_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{c.getBlock("smooth")}), (ItemLike)c.getBlock("smooth_stairs")).m_142284_("has_smooth", provider.hasSafeItem((ItemLike)c.getBlock("smooth"))).m_142700_(output, new ResourceLocation("gtlib", m.getId() + "_smooth_stairs"));
                }
                SingleItemRecipeBuilder.m_126313_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{c.getBlock("smooth")}), (ItemLike)c.getBlock("smooth_wall")).m_142284_("has_smooth", provider.hasSafeItem((ItemLike)c.getBlock("smooth"))).m_142700_(output, new ResourceLocation("gtlib", m.getId() + "_smooth_wall"));
            }
        });
    }
}

