/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.blockentity.pipe;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collection;
import net.minecraft.client.gui.Font;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.LazyOptional;
import org.gtreimagined.gtlib.blockentity.pipe.BlockEntityPipe;
import org.gtreimagined.gtlib.capability.Dispatch;
import org.gtreimagined.gtlib.gui.GuiInstance;
import org.gtreimagined.gtlib.gui.IGuiElement;
import org.gtreimagined.gtlib.gui.widget.InfoRenderWidget;
import org.gtreimagined.gtlib.integration.xei.renderer.IInfoRenderer;
import org.gtreimagined.gtlib.pipe.BlockCable;
import org.gtreimagined.gtlib.pipe.types.Cable;
import org.gtreimagined.gtlib.pipe.types.PipeType;
import org.gtreimagined.tesseract.api.capability.TesseractEUCapability;
import org.gtreimagined.tesseract.api.eu.EUGrid;
import org.gtreimagined.tesseract.api.eu.EUHolder;
import org.gtreimagined.tesseract.api.eu.EUNetwork;
import org.gtreimagined.tesseract.api.eu.IEUCable;
import org.gtreimagined.tesseract.api.eu.IEnergyHandler;
import org.gtreimagined.tesseract.api.forge.TesseractCaps;
import org.gtreimagined.tesseract.graph.IElement;

public class BlockEntityCable<T extends PipeType<T>>
extends BlockEntityPipe<T>
implements IEUCable,
Dispatch.Sided<IEnergyHandler>,
IInfoRenderer<InfoRenderWidget.TesseractGTWidget> {
    private long holder;
    private EUNetwork network;

    public BlockEntityCable(T type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.pipeCapHolder.set(() -> this);
    }

    @Override
    public void onLoad() {
        this.holder = EUHolder.create((IEUCable)this, (long)0L);
        super.onLoad();
    }

    @Override
    protected void register() {
        EUGrid.INSTANCE.addElement((IElement)this);
    }

    @Override
    protected boolean deregister() {
        EUGrid.INSTANCE.removeElement((IElement)this);
        return true;
    }

    @Override
    public Class<?> getCapClass() {
        return IEnergyHandler.class;
    }

    @Override
    public void onBlockUpdate(BlockPos neighbour) {
        super.onBlockUpdate(neighbour);
        EUGrid.INSTANCE.addElement((IElement)this);
    }

    public long getVoltage() {
        return ((Cable)this.getPipeType()).getTier().getVoltage();
    }

    public boolean insulated() {
        return ((BlockCable)this.m_58900_().m_60734_()).insulated;
    }

    public long getHolder() {
        return this.holder;
    }

    public void setHolder(long holder) {
        this.holder = holder;
    }

    public double getLoss() {
        return ((Cable)this.getPipeType()).getLoss();
    }

    public int getAmps() {
        return ((Cable)this.getPipeType()).getAmps(this.getPipeSize());
    }

    @Override
    public boolean connects(Direction direction) {
        return this.canConnect(direction.m_122411_());
    }

    @Override
    public boolean validate(Direction dir) {
        if (!super.validate(dir)) {
            return false;
        }
        BlockEntity tile = this.getCachedBlockEntity(dir);
        if (tile == null) {
            return false;
        }
        return tile.getCapability(TesseractCaps.ENERGY_HANDLER_CAPABILITY, dir.m_122424_()).isPresent();
    }

    public BlockEntity getBlockEntity() {
        return this;
    }

    @Override
    protected void serverTick(Level level, BlockPos pos, BlockState state) {
        super.serverTick(level, pos, state);
    }

    @Override
    public LazyOptional<IEnergyHandler> forSide(Direction side) {
        return LazyOptional.of(() -> new TesseractEUCapability((BlockEntity)this, side, !this.isConnector(), (stack, dir, input, simulate) -> this.coverHandler.map(t -> t.onTransfer(stack, dir, input, simulate)).orElse(false)));
    }

    @Override
    public LazyOptional<IEnergyHandler> forNullSide() {
        return this.forSide(null);
    }

    @Override
    public void addWidgets(GuiInstance instance, IGuiElement parent) {
        super.addWidgets(instance, parent);
        instance.addWidget(InfoRenderWidget.TesseractGTWidget.build().setPos(10, 10));
    }

    @Override
    public int drawInfo(InfoRenderWidget.TesseractGTWidget instance, PoseStack stack, Font renderer, int left, int top) {
        renderer.m_92883_(stack, "Amp average: " + instance.ampAverage, (float)left, (float)top, 0xFAFAFF);
        renderer.m_92883_(stack, "Average extracted: " + (double)instance.voltAverage / 20.0, (float)left, (float)(top + 16), 0xFAFAFF);
        renderer.m_92883_(stack, "Average inserted: " + ((double)instance.voltAverage - instance.loss) / 20.0, (float)left, (float)(top + 24), 0xFAFAFF);
        renderer.m_92883_(stack, "Loss average: " + instance.loss / 20.0, (float)left, (float)(top + 32), 0xFAFAFF);
        return 40;
    }

    public void getNeighbours(Collection<IEUCable> neighbours) {
        for (Direction dir : Direction.values()) {
            IEUCable cable;
            BlockEntity pipe = this.getCachedBlockEntity(dir);
            if (!(pipe instanceof IEUCable) || !(cable = (IEUCable)pipe).connects(dir.m_122424_()) || !this.connects(dir)) continue;
            neighbours.add(cable);
        }
    }

    public EUNetwork getNetwork() {
        return this.network;
    }

    public void setNetwork(EUNetwork network) {
        this.network = network;
    }
}

