/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.blockentity;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import lombok.Generated;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.LazyLoadedValue;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.GTLibConfig;
import org.gtreimagined.gtlib.GTLibProperties;
import org.gtreimagined.gtlib.Ref;
import org.gtreimagined.gtlib.blockentity.BlockEntityTickable;
import org.gtreimagined.gtlib.blockentity.multi.BlockEntityBasicMultiMachine;
import org.gtreimagined.gtlib.blockentity.pipe.BlockEntityCable;
import org.gtreimagined.gtlib.capability.CoverHandler;
import org.gtreimagined.gtlib.capability.EnergyHandler;
import org.gtreimagined.gtlib.capability.FluidHandler;
import org.gtreimagined.gtlib.capability.GTLibCaps;
import org.gtreimagined.gtlib.capability.Holder;
import org.gtreimagined.gtlib.capability.ICoverHandler;
import org.gtreimagined.gtlib.capability.ICoverHandlerProvider;
import org.gtreimagined.gtlib.capability.IGuiHandler;
import org.gtreimagined.gtlib.capability.IMachineHandler;
import org.gtreimagined.gtlib.capability.machine.DefaultHeatHandler;
import org.gtreimagined.gtlib.capability.machine.MachineCoverHandler;
import org.gtreimagined.gtlib.capability.machine.MachineEnergyHandler;
import org.gtreimagined.gtlib.capability.machine.MachineFEHandler;
import org.gtreimagined.gtlib.capability.machine.MachineFluidHandler;
import org.gtreimagined.gtlib.capability.machine.MachineItemHandler;
import org.gtreimagined.gtlib.capability.machine.MachineRecipeHandler;
import org.gtreimagined.gtlib.client.SoundHelper;
import org.gtreimagined.gtlib.client.dynamic.DynamicTexturer;
import org.gtreimagined.gtlib.client.dynamic.DynamicTexturers;
import org.gtreimagined.gtlib.client.tesr.Caches;
import org.gtreimagined.gtlib.client.tesr.MachineTESR;
import org.gtreimagined.gtlib.cover.CoverFactory;
import org.gtreimagined.gtlib.cover.ICover;
import org.gtreimagined.gtlib.gui.GuiData;
import org.gtreimagined.gtlib.gui.GuiInstance;
import org.gtreimagined.gtlib.gui.IGuiElement;
import org.gtreimagined.gtlib.gui.SlotData;
import org.gtreimagined.gtlib.gui.SlotType;
import org.gtreimagined.gtlib.gui.container.ContainerMachine;
import org.gtreimagined.gtlib.gui.event.GuiEvents;
import org.gtreimagined.gtlib.gui.event.IGuiEvent;
import org.gtreimagined.gtlib.gui.event.SlotClickEvent;
import org.gtreimagined.gtlib.gui.widget.FluidSlotWidget;
import org.gtreimagined.gtlib.gui.widget.SlotWidget;
import org.gtreimagined.gtlib.machine.BlockMachine;
import org.gtreimagined.gtlib.machine.MachineState;
import org.gtreimagined.gtlib.machine.Tier;
import org.gtreimagined.gtlib.machine.event.IMachineEvent;
import org.gtreimagined.gtlib.machine.types.BasicMultiMachine;
import org.gtreimagined.gtlib.machine.types.Machine;
import org.gtreimagined.gtlib.network.packets.AbstractGuiEventPacket;
import org.gtreimagined.gtlib.network.packets.TileGuiEventPacket;
import org.gtreimagined.gtlib.recipe.IRecipe;
import org.gtreimagined.gtlib.structure.StructureCache;
import org.gtreimagined.gtlib.texture.Texture;
import org.gtreimagined.gtlib.tool.GTToolType;
import org.gtreimagined.gtlib.util.Cache;
import org.gtreimagined.gtlib.util.Utils;
import org.gtreimagined.tesseract.api.eu.EUGrid;
import org.gtreimagined.tesseract.api.eu.EUNetwork;
import org.gtreimagined.tesseract.api.eu.IEUCable;
import org.gtreimagined.tesseract.api.eu.IEUNode;
import org.gtreimagined.tesseract.api.eu.IEnergyHandler;
import org.gtreimagined.tesseract.api.fe.IExtendedEnergyStorage;
import org.gtreimagined.tesseract.api.forge.TesseractCaps;
import org.gtreimagined.tesseract.api.hu.IHeatHandler;
import org.gtreimagined.tesseract.graph.IElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockEntityMachine<T extends BlockEntityMachine<T>>
extends BlockEntityTickable<T>
implements MenuProvider,
IMachineHandler,
IGuiHandler,
ICoverHandlerProvider<T>,
IEUNode {
    protected final Set<ContainerMachine<T>> openContainers = new ObjectOpenHashSet();
    protected Machine<?> type;
    protected Tier tier;
    protected MachineState machineState;
    protected MachineState disabledState;
    protected long lastSoundTime;
    protected boolean muffled = false;
    @OnlyIn(value=Dist.CLIENT)
    public SoundInstance playingSound;
    public Holder<IItemHandler, MachineItemHandler<T>> itemHandler = new Holder(IItemHandler.class, this.dispatch);
    public Holder<IFluidHandler, MachineFluidHandler<T>> fluidHandler = new Holder(IFluidHandler.class, this.dispatch);
    public Holder<ICoverHandler<?>, MachineCoverHandler<T>> coverHandler = new Holder(ICoverHandler.class, this.dispatch, null);
    public Holder<IEnergyHandler, MachineEnergyHandler<T>> energyHandler = new Holder(IEnergyHandler.class, this.dispatch);
    public Holder<IHeatHandler, DefaultHeatHandler> heatHandler = new Holder(IHeatHandler.class, this.dispatch);
    public Holder<IExtendedEnergyStorage, MachineFEHandler<T>> feHandler = new Holder(IExtendedEnergyStorage.class, this.dispatch);
    public Holder<MachineRecipeHandler<?>, MachineRecipeHandler<T>> recipeHandler = new Holder(MachineRecipeHandler.class, this.dispatch, null);
    EUNetwork network;
    public LazyLoadedValue<DynamicTexturer<Machine<?>, DynamicKey>> multiTexturer;
    public Cache<List<Caches.LiquidCache>> liquidCache;

    public BlockEntityMachine(Machine<?> type, BlockPos pos, BlockState state) {
        super(type.getTileType(), pos, state);
        this.tier = ((BlockMachine)state.m_60734_()).getTier();
        this.type = type;
        this.machineState = this.getDefaultMachineState();
        if (type.has("item") || type.has("cell")) {
            this.itemHandler.set(() -> new MachineItemHandler<BlockEntityMachine>(this));
        }
        if (type.has("fluid")) {
            this.fluidHandler.set(() -> new MachineFluidHandler<BlockEntityMachine>(this));
        }
        if (type.has("eu")) {
            this.energyHandler.set(() -> new MachineEnergyHandler<BlockEntityMachine>(this, type.getAmps(), type.has("generator")));
        }
        if (type.has("fe")) {
            this.feHandler.set(() -> new MachineFEHandler<BlockEntityMachine>(this, (int)(this.getMachineTier().getVoltage() * 100L), type.has("generator")));
        }
        if (type.has("heat")) {
            this.heatHandler.set(() -> new DefaultHeatHandler(this, (int)(this.getMachineTier().getVoltage() * 4L), type.has("generator") ? 0 : (int)this.getMachineTier().getVoltage(), type.has("generator") ? (int)this.getMachineTier().getVoltage() : 0));
        }
        if (type.has("recipe")) {
            this.recipeHandler.set(() -> new MachineRecipeHandler<BlockEntityMachine>(this));
        }
        if (type.has("coverable")) {
            this.coverHandler.set(() -> new MachineCoverHandler<BlockEntityMachine>(this));
        }
        this.multiTexturer = new LazyLoadedValue(() -> new DynamicTexturer(DynamicTexturers.TILE_DYNAMIC_TEXTURER));
    }

    public void addOpenContainer(ContainerMachine<T> c, Player player) {
        this.openContainers.add(c);
    }

    public void onContainerClose(ContainerMachine<T> c, Player player) {
        this.openContainers.remove(c);
    }

    @Override
    public void onFirstTickServer(Level level, BlockPos pos, BlockState state) {
        super.onFirstTickServer(level, pos, state);
        this.itemHandler.ifPresent(MachineItemHandler::init);
        this.fluidHandler.ifPresent(IMachineHandler::init);
        this.energyHandler.ifPresent(MachineEnergyHandler::init);
        this.feHandler.ifPresent(MachineFEHandler::init);
        this.recipeHandler.ifPresent(MachineRecipeHandler::init);
        this.coverHandler.ifPresent(CoverHandler::onFirstTick);
        EUGrid.INSTANCE.addElement((IElement)this);
    }

    @Override
    public void onLoad() {
        super.onLoad();
        if (this.f_58857_.f_46443_) {
            this.liquidCache = new Cache<List>(() -> MachineTESR.buildLiquids(this));
        }
    }

    protected void cacheInvalidate() {
        if (this.liquidCache != null) {
            this.liquidCache.invalidate();
        }
    }

    public String getDomain() {
        return this.getMachineType().getDomain();
    }

    @Override
    public boolean isRemote() {
        return this.f_58857_.f_46443_;
    }

    @Override
    public void addWidgets(GuiInstance instance, IGuiElement parent) {
        int index = 0;
        for (SlotData<?> slotData : this.getMachineType().getSlots(this.getMachineTier())) {
            instance.addWidget(SlotWidget.build(slotData));
        }
        for (SlotData<Object> slotData : this.getMachineType().getGuiData().getSlots().getSlots(SlotType.FL_IN, this.getMachineTier())) {
            instance.addWidget(FluidSlotWidget.build(index++, slotData));
        }
        for (SlotData<Object> slotData : this.getMachineType().getGuiData().getSlots().getSlots(SlotType.FL_OUT, this.getMachineTier())) {
            instance.addWidget(FluidSlotWidget.build(index++, slotData));
        }
        this.getMachineType().getCallbacks().forEach(t -> t.accept(instance));
    }

    @Override
    public ResourceLocation getGuiTexture() {
        return this.getMachineType().getGuiData().getTexture(this.getMachineTier(), "machine");
    }

    @Override
    public GuiData getGui() {
        return this.getMachineType().getGuiData();
    }

    public void onRecipePreTick() {
    }

    public void onRecipePostTick() {
    }

    public void onMachineStop() {
        this.lastSoundTime = 0L;
    }

    public void onMachineStarted(IRecipe r) {
    }

    @Override
    public void onBlockUpdate(BlockPos neighbor) {
        super.onBlockUpdate(neighbor);
        Direction facing = Utils.getOffsetFacing(this.m_58899_(), neighbor);
        if (facing != null) {
            this.coverHandler.ifPresent(h -> h.onBlockUpdate(facing));
        }
        this.coverHandler.ifPresent(CoverHandler::onBlockUpdateAllSides);
        EUGrid.INSTANCE.addElement((IElement)this);
    }

    @Override
    public void serverTick(Level level, BlockPos pos, BlockState state) {
        double d;
        this.itemHandler.ifPresent(MachineItemHandler::onUpdate);
        this.energyHandler.ifPresent(MachineEnergyHandler::onUpdate);
        this.feHandler.ifPresent(MachineFEHandler::onUpdate);
        this.heatHandler.ifPresent(handler -> handler.update(this.getMachineState() == MachineState.ACTIVE));
        this.fluidHandler.ifPresent(MachineFluidHandler::onUpdate);
        this.coverHandler.ifPresent(MachineCoverHandler::onUpdate);
        this.recipeHandler.ifPresent(MachineRecipeHandler::onServerUpdate);
        if (this.allowExplosionsInRain() && (d = Ref.RNG.nextDouble()) > 0.97 && this.f_58857_.m_46758_(new BlockPos(this.f_58858_.m_123341_(), this.f_58858_.m_123342_() + 1, this.f_58858_.m_123343_())) && this.energyHandler.map(t -> t.getEnergy() > 0L).orElse(false).booleanValue()) {
            Utils.createExplosion(this.f_58857_, this.f_58858_, 6.0f, Explosion.BlockInteraction.DESTROY);
            level.m_5594_(null, this.f_58858_, Ref.MACHINE_EXPLODE, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    protected boolean allowExplosionsInRain() {
        return GTLibConfig.RAIN_EXPLODES_MACHINES.get();
    }

    @Override
    public void clientTick(Level level, BlockPos pos, BlockState state) {
        this.coverHandler.ifPresent(MachineCoverHandler::onUpdate);
    }

    @Override
    protected boolean canClientTick() {
        return this.getMachineType().isClientTicking();
    }

    @Override
    public void onRemove() {
        if (this.isServerSide()) {
            this.coverHandler.ifPresent(MachineCoverHandler::onRemove);
            this.fluidHandler.ifPresent(FluidHandler::onRemove);
            this.itemHandler.ifPresent(MachineItemHandler::onRemove);
            this.energyHandler.ifPresent(MachineEnergyHandler::onRemove);
            this.feHandler.ifPresent(MachineFEHandler::onRemove);
            this.recipeHandler.ifPresent(MachineRecipeHandler::onRemove);
            this.dispatch.invalidate();
            EUGrid.INSTANCE.removeElement((IElement)this);
        } else if (this.f_58857_ != null) {
            SoundHelper.clear(this.f_58857_, this.f_58858_);
        }
    }

    public void onDrop(BlockState state, LootContext.Builder builder, List<ItemStack> drops) {
    }

    public void dropInventory(BlockState state, LootContext.Builder builder, List<ItemStack> drops) {
        this.itemHandler.ifPresent(t -> drops.addAll(t.getAllItems()));
    }

    public void dropCovers(BlockState state, LootContext.Builder builder, List<ItemStack> drops) {
        this.coverHandler.ifPresent(c -> {
            ItemStack machine;
            if (!drops.isEmpty() && (machine = (ItemStack)drops.get(0)).m_41720_() == state.m_60734_().m_5456_()) {
                c.writeToStack(machine);
            }
        });
    }

    public void onPlacedBy(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        if (!this.f_58857_.m_5776_()) {
            this.coverHandler.ifPresent(c -> c.readFromStack(stack));
        }
    }

    protected void markDirty() {
        this.m_58904_().m_46745_(this.m_58899_()).m_8092_(true);
    }

    @Override
    public void onMachineEvent(IMachineEvent event, Object ... data) {
        if (this.m_58904_() != null && !this.m_58904_().f_46443_) {
            this.coverHandler.ifPresent(c -> c.onMachineEvent(event, data));
            this.itemHandler.ifPresent(i -> i.onMachineEvent(event, data));
            this.energyHandler.ifPresent(e -> e.onMachineEvent(event, data));
            this.feHandler.ifPresent(e -> e.onMachineEvent(event, data));
            this.fluidHandler.ifPresent(f -> f.onMachineEvent(event, data));
            this.recipeHandler.ifPresent(r -> r.onMachineEvent(event, data));
            this.markDirty();
        }
    }

    public Machine<?> getMachineType() {
        if (this.type != null) {
            return this.type;
        }
        Block block = this.m_58900_().m_60734_();
        if (!(block instanceof BlockMachine)) {
            return null;
        }
        return ((BlockMachine)block).getType();
    }

    public Tier getMachineTier() {
        if (this.tier != null) {
            return this.tier;
        }
        Block block = this.m_58900_().m_60734_();
        if (!(block instanceof BlockMachine)) {
            return Tier.LV;
        }
        return ((BlockMachine)block).getTier();
    }

    public Tier getPowerLevel() {
        return this.getMachineTier();
    }

    public boolean has(String flag) {
        return this.getMachineType().has(flag);
    }

    public int getWeakRedstonePower(Direction facing) {
        if (facing != null && this.getCover(facing).getWeakPower() >= 0) {
            return this.getCover(facing).getWeakPower();
        }
        return 0;
    }

    public int getStrongRedstonePower(Direction facing) {
        if (facing != null && this.getCover(facing).getStrongPower() >= 0) {
            return this.getCover(facing).getStrongPower();
        }
        return 0;
    }

    public Direction getFacing() {
        if (this.f_58857_ == null) {
            return Direction.SOUTH;
        }
        BlockState state = this.m_58900_();
        return this.getFacing(state);
    }

    public Direction getFacing(BlockState state) {
        if (state == Blocks.f_50016_.m_49966_()) {
            return Direction.SOUTH;
        }
        if (this.getMachineType().isNoFacing()) {
            return Direction.SOUTH;
        }
        if (this.getMachineType().isVerticalFacingAllowed()) {
            return (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
        }
        return (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
    }

    public boolean setFacing(Direction side) {
        if (this.getMachineType().isNoFacing() || side == this.getFacing() || side.m_122434_() == Direction.Axis.Y && !this.getMachineType().isVerticalFacingAllowed()) {
            return false;
        }
        boolean isEmpty = this.coverHandler.map(ch -> ch.get(side).isEmpty()).orElse(true);
        if (isEmpty) {
            BlockState state = this.m_58900_();
            state = this.getMachineType().isVerticalFacingAllowed() ? (BlockState)state.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)side) : (BlockState)state.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)side);
            this.m_58904_().m_46597_(this.m_58899_(), state);
            this.invalidateCaps();
            return true;
        }
        return false;
    }

    protected boolean setFacing(Player player, Direction side) {
        boolean setFacing = this.setFacing(side);
        if (setFacing) {
            player.m_6330_(Ref.WRENCH, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        return setFacing;
    }

    public boolean wrenchMachine(Player player, BlockHitResult res, boolean crouch) {
        if ((crouch || this.getMachineType().getOutputCover() == ICover.emptyFactory) && !this.type.isNoFacing()) {
            return this.setFacing(player, Utils.getInteractSide(res));
        }
        return this.setOutputFacing(player, Utils.getInteractSide(res));
    }

    @Override
    public void onGuiEvent(IGuiEvent event, Player player) {
        if (event.getFactory() == GuiEvents.ITEM_EJECT || event.getFactory() == GuiEvents.FLUID_EJECT) {
            this.coverHandler.ifPresent(ch -> ch.getOutputCover().onGuiEvent(event, player));
        }
        if (event.getFactory() == SlotClickEvent.SLOT_CLICKED) {
            this.itemHandler.ifPresent(t -> {});
        }
    }

    @Override
    public AbstractGuiEventPacket createGuiPacket(IGuiEvent event) {
        return new TileGuiEventPacket(event, this.m_58899_());
    }

    @Override
    public String handlerDomain() {
        return this.getDomain();
    }

    public void setMuffled(boolean muffled) {
        this.muffled = muffled;
        this.sidedSync(true);
        if (this.muffled && this.f_58857_ != null && this.f_58857_.f_46443_) {
            SoundHelper.clear(this.f_58857_, this.m_58899_());
        }
    }

    public Direction getOutputFacing() {
        if (this.type.getOutputCover() != null && this.type.getOutputCover() != ICover.emptyFactory && this.coverHandler.isPresent()) {
            Direction dir = this.coverHandler.get().getOutputFacing();
            return dir == null ? this.getFacing().m_122424_() : dir;
        }
        return null;
    }

    public boolean setOutputFacing(Player player, Direction side) {
        return this.coverHandler.map(h -> h.setOutputFacing(player, side)).orElse(false);
    }

    public Direction getSecondaryOutputFacing() {
        if (this.type.getSecondaryOutputCover() != null && this.type.getSecondaryOutputCover() != ICover.emptyFactory) {
            return this.coverHandler.map(MachineCoverHandler::getSecondaryOutputFacing).orElse(this.getFacing().m_122424_());
        }
        return null;
    }

    public boolean setSecondaryOutputFacing(Player player, Direction side) {
        return this.coverHandler.map(h -> h.setSecondaryOutputFacing(player, side)).orElse(false);
    }

    public MachineState getDefaultMachineState() {
        return MachineState.IDLE;
    }

    public boolean isDefaultMachineState() {
        return this.getMachineState() == this.getDefaultMachineState();
    }

    public long getMaxInputVoltage() {
        return this.energyHandler.map(EnergyHandler::getInputVoltage).orElse(0L);
    }

    public long getMaxOutputVoltage() {
        return this.energyHandler.map(EnergyHandler::getOutputVoltage).orElse(0L);
    }

    public void resetMachine() {
        this.setMachineState(this.getDefaultMachineState());
    }

    public boolean toggleMachine() {
        if (this.getMachineState() == MachineState.DISABLED) {
            this.setMachineState(this.disabledState);
            this.disabledState = null;
            if (this.getMachineState().allowRecipeCheck()) {
                this.recipeHandler.ifPresent(MachineRecipeHandler::checkRecipe);
            }
        } else {
            this.disableMachine();
        }
        return true;
    }

    protected void disableMachine() {
        this.disabledState = this.getMachineState();
        if (!this.has("generator")) {
            this.recipeHandler.ifPresent(MachineRecipeHandler::resetProgress);
        }
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            SoundHelper.clear(this.f_58857_, this.m_58899_());
        }
        this.setMachineState(MachineState.DISABLED);
    }

    public void setMachineState(MachineState newState) {
        if (this.machineState != newState) {
            MachineState old = this.machineState;
            this.machineState = newState;
            if (this.f_58857_ != null) {
                this.sidedSync(true);
                if (!this.f_58857_.f_46443_) {
                    if (old == MachineState.ACTIVE) {
                        this.onMachineStop();
                    } else if (newState == MachineState.ACTIVE && this.recipeHandler.isPresent()) {
                        MachineRecipeHandler<T> handler = this.recipeHandler.get();
                        this.onMachineStarted(handler.getActiveRecipe());
                    }
                } else {
                    this.cacheInvalidate();
                }
            }
            this.m_6596_();
            if (this.f_58857_ != null && this.f_58857_.f_46443_ && this.getMachineType().machineNoise != null) {
                if (newState == MachineState.ACTIVE) {
                    if (!this.muffled) {
                        SoundHelper.startLoop(this.type, this.f_58857_, this.m_58899_());
                    }
                } else if (old == MachineState.ACTIVE) {
                    SoundHelper.clear(this.f_58857_, this.m_58899_());
                }
            }
        }
    }

    public CoverFactory[] getValidCovers() {
        return (CoverFactory[])GTAPI.all(CoverFactory.class).stream().filter(t -> t.getIsValid().test(this)).toArray(CoverFactory[]::new);
    }

    public ICover getCover(Direction side) {
        return this.coverHandler.map(h -> h.get(side)).orElse(ICover.empty);
    }

    public Function<Direction, Texture> getMultiTexture() {
        if (this.getMachineType() instanceof BasicMultiMachine) {
            return null;
        }
        BlockEntityBasicMultiMachine mTile = StructureCache.getAnyMulti(this.m_58904_(), this.f_58858_, BlockEntityBasicMultiMachine.class);
        if (mTile != null) {
            return dir -> mTile.getTextureForHatches((Direction)dir, this.f_58858_);
        }
        return null;
    }

    public InteractionResult onInteractBoth(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit, @Nullable GTToolType type) {
        return this.isServerSide() ? this.onInteractServer(state, world, pos, player, hand, hit, type) : this.onInteractClient(state, world, pos, player, hand, hit, type);
    }

    public InteractionResult onInteractServer(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit, @Nullable GTToolType type) {
        return InteractionResult.PASS;
    }

    public InteractionResult onInteractClient(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit, @Nullable GTToolType type) {
        return InteractionResult.PASS;
    }

    @NotNull
    public Component m_5446_() {
        return this.getMachineType().getDisplayName(this.getMachineTier());
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, @NotNull Inventory inv, @NotNull Player player) {
        return this.getMachineType().has("gui") ? (AbstractContainerMenu)this.getMachineType().getGuiData().getMenuHandler().menu(this, inv, windowId) : null;
    }

    public boolean canPlayerOpenGui(Player playerEntity) {
        return true;
    }

    public void invalidateCaps() {
        if (this.isServerSide()) {
            this.dispatch.invalidate();
        }
    }

    public void invalidateCaps(Direction side) {
        if (this.isServerSide()) {
            this.dispatch.invalidate(side);
        }
    }

    public void invalidateCap(Class<?> cap) {
        if (this.isServerSide()) {
            this.dispatch.invalidate(cap);
        }
    }

    public <V> boolean blocksCapability(@NotNull Class<V> cap, Direction side) {
        return this.coverHandler.map(t -> t.blocksCapability(cap, side)).orElse(false);
    }

    @NotNull
    public <U> LazyOptional<U> getCapability(@NotNull Capability<U> cap, @Nullable Direction side) {
        int index;
        int n = index = side == null ? 6 : side.m_122411_();
        if (side == this.getFacing() && !this.allowsFrontIO()) {
            return LazyOptional.empty();
        }
        if (this.blocksCapability((Class)GTLibCaps.CAP_MAP.inverse().get(cap), side)) {
            return LazyOptional.empty();
        }
        return this.getCap(cap, side);
    }

    protected <U> LazyOptional<U> getCap(@NotNull Capability<U> cap, @Nullable Direction side) {
        int index;
        int n = index = side == null ? 6 : side.m_122411_();
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && this.fluidHandler.isPresent()) {
            return this.fluidHandler.side(side).cast();
        }
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this.itemHandler.isPresent()) {
            return this.itemHandler.side(side).cast();
        }
        if (cap == TesseractCaps.ENERGY_HANDLER_CAPABILITY && this.energyHandler.isPresent()) {
            return this.energyHandler.side(side).cast();
        }
        if (cap == CapabilityEnergy.ENERGY && this.feHandler.isPresent()) {
            return this.feHandler.side(side).cast();
        }
        return super.getCapability(cap, side);
    }

    public final boolean allowsFrontIO() {
        return this.getMachineType().allowsFrontIO();
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, Random random) {
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.setMachineState(MachineState.VALUES[tag.m_128451_("s")]);
        if (tag.m_128441_("muf")) {
            this.setMuffled(tag.m_128471_("muf"));
        }
        if (tag.m_128441_("sd")) {
            this.disabledState = MachineState.VALUES[tag.m_128451_("sd")];
        }
        if (tag.m_128441_("it")) {
            this.itemHandler.ifPresent(i -> i.deserialize(tag.m_128469_("it")));
        }
        if (tag.m_128441_("en")) {
            this.energyHandler.ifPresent(e -> e.deserialize(tag.m_128469_("en")));
        }
        if (tag.m_128441_("fe")) {
            this.feHandler.ifPresent(e -> e.deserialize(tag.m_128469_("fe")));
        }
        if (tag.m_128441_("he")) {
            this.heatHandler.ifPresent(h -> h.deserialize(tag.m_128469_("he")));
        }
        if (tag.m_128441_("co")) {
            this.coverHandler.ifPresent(e -> e.deserialize(tag.m_128469_("co")));
        }
        if (tag.m_128441_("fl")) {
            this.fluidHandler.ifPresent(e -> e.deserialize(tag.m_128469_("fl")));
            if (this.f_58857_ != null && this.f_58857_.f_46443_) {
                this.cacheInvalidate();
            }
        }
        if (tag.m_128441_("re")) {
            this.recipeHandler.ifPresent(e -> e.deserialize(tag.m_128469_("re")));
        }
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("s", this.machineState.ordinal());
        tag.m_128379_("muf", this.muffled);
        if (this.disabledState != null) {
            tag.m_128405_("sd", this.disabledState.ordinal());
        }
        this.itemHandler.ifPresent(i -> tag.m_128365_("it", (Tag)i.serialize(new CompoundTag())));
        this.energyHandler.ifPresent(e -> tag.m_128365_("en", (Tag)e.serialize(new CompoundTag())));
        this.feHandler.ifPresent(e -> tag.m_128365_("fe", (Tag)e.serialize(new CompoundTag())));
        this.coverHandler.ifPresent(e -> tag.m_128365_("co", (Tag)e.serialize(new CompoundTag())));
        this.fluidHandler.ifPresent(e -> tag.m_128365_("fl", (Tag)e.serialize(new CompoundTag())));
        this.recipeHandler.ifPresent(e -> tag.m_128365_("re", (Tag)e.serialize()));
        this.heatHandler.ifPresent(e -> tag.m_128365_("he", (Tag)e.serialize(new CompoundTag())));
    }

    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        this.coverHandler.ifPresent(e -> tag.m_128365_("co", (Tag)e.serialize(new CompoundTag())));
        if (this.getMachineType().rendersContainedLiquids()) {
            this.fluidHandler.ifPresent(e -> tag.m_128365_("fl", (Tag)e.serialize(new CompoundTag())));
        }
        tag.m_128405_("s", this.machineState.ordinal());
        tag.m_128379_("muf", this.muffled);
        return tag;
    }

    @Override
    public List<String> getInfo(boolean simple) {
        List<String> info = super.getInfo(simple);
        if (!simple) {
            int outputs;
            int inputs;
            info.add("Machine: " + this.getMachineType().getId() + " Tier: " + this.getMachineTier().getId());
            info.add("State: " + this.getMachineState().getId());
            Object slots = "";
            if (this.getMachineType().has("item")) {
                inputs = this.getMachineType().getSlots(SlotType.IT_IN, this.getMachineTier()).size();
                outputs = this.getMachineType().getSlots(SlotType.IT_OUT, this.getMachineTier()).size();
                if (inputs > 0) {
                    slots = (String)slots + " IT_IN: " + inputs + ",";
                }
                if (outputs > 0) {
                    slots = (String)slots + " IT_OUT: " + outputs + ",";
                }
            }
            if (this.getMachineType().has("fluid") && this.getMachineType().has("gui")) {
                inputs = this.getMachineType().getSlots(SlotType.FL_IN, this.getMachineTier()).size();
                outputs = this.getMachineType().getSlots(SlotType.FL_OUT, this.getMachineTier()).size();
                if (inputs > 0) {
                    slots = (String)slots + " FL_IN: " + inputs + ",";
                }
                if (outputs > 0) {
                    slots = (String)slots + " FL_OUT: " + outputs + ",";
                }
            }
            if (((String)slots).length() > 0) {
                info.add("Slots:" + (String)slots);
            }
            if (this.type.has("fe")) {
                this.feHandler.ifPresent(h -> info.add("FE: " + h.getEnergyStored() + " / " + h.getMaxEnergyStored()));
            }
            if (this.type.has("eu")) {
                this.energyHandler.ifPresent(h -> info.add("EU: " + h.getEnergy() + " / " + h.getCapacity()));
            }
            this.recipeHandler.ifPresent(rh -> rh.getInfo(info));
        }
        this.coverHandler.ifPresent(h -> {
            if (!simple) {
                StringBuilder builder = new StringBuilder("Covers: ");
                for (Direction side : Ref.DIRS) {
                    builder.append(h.get(side).getId()).append(" ");
                }
                info.add(builder.toString());
            }
            h.getCovers().forEach((d, c) -> {
                if (!c.isEmpty()) {
                    info.addAll(c.getInfo(simple));
                }
            });
        });
        return info;
    }

    public String getId() {
        return this.getMachineType().getId();
    }

    @Override
    public Optional<ICoverHandler<T>> getCoverHandler() {
        return this.coverHandler.map(c -> c);
    }

    public boolean isOutput(Direction direction) {
        return this.energyHandler.map(e -> e.canOutput(direction)).orElse(false);
    }

    public boolean insulated() {
        return true;
    }

    public boolean connects(Direction direction) {
        BlockEntityCable cable;
        BlockEntity neighbor = this.getCachedBlockEntity(direction);
        return neighbor instanceof BlockEntityCable && (cable = (BlockEntityCable)neighbor).connects(direction.m_122424_());
    }

    public boolean validate(Direction dir) {
        return this.connects(dir);
    }

    public BlockEntity getBlockEntity() {
        return this;
    }

    public boolean isActuallyNode() {
        return true;
    }

    public void getNeighbours(Collection<IEUCable> neighbours) {
        for (Direction dir : Direction.values()) {
            BlockEntityCable cable;
            BlockEntity neigbor = this.getCachedBlockEntity(dir);
            if (!(neigbor instanceof BlockEntityCable) || !(cable = (BlockEntityCable)neigbor).connects(dir.m_122424_())) continue;
            neighbours.add(cable);
        }
    }

    public EUNetwork getNetwork() {
        return this.network;
    }

    public void setNetwork(EUNetwork network) {
        this.network = network;
    }

    @Generated
    public MachineState getMachineState() {
        return this.machineState;
    }

    @Generated
    public boolean isMuffled() {
        return this.muffled;
    }

    public static class DynamicKey {
        public final ResourceLocation model;
        public final Texture tex;
        public Direction facing;
        public final MachineState state;
        public GTLibProperties.MachineProperties properties;

        public DynamicKey(ResourceLocation model, Texture tex, Direction dir, MachineState state, GTLibProperties.MachineProperties properties) {
            this.model = model;
            this.tex = tex;
            this.facing = dir;
            this.state = state;
            this.properties = properties;
        }

        public void setDir(Direction dir) {
            this.facing = dir;
        }

        public int hashCode() {
            return this.tex.hashCode() + this.facing.hashCode() + this.state.hashCode() + this.model.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof DynamicKey) {
                DynamicKey key = (DynamicKey)o;
                return key.state == this.state && key.facing == this.facing && this.tex.equals((Object)key.tex) && this.model.equals((Object)key.model);
            }
            return false;
        }
    }
}

