/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.block;

import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.level.material.Material;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.datagen.builder.GTBlockModelBuilder;
import org.gtreimagined.gtlib.datagen.builder.VariantBlockStateBuilder;
import org.gtreimagined.gtlib.datagen.providers.GTBlockStateProvider;
import org.gtreimagined.gtlib.ore.CobbleStoneType;
import org.gtreimagined.gtlib.ore.StoneType;
import org.gtreimagined.gtlib.registration.IModelProvider;
import org.gtreimagined.gtlib.registration.ISharedGTObject;
import org.gtreimagined.gtlib.registration.ITextureProvider;
import org.gtreimagined.gtlib.texture.Texture;

public class BlockStoneStair
extends StairBlock
implements ISharedGTObject,
ITextureProvider,
IModelProvider {
    protected String domain;
    protected String id;
    protected String suffix;
    CobbleStoneType type;

    public BlockStoneStair(CobbleStoneType type, String suffix, Block baseState) {
        super(baseState.m_49966_(), BlockStoneStair.getProps(type));
        this.domain = type.getDomain();
        String s = suffix.isEmpty() ? "" : "_";
        this.id = type.getId() + s + suffix + "_stairs";
        this.suffix = suffix;
        this.type = type;
        GTAPI.register(this.getClass(), this);
    }

    private static BlockBehaviour.Properties getProps(StoneType type) {
        BlockBehaviour.Properties props = BlockBehaviour.Properties.m_60939_((Material)type.getBlockMaterial()).m_60918_(type.getSoundType()).m_60913_(type.getHardness(), type.getResistence());
        if (type.doesRequireTool()) {
            props.m_60999_();
        }
        return props;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String getSuffix() {
        return this.suffix;
    }

    @Override
    public Texture[] getTextures() {
        return new Texture[]{new Texture(this.type.getDomain(), this.type.getBeginningPath() + this.type.getId() + "/" + (this.suffix.isEmpty() ? "stone" : this.suffix))};
    }

    @Override
    public void onBlockModelBuild(Block block, GTBlockStateProvider prov) {
        Texture side;
        Texture top = side = this.getTextures()[0];
        Texture bottom = side;
        GTBlockModelBuilder outer = (GTBlockModelBuilder)((GTBlockModelBuilder)((GTBlockModelBuilder)((GTBlockModelBuilder)((GTBlockModelBuilder)prov.models().getBuilder(this.getId() + "_outer")).parent(prov.existing("minecraft", "block/outer_stairs"))).texture("bottom", bottom)).texture("top", top)).texture("side", side);
        GTBlockModelBuilder inner = (GTBlockModelBuilder)((GTBlockModelBuilder)((GTBlockModelBuilder)((GTBlockModelBuilder)((GTBlockModelBuilder)prov.models().getBuilder(this.getId() + "_inner")).parent(prov.existing("minecraft", "block/inner_stairs"))).texture("bottom", bottom)).texture("top", top)).texture("side", side);
        GTBlockModelBuilder regular = (GTBlockModelBuilder)((GTBlockModelBuilder)((GTBlockModelBuilder)((GTBlockModelBuilder)((GTBlockModelBuilder)prov.models().getBuilder(this.getId())).parent(prov.existing("minecraft", "block/stairs"))).texture("bottom", bottom)).texture("top", top)).texture("side", side);
        prov.getVariantBuilder(block).forAllStates(s -> {
            VariantBlockStateBuilder.VariantBuilder builder = new VariantBlockStateBuilder.VariantBuilder();
            GTBlockModelBuilder b = regular;
            StairsShape shape = (StairsShape)s.m_61143_((Property)f_56843_);
            Half half = (Half)s.m_61143_((Property)f_56842_);
            Direction facing = (Direction)s.m_61143_((Property)f_56841_);
            boolean left = shape.m_7912_().contains("left");
            boolean right = shape.m_7912_().contains("right");
            if (shape.m_7912_().contains("outer")) {
                b = outer;
            }
            if (shape.m_7912_().contains("inner")) {
                b = inner;
            }
            builder.modelFile(b);
            if (half == Half.TOP) {
                builder.rotationX(180);
                if (facing == Direction.EAST && right || facing == Direction.SOUTH && (shape == StairsShape.STRAIGHT || left)) {
                    builder.rotationY(90);
                }
                if (facing == Direction.SOUTH && right || facing == Direction.WEST && (left || shape == StairsShape.STRAIGHT)) {
                    builder.rotationY(180);
                }
                if (facing == Direction.WEST && right || facing == Direction.NORTH && (left || shape == StairsShape.STRAIGHT)) {
                    builder.rotationY(270);
                }
                builder.uvLock(true);
            } else {
                if (facing == Direction.SOUTH && (shape == StairsShape.STRAIGHT || right) || facing == Direction.WEST && left) {
                    builder.rotationY(90);
                }
                if (facing == Direction.NORTH && left || facing == Direction.WEST && (right || shape == StairsShape.STRAIGHT)) {
                    builder.rotationY(180);
                }
                if (facing == Direction.EAST && left || facing == Direction.NORTH && (right || shape == StairsShape.STRAIGHT)) {
                    builder.rotationY(270);
                }
                if (!(facing == Direction.EAST && (right || shape == StairsShape.STRAIGHT) || facing == Direction.SOUTH && left)) {
                    builder.uvLock(true);
                }
            }
            return builder;
        });
    }
}

