/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.util;

import com.google.common.base.CaseFormat;
import com.google.common.collect.ImmutableSet;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import it.unimi.dsi.fastutil.doubles.Double2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.awt.Color;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.advancements.critereon.EnterBlockTrigger;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.model.ModelDataManager;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.apache.commons.lang3.StringUtils;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.GTLib;
import org.gtreimagined.gtlib.GTLibConfig;
import org.gtreimagined.gtlib.Ref;
import org.gtreimagined.gtlib.data.GTLibTags;
import org.gtreimagined.gtlib.entity.IRadiationEntity;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.material.MaterialType;
import org.gtreimagined.gtlib.ore.StoneType;
import org.gtreimagined.gtlib.recipe.IRecipe;
import org.gtreimagined.gtlib.recipe.Recipe;
import org.gtreimagined.gtlib.recipe.ingredient.FluidIngredient;
import org.gtreimagined.gtlib.registration.IGTObject;
import org.gtreimagined.gtlib.tool.GTToolType;
import org.gtreimagined.gtlib.tool.IBasicGTTool;
import org.gtreimagined.gtlib.tool.IGTTool;
import org.gtreimagined.gtlib.tool.behaviour.BehaviourTreeFelling;
import org.gtreimagined.gtlib.util.int3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tesseract.api.gt.IEnergyHandler;
import tesseract.api.heat.IHeatHandler;

public class Utils {
    private static final DecimalFormat DECIMAL_FORMAT = (DecimalFormat)NumberFormat.getInstance(Locale.US);
    private static final DecimalFormatSymbols DECIMAL_SYMBOLS = DECIMAL_FORMAT.getDecimalFormatSymbols();
    private static final Direction[][] TRANSFORM;
    private static final Direction[][] TRANSFORM_INVERSE;
    static final double INTERACTION_OFFSET = 0.25;

    public static boolean equals(ItemStack a, ItemStack b) {
        return a.m_41656_(b);
    }

    public static boolean equals(FluidStack a, FluidStack b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.getFluid() == b.getFluid() && a.getTag() == b.getTag();
    }

    public static boolean contains(ItemStack a, ItemStack b) {
        return Utils.equals(a, b) && a.m_41613_() >= b.m_41613_();
    }

    public static boolean contains(FluidStack a, FluidStack b) {
        return Utils.equals(a, b) && a.getAmount() >= b.getAmount();
    }

    public static int contains(List<ItemStack> list, ItemStack item) {
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            if (!Utils.equals(list.get(i), item)) continue;
            return i;
        }
        return -1;
    }

    public static Direction dirFromState(BlockState state) {
        if (state.m_61138_((Property)BlockStateProperties.f_61372_)) {
            return (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
        }
        return (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
    }

    public static ItemStack extractAny(IItemHandler handler) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.extractItem(i, Math.min(handler.getStackInSlot(i).m_41613_(), handler.getStackInSlot(i).m_41741_()), false);
            if (stack.m_41619_()) continue;
            return stack;
        }
        return ItemStack.f_41583_;
    }

    public static int contains(List<FluidStack> list, FluidStack fluid) {
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            if (!Utils.equals(list.get(i), fluid)) continue;
            return i;
        }
        return -1;
    }

    public static List<ItemStack> mergeItems(List<ItemStack> a, List<ItemStack> b) {
        int size = b.size();
        for (ItemStack stack : b) {
            if (stack.m_41619_()) continue;
            int position = Utils.contains(a, stack);
            if (position == -1) {
                a.add(stack);
                continue;
            }
            a.get(position).m_41769_(stack.m_41613_());
        }
        return Utils.splitStacks(a);
    }

    public static void tryCondenseInventory(IItemHandlerModifiable itemHandler) {
        Utils.tryCondenseInventory(itemHandler, 0, itemHandler.getSlots());
    }

    public static void tryCondenseInventory(IItemHandlerModifiable tile, int startSlot, int endSlot) {
        for (int i = startSlot; i < endSlot; ++i) {
            for (int j = startSlot; j < endSlot; ++j) {
                if (i == j) continue;
                ItemStack stack1 = tile.getStackInSlot(i);
                ItemStack stack2 = tile.getStackInSlot(j);
                if (!stack1.m_41619_() && !stack2.m_41619_() && Utils.equals(stack1, stack2) && stack1.m_41613_() < stack1.m_41741_()) {
                    int max = stack1.m_41741_() - stack1.m_41613_();
                    int available = stack2.m_41613_();
                    int size = Mth.m_14045_((int)available, (int)1, (int)max);
                    stack1.m_41769_(size);
                    stack2.m_41774_(size);
                }
                if (!stack2.m_41619_() || stack1.m_41619_() || j >= i) continue;
                tile.setStackInSlot(j, stack1.m_41777_());
                tile.setStackInSlot(i, ItemStack.f_41583_);
            }
        }
    }

    public static List<ItemStack> splitStacks(List<ItemStack> stacks) {
        ArrayList<ItemStack> returned = new ArrayList<ItemStack>();
        for (ItemStack stack : stacks) {
            if (stack.m_41613_() > stack.m_41741_()) {
                ItemStack toAdd;
                for (int left = stack.m_41613_(); left > 0; left -= toAdd.m_41613_()) {
                    toAdd = Utils.ca(Math.min(stack.m_41741_(), left), stack);
                    returned.add(toAdd);
                }
                continue;
            }
            returned.add(stack);
        }
        return returned;
    }

    public static List<FluidStack> mergeFluids(List<FluidStack> a, List<FluidStack> b) {
        int size = b.size();
        for (FluidStack stack : b) {
            if (stack == null) continue;
            int position = Utils.contains(a, stack);
            if (position == -1) {
                a.add(stack);
                continue;
            }
            a.get(position).setAmount(a.get(position).getAmount() + stack.getAmount());
        }
        return a;
    }

    public static ItemStack ca(int amount, ItemStack toCopy) {
        ItemStack stack = toCopy.m_41777_();
        stack.m_41764_(amount);
        return stack;
    }

    public static FluidStack ca(int amount, FluidStack toCopy) {
        FluidStack stack = toCopy.copy();
        if (!stack.isEmpty()) {
            stack.setAmount(amount);
        }
        return stack;
    }

    public static void damageStack(ItemStack stack, LivingEntity player) {
        int durability = 1;
        if (stack.m_41720_() instanceof IGTTool) {
            durability = ((IGTTool)stack.m_41720_()).getGTToolType().getUseDurability();
        }
        Utils.damageStack(durability, stack, player);
    }

    public static void damageStack(ItemStack stack, InteractionHand hand, LivingEntity player) {
        int durability = 1;
        if (stack.m_41720_() instanceof IGTTool) {
            durability = ((IGTTool)stack.m_41720_()).getGTToolType().getUseDurability();
        }
        stack.m_41622_(durability, player, p -> p.m_21190_(hand));
    }

    public static void damageStack(int durability, ItemStack stack, LivingEntity player) {
        stack.m_41622_(durability, player, p -> p.m_21166_(EquipmentSlot.MAINHAND));
    }

    public static ItemStack mul(int amount, ItemStack stack) {
        return Utils.ca(stack.m_41613_() * amount, stack);
    }

    public static FluidStack mul(int amount, FluidStack stack) {
        return Utils.ca(stack.getAmount() * amount, stack);
    }

    public static boolean hasNoConsumeTag(FluidStack stack) {
        return stack.getTag() != null && stack.getTag().m_128441_("nc");
    }

    public static boolean areItemsValid(ItemStack ... items) {
        if (items == null || items.length == 0) {
            return false;
        }
        for (ItemStack item : items) {
            if (!item.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public static boolean areItemsValid(ItemStack[] ... itemArrays) {
        for (ItemStack[] itemArray : itemArrays) {
            if (Utils.areItemsValid(itemArray)) continue;
            return false;
        }
        return true;
    }

    public static boolean areFluidsValid(FluidStack ... fluids) {
        if (fluids == null || fluids.length == 0) {
            return false;
        }
        for (FluidStack fluid : fluids) {
            if (fluid.getFluid() != Fluids.f_76191_) continue;
            return false;
        }
        return true;
    }

    public static boolean areFluidsValid(FluidIngredient ... fluids) {
        if (fluids == null || fluids.length == 0) {
            return false;
        }
        for (FluidIngredient fluid : fluids) {
            if (Utils.areFluidsValid(fluid.getStacks())) continue;
            return false;
        }
        return true;
    }

    public static boolean areFluidsValid(FluidStack[] ... fluidArrays) {
        for (FluidStack[] fluidArray : fluidArrays) {
            if (Utils.areFluidsValid(fluidArray)) continue;
            return false;
        }
        return true;
    }

    public static boolean doItemsMatchAndSizeValid(ItemStack[] a, ItemStack[] b) {
        if (a == null || b == null) {
            return false;
        }
        int matchCount = 0;
        block0: for (ItemStack stack : a) {
            for (ItemStack itemStack : b) {
                if (!Utils.contains(itemStack, stack)) continue;
                ++matchCount;
                continue block0;
            }
        }
        return matchCount >= a.length;
    }

    public static boolean doItemsMatchAndSizeValid(List<Ingredient> a, ItemStack[] b) {
        if (a == null || b == null) {
            return false;
        }
        int matchCount = 0;
        block0: for (Ingredient stack : a) {
            for (ItemStack itemStack : b) {
                if (!stack.test(itemStack)) continue;
                ++matchCount;
                continue block0;
            }
        }
        return matchCount >= a.size();
    }

    public static boolean doFluidsMatchAndSizeValid(FluidStack[] a, FluidStack[] b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        int matchCount = 0;
        block0: for (FluidStack fluidStack : a) {
            for (FluidStack stack : b) {
                if (!Utils.contains(stack, fluidStack)) continue;
                ++matchCount;
                continue block0;
            }
        }
        return matchCount >= a.length;
    }

    public static boolean transferItems(IItemHandler from, IItemHandler to, boolean once) {
        return Utils.transferItems(from, to, once, stack -> true);
    }

    public static boolean transferItems(IItemHandler from, IItemHandler to, boolean once, Predicate<ItemStack> filter) {
        boolean successful = false;
        for (int i = 0; i < from.getSlots(); ++i) {
            ItemStack toInsert = from.extractItem(i, Math.min(from.getStackInSlot(i).m_41613_(), from.getStackInSlot(i).m_41741_()), true);
            if (toInsert.m_41619_() || !filter.test(toInsert)) continue;
            ItemStack inserted = Utils.insertItem(to, toInsert, true);
            if (inserted.m_41619_()) {
                Utils.insertItem(to, toInsert, false);
                from.extractItem(i, toInsert.m_41613_(), false);
                if (!successful) {
                    successful = true;
                }
                if (!once) continue;
                break;
            }
            if (inserted.m_41613_() >= toInsert.m_41613_()) continue;
            int actual = toInsert.m_41613_() - inserted.m_41613_();
            toInsert.m_41764_(toInsert.m_41613_() - inserted.m_41613_());
            Utils.insertItem(to, toInsert, false);
            from.extractItem(i, actual, false);
            if (!successful) {
                successful = true;
            }
            if (once) break;
        }
        return successful;
    }

    public static ItemStack insertItem(IItemHandler to, ItemStack stack, boolean simulate) {
        if (to == null || stack.m_41619_()) {
            return stack;
        }
        for (int i = 0; i < to.getSlots(); ++i) {
            if (!(stack = to.insertItem(i, stack, simulate)).m_41619_()) continue;
            return ItemStack.f_41583_;
        }
        return stack;
    }

    public static boolean transferEnergy(IEnergyHandler from, IEnergyHandler to) {
        boolean transferred = false;
        for (long amp = 0L; amp < from.availableAmpsOutput(); ++amp) {
            long insertEu;
            long extracted = from.extractEu(from.getOutputVoltage(), true);
            if (extracted <= 0L || (insertEu = to.insertEu(extracted, true)) <= 0L) continue;
            from.extractEu(to.insertEu(extracted, false), false);
            transferred = true;
        }
        return transferred;
    }

    public static boolean transferEnergy(IEnergyStorage from, IEnergyStorage to) {
        int inserted;
        int extracted = from.extractEnergy(Integer.MAX_VALUE, true);
        if (extracted > 0 && (inserted = to.receiveEnergy(extracted, false)) > 0) {
            from.extractEnergy(inserted, false);
            return true;
        }
        return false;
    }

    public static boolean transferHeat(IHeatHandler from, IHeatHandler to) {
        int inserted;
        int extracted = from.extract(Integer.MAX_VALUE, true);
        if (extracted > 0 && (inserted = to.insert(extracted, false)) > 0) {
            from.extract(inserted, false);
            return true;
        }
        return false;
    }

    public static boolean addEnergy(IEnergyHandler to, long eu) {
        return to.insertEu(eu, false) > 0L;
    }

    public static boolean removeEnergy(IEnergyHandler from, long eu) {
        return from.extractEu(eu, false) > 0L;
    }

    public static boolean transferEnergyWithLoss(IEnergyHandler from, IEnergyHandler to, int loss) {
        boolean transferred = false;
        for (long amp = 0L; amp < from.availableAmpsOutput(); ++amp) {
            long insertEu;
            long extracted = from.extractEu(from.getOutputVoltage(), true);
            if (extracted <= 0L || (insertEu = to.insertEu(extracted - (long)loss, true)) <= 0L) continue;
            from.extractEu(to.insertEu(extracted - (long)loss, false) + (long)loss, false);
            transferred = true;
        }
        return transferred;
    }

    public static boolean transferFluids(IFluidHandler from, IFluidHandler to, int cap, Predicate<FluidStack> filter) {
        boolean successful = false;
        for (int i = 0; i < to.getTanks(); ++i) {
            for (int j = 0; j < from.getTanks(); ++j) {
                FluidStack toInsert;
                if (cap > 0) {
                    FluidStack fluid = from.getFluidInTank(j);
                    if (fluid.isEmpty() || !filter.test(fluid)) continue;
                    fluid = fluid.copy();
                    int toDrain = Math.min(cap, fluid.getAmount());
                    fluid.setAmount(toDrain);
                    toInsert = from.drain(fluid, IFluidHandler.FluidAction.SIMULATE);
                } else {
                    toInsert = from.drain(from.getFluidInTank(j), IFluidHandler.FluidAction.SIMULATE);
                }
                int filled = to.fill(toInsert, IFluidHandler.FluidAction.SIMULATE);
                if (filled <= 0) continue;
                toInsert.setAmount(filled);
                to.fill(from.drain(toInsert, IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE);
                successful = true;
            }
        }
        return successful;
    }

    public static boolean transferFluids(IFluidHandler from, IFluidHandler to, int cap) {
        return Utils.transferFluids(from, to, cap, fluidStack -> true);
    }

    public static void entitiesAround(Level level, BlockPos pos, BiConsumer<Direction, BlockEntity> cb) {
        int3 mutPos = new int3();
        for (Direction dir : Ref.DIRS) {
            mutPos.set(pos);
            mutPos = mutPos.offset(1, dir);
            BlockEntity ent = level.m_7702_((BlockPos)mutPos);
            if (ent == null) continue;
            cb.accept(dir, ent);
        }
    }

    public static boolean applyRadioactivity(Entity aEntity, int aLevel, int aAmountOfItems) {
        if (aLevel > 0 && aEntity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)aEntity;
            if (aEntity.m_6084_() && livingEntity.m_6336_() != MobType.f_21641_ && livingEntity.m_6336_() != MobType.f_21642_ && !Utils.isFullHazmatSuit(livingEntity)) {
                IRadiationEntity radiationEntity = (IRadiationEntity)livingEntity;
                radiationEntity.changeRadiation(aLevel * aAmountOfItems);
                return true;
            }
        }
        return false;
    }

    public static boolean isFullHazmatSuit(LivingEntity livingEntity) {
        int radiationProof = 0;
        for (ItemStack stack : livingEntity.m_6168_()) {
            if (!stack.m_204117_(GTLibTags.RADIATION_PROOF)) continue;
            ++radiationProof;
        }
        return radiationProof == 4;
    }

    public static boolean transferFluids(IFluidHandler from, IFluidHandler to) {
        return Utils.transferFluids(from, to, -1);
    }

    public static EnterBlockTrigger.TriggerInstance enteredBlock(Block blockIn) {
        return new EnterBlockTrigger.TriggerInstance(EntityPredicate.Composite.f_36667_, blockIn, StatePropertiesPredicate.f_67658_);
    }

    public static InventoryChangeTrigger.TriggerInstance hasItem(ItemLike itemIn) {
        return Utils.hasItem(ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{itemIn}).m_45077_());
    }

    public static InventoryChangeTrigger.TriggerInstance hasItem(TagKey<Item> tagIn) {
        return Utils.hasItem(ItemPredicate.Builder.m_45068_().m_204145_(tagIn).m_45077_());
    }

    @SafeVarargs
    public static InventoryChangeTrigger.TriggerInstance hasItems(TagKey<Item> ... tagIn) {
        ItemPredicate[] predicates = new ItemPredicate[tagIn.length];
        for (int i = 0; i < tagIn.length; ++i) {
            TagKey<Item> tag = tagIn[i];
            predicates[i] = ItemPredicate.Builder.m_45068_().m_204145_(tag).m_45077_();
        }
        return Utils.hasItem(predicates);
    }

    public static InventoryChangeTrigger.TriggerInstance hasItem(ItemPredicate ... predicates) {
        return new InventoryChangeTrigger.TriggerInstance(EntityPredicate.Composite.f_36667_, MinMaxBounds.Ints.f_55364_, MinMaxBounds.Ints.f_55364_, MinMaxBounds.Ints.f_55364_, predicates);
    }

    public static MutableComponent translatable(String key, Object ... objects) {
        return new TranslatableComponent(key, objects);
    }

    public static MutableComponent literal(String text) {
        return new TextComponent(text);
    }

    public static String getModName(String modid) {
        return ModList.get().getModContainerById(modid).map(m -> m.getModInfo().getDisplayName()).orElse(modid);
    }

    public static int getVoltageTier(long voltage) {
        int tier = 0;
        for (int i = 0; i < Ref.V.length; ++i) {
            if (voltage > Ref.V[i]) continue;
            tier = i;
            break;
        }
        return Math.max(1, tier);
    }

    @Nullable
    public static BlockEntity getTile(@Nullable BlockGetter reader, BlockPos pos) {
        if (reader == null) {
            return null;
        }
        return reader.m_7702_(pos);
    }

    @Nullable
    public static BlockEntity getTileFromBuf(FriendlyByteBuf buf) {
        return (BlockEntity)DistExecutor.unsafeRunForDist(() -> () -> GTLib.PROXY.getClientWorld().m_7702_(buf.m_130135_()), () -> () -> {
            throw new RuntimeException("Shouldn't be called on server!");
        });
    }

    public static <T> T unsafeRunForDist(Supplier<Supplier<T>> clientTarget, Supplier<Supplier<T>> serverTarget) {
        return switch (FMLEnvironment.dist) {
            default -> throw new IncompatibleClassChangeError();
            case Dist.CLIENT -> clientTarget.get().get();
            case Dist.DEDICATED_SERVER -> serverTarget.get().get();
        };
    }

    public static void unsafeRunForDistVoid(Supplier<Runnable> clientTarget, Supplier<Runnable> serverTarget) {
        switch (FMLEnvironment.dist) {
            case CLIENT: {
                clientTarget.get().run();
                break;
            }
            case DEDICATED_SERVER: {
                serverTarget.get().run();
            }
        }
    }

    public static void markTileForNBTSync(BlockEntity tile) {
        BlockState state = tile.m_58904_().m_8055_(tile.m_58899_());
        tile.m_58904_().m_7260_(tile.m_58899_(), state, state, 3);
    }

    public static void markTileForRenderUpdate(BlockEntity tile) {
        BlockState state = tile.m_58904_().m_8055_(tile.m_58899_());
        if (tile.m_58904_().f_46443_) {
            tile.m_58904_().m_7260_(tile.m_58899_(), state, state, 11);
            ModelDataManager.requestModelDataRefresh((BlockEntity)tile);
        }
    }

    public static Direction rotate(Direction facing, Direction side) {
        return TRANSFORM[facing.m_122411_()][side.m_122411_()];
    }

    public static Direction rotateInverse(Direction facing, Direction side) {
        return TRANSFORM_INVERSE[facing.m_122411_()][side.m_122411_()];
    }

    public static Direction coverRotateFacing(Direction toRotate, Direction rotateBy) {
        Quaternion rot = null;
        switch (rotateBy.m_122434_()) {
            case Z: 
            case X: {
                rot = new Quaternion(Vector3f.f_122225_, rotateBy.m_122435_(), true);
                break;
            }
            case Y: {
                rot = new Quaternion(Vector3f.f_122223_, -90.0f * (float)rotateBy.m_122436_().m_123342_(), true);
            }
        }
        Vec3i vector3i = toRotate.m_122436_();
        Vector4f vector4f = new Vector4f((float)vector3i.m_123341_(), (float)vector3i.m_123342_(), (float)vector3i.m_123343_(), 0.0f);
        vector4f.m_123607_(new Matrix4f(rot));
        return Direction.m_122372_((float)vector4f.m_123601_(), (float)vector4f.m_123615_(), (float)vector4f.m_123616_());
    }

    public static Direction getOffsetFacing(BlockPos center, BlockPos offset) {
        if (center.m_123341_() == offset.m_123341_() + 1) {
            return Direction.WEST;
        }
        if (center.m_123341_() + 1 == offset.m_123341_()) {
            return Direction.EAST;
        }
        if (center.m_123343_() == offset.m_123343_() + 1) {
            return Direction.NORTH;
        }
        if (center.m_123343_() + 1 == offset.m_123343_()) {
            return Direction.SOUTH;
        }
        if (center.m_123342_() == offset.m_123342_() + 1) {
            return Direction.DOWN;
        }
        if (center.m_123342_() + 1 == offset.m_123342_()) {
            return Direction.UP;
        }
        return null;
    }

    public static Direction getInteractSide(BlockHitResult res) {
        Vec3 vec = res.m_82450_();
        return Utils.getInteractSide(res.m_82434_(), (float)vec.f_82479_ - (float)res.m_82425_().m_123341_(), (float)vec.f_82480_ - (float)res.m_82425_().m_123342_(), (float)vec.f_82481_ - (float)res.m_82425_().m_123343_());
    }

    public static Direction getInteractSide(Direction side, float x, float y, float z) {
        Direction backSide = side.m_122424_();
        switch (side.m_122411_()) {
            case 0: 
            case 1: {
                if ((double)x < 0.25) {
                    if ((double)z < 0.25) {
                        return backSide;
                    }
                    if ((double)z > 0.75) {
                        return backSide;
                    }
                    return Direction.WEST;
                }
                if ((double)x > 0.75) {
                    if ((double)z < 0.25) {
                        return backSide;
                    }
                    if ((double)z > 0.75) {
                        return backSide;
                    }
                    return Direction.EAST;
                }
                if ((double)z < 0.25) {
                    return Direction.NORTH;
                }
                if ((double)z > 0.75) {
                    return Direction.SOUTH;
                }
                return side;
            }
            case 2: 
            case 3: {
                if ((double)x < 0.25) {
                    if ((double)y < 0.25) {
                        return backSide;
                    }
                    if ((double)y > 0.75) {
                        return backSide;
                    }
                    return Direction.WEST;
                }
                if ((double)x > 0.75) {
                    if ((double)y < 0.25) {
                        return backSide;
                    }
                    if ((double)y > 0.75) {
                        return backSide;
                    }
                    return Direction.EAST;
                }
                if ((double)y < 0.25) {
                    return Direction.DOWN;
                }
                if ((double)y > 0.75) {
                    return Direction.UP;
                }
                return side;
            }
            case 4: 
            case 5: {
                if ((double)z < 0.25) {
                    if ((double)y < 0.25) {
                        return backSide;
                    }
                    if ((double)y > 0.75) {
                        return backSide;
                    }
                    return Direction.NORTH;
                }
                if ((double)z > 0.75) {
                    if ((double)y < 0.25) {
                        return backSide;
                    }
                    if ((double)y > 0.75) {
                        return backSide;
                    }
                    return Direction.SOUTH;
                }
                if ((double)y < 0.25) {
                    return Direction.DOWN;
                }
                if ((double)y > 0.75) {
                    return Direction.UP;
                }
                return side;
            }
        }
        return side;
    }

    public static Set<BlockPos> getCubicPosArea(int3 area, Direction side, BlockPos origin, Player player, boolean excludeAir) {
        int zRadius;
        int yRadius;
        int xRadius;
        BlockPos center;
        if (side == null) {
            center = origin;
            xRadius = area.m_123341_();
            yRadius = area.m_123342_();
            zRadius = area.m_123343_();
        } else {
            center = origin.m_5484_(side.m_122424_(), area.m_123343_());
            if (side.m_122434_() == Direction.Axis.Y) {
                xRadius = player.m_6350_().m_122434_() == Direction.Axis.X ? area.m_123342_() : area.m_123341_();
                yRadius = area.m_123343_();
                zRadius = player.m_6350_().m_122434_() == Direction.Axis.Z ? area.m_123342_() : area.m_123341_();
            } else {
                xRadius = player.m_6350_().m_122434_() == Direction.Axis.X ? area.m_123343_() : area.m_123341_();
                yRadius = area.m_123342_();
                zRadius = player.m_6350_().m_122434_() == Direction.Axis.Z ? area.m_123343_() : area.m_123341_();
            }
        }
        ObjectOpenHashSet set = new ObjectOpenHashSet();
        for (int x = center.m_123341_() - xRadius; x <= center.m_123341_() + xRadius; ++x) {
            for (int y = center.m_123342_() - yRadius; y <= center.m_123342_() + yRadius; ++y) {
                for (int z = center.m_123343_() - zRadius; z <= center.m_123343_() + zRadius; ++z) {
                    BlockState state;
                    BlockPos harvestPos = new BlockPos(x, y, z);
                    if (harvestPos.equals((Object)origin) || excludeAir && (state = player.f_19853_.m_8055_(harvestPos)).m_60795_()) continue;
                    set.add(new BlockPos(x, y, z));
                }
            }
        }
        return set;
    }

    public static void createExplosion(@Nullable Level world, BlockPos pos, float explosionRadius, Explosion.BlockInteraction modeIn) {
        if (world != null) {
            if (!world.f_46443_) {
                world.m_46511_(null, (double)pos.m_123341_(), (double)pos.m_123342_() + 0.0625, (double)pos.m_123343_(), explosionRadius, modeIn);
            } else {
                world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)pos.m_123341_(), (double)pos.m_123342_() + 0.5, (double)pos.m_123343_(), 0.0, 0.0, 0.0);
            }
            if (modeIn != Explosion.BlockInteraction.NONE) {
                world.m_46597_(pos, Blocks.f_50016_.m_49966_());
            }
        }
    }

    public static void createFireAround(@Nullable Level world, BlockPos pos) {
        if (world != null) {
            boolean fired = false;
            for (Direction side : Ref.DIRS) {
                BlockPos offset = pos.m_142300_(side);
                if (world.m_8055_(offset) != Blocks.f_50016_.m_49966_()) continue;
                world.m_46597_(offset, Blocks.f_50083_.m_49966_());
                fired = true;
            }
            if (!fired) {
                world.m_46597_(pos, Blocks.f_50083_.m_49966_());
            }
        }
    }

    public static boolean breakBlock(Level world, @Nullable Player player, ItemStack stack, BlockPos pos, int damage) {
        if (world.f_46443_) {
            return false;
        }
        BlockState state = world.m_8055_(pos);
        ServerPlayer serverPlayer = player == null ? null : (ServerPlayer)player;
        int exp = player == null ? -1 : ForgeHooks.onBlockBreakEvent((Level)world, (GameType)serverPlayer.f_8941_.m_9290_(), (ServerPlayer)serverPlayer, (BlockPos)pos);
        FluidState fluidState = world.m_6425_(pos);
        boolean destroyed = world.m_46597_(pos, fluidState.m_76188_());
        if (destroyed && player != null) {
            if (state.canHarvestBlock((BlockGetter)world, pos, player)) {
                state.m_60734_().m_6240_(world, player, pos, state, world.m_7702_(pos), stack);
            }
            stack.m_41622_(state.m_60800_((BlockGetter)world, pos) != 0.0f ? damage : 0, (LivingEntity)player, onBroken -> onBroken.m_21166_(EquipmentSlot.MAINHAND));
        }
        if (exp > 0) {
            state.m_60734_().m_49805_((ServerLevel)world, pos, exp);
        }
        return destroyed;
    }

    public static boolean treeLogging(@NotNull GTToolType tool, @NotNull ItemStack stack, @NotNull BlockPos start, @NotNull Player player, @NotNull Level world) {
        boolean[] harvested = new boolean[1];
        if (!GTLibConfig.SMARTER_TREE_DETECTION.get()) {
            BlockPos tempPos;
            BlockState state;
            BlockState tpCompare = world.m_8055_(start);
            if (!BehaviourTreeFelling.isLog(tpCompare)) {
                return false;
            }
            for (int y = start.m_123342_() + 1; y < start.m_123342_() + world.m_141928_() && !stack.m_41619_() && (state = world.m_8055_(tempPos = new BlockPos(start.m_123341_(), y, start.m_123343_()))).m_204336_(BlockTags.f_13106_) && Utils.breakBlock(world, player, stack, tempPos, tool.getUseDurability()); ++y) {
                harvested[0] = true;
            }
        } else {
            boolean[] stopped = new boolean[1];
            BehaviourTreeFelling.findTree((BlockGetter)world, start).getLogs().forEach(b -> {
                if (stack.m_41619_()) {
                    return;
                }
                if (stopped[0]) {
                    return;
                }
                BlockState state = world.m_8055_(b);
                if (state.m_60795_() || !ForgeHooks.isCorrectToolForDrops((BlockState)state, (Player)player)) {
                    return;
                }
                if (state.m_204336_(BlockTags.f_13106_)) {
                    if (Utils.breakBlock(world, player, stack, b, tool.getUseDurability())) {
                        harvested[0] = true;
                    } else {
                        stopped[0] = true;
                    }
                }
            });
        }
        return harvested[0];
    }

    public static ImmutableSet<BlockPos> getHarvestableBlocksToBreak(@NotNull Level world, @NotNull Player player, @NotNull IBasicGTTool tool, ItemStack stack, int column, int row, int depth) {
        ImmutableSet<BlockPos> totalBlocks = Utils.getBlocksToBreak(world, player, column, row, depth);
        return (ImmutableSet)totalBlocks.stream().filter(b -> tool.genericIsCorrectToolForDrops(stack, world.m_8055_(b)) && world.m_8055_(b).m_60800_((BlockGetter)world, b) >= 0.0f).collect(ImmutableSet.toImmutableSet());
    }

    public static ImmutableSet<BlockPos> getBlocksToBreak(@NotNull Level world, @NotNull Player player, int column, int row, int depth) {
        Vec3 lookPos = player.m_20299_(1.0f);
        Vec3 rotation = player.m_20252_(1.0f);
        Vec3 realLookPos = lookPos.m_82520_(rotation.f_82479_ * 5.0, rotation.f_82480_ * 5.0, rotation.f_82481_ * 5.0);
        BlockHitResult result = world.m_45547_(new ClipContext(lookPos, realLookPos, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
        Direction playerDirection = player.m_6350_();
        Direction.Axis playerAxis = playerDirection.m_122434_();
        Direction.Axis faceAxis = result.m_82434_().m_122434_();
        Direction.AxisDirection faceAxisDir = result.m_82434_().m_122421_();
        ImmutableSet.Builder blockPositions = ImmutableSet.builder();
        if (faceAxis.m_122478_()) {
            boolean isX = playerAxis == Direction.Axis.X;
            boolean isDown = faceAxisDir == Direction.AxisDirection.NEGATIVE;
            for (int y = 0; y < depth; ++y) {
                for (int x = isX ? -column : -row; x <= (isX ? column : row); ++x) {
                    for (int z = isX ? -row : -column; z <= (isX ? row : column); ++z) {
                        if (x == 0 && y == 0 && z == 0) continue;
                        blockPositions.add((Object)result.m_82425_().m_142082_(x, isDown ? y : -y, z));
                    }
                }
            }
        } else {
            boolean isX = faceAxis == Direction.Axis.X;
            boolean isNegative = faceAxisDir == Direction.AxisDirection.NEGATIVE;
            for (int x = 0; x < depth; ++x) {
                for (int y = -column; y <= column; ++y) {
                    for (int z = -row; z <= row; ++z) {
                        if (x == 0 && y == 0 && z == 0) continue;
                        blockPositions.add((Object)result.m_82425_().m_142082_(isX ? (isNegative ? x : -x) : (isNegative ? z : -z), y, isX ? (isNegative ? z : -z) : (isNegative ? x : -x)));
                    }
                }
            }
        }
        return blockPositions.build();
    }

    public static DyeColor determineColour(int rgb) {
        Color colour = new Color(rgb);
        Double2ObjectOpenHashMap distances = new Double2ObjectOpenHashMap();
        for (DyeColor dyeColour : DyeColor.values()) {
            Color enumColour = new Color(dyeColour.m_41069_().f_76396_);
            double distance = (colour.getRed() - enumColour.getRed()) * (colour.getRed() - enumColour.getRed()) + (colour.getGreen() - enumColour.getGreen()) * (colour.getGreen() - enumColour.getGreen()) + (colour.getBlue() - enumColour.getBlue()) * (colour.getBlue() - enumColour.getBlue());
            distances.put(distance, (Object)dyeColour);
        }
        return (DyeColor)distances.get(((Double)Collections.min(distances.keySet())).doubleValue());
    }

    public static String lowerUnderscoreToUpperSpaced(String string) {
        String[] split = StringUtils.split((String)string, (String)"_");
        Object[] split2 = new String[split.length];
        for (int i = 0; i < split.length; ++i) {
            String str = split[i];
            if (str.isEmpty() || !Character.isDigit(str.charAt(0))) {
                str = Utils.underscoreToUpperCamel(str);
            }
            split2[i] = str;
        }
        return StringUtils.join((Object[])split2, (char)' ');
    }

    public static String lowerUnderscoreToUpperSpacedRotated(String string) {
        String[] strings = StringUtils.splitByCharacterTypeCamelCase((String)CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, string));
        Object[] newStrings = new String[strings.length];
        newStrings[0] = strings[strings.length - 1];
        for (int i = 1; i < strings.length; ++i) {
            newStrings[i] = strings[i - 1];
        }
        return StringUtils.join((Object[])newStrings, (char)' ');
    }

    public static String lowerUnderscoreToUpperSpacedReversed(String string) {
        String[] strings = StringUtils.splitByCharacterTypeCamelCase((String)CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, string));
        Object[] newStrings = new String[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            newStrings[i] = strings[strings.length - 1 - i];
        }
        return StringUtils.join((Object[])newStrings, (char)' ');
    }

    public static String lowerUnderscoreToUpperSpaced(String string, int offset) {
        String[] strings = StringUtils.splitByCharacterTypeCamelCase((String)CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, string));
        assert (offset > strings.length);
        return StringUtils.join((Object[])Arrays.copyOfRange(strings, offset, strings.length), (char)' ');
    }

    public static String underscoreToUpperCamel(String string) {
        return CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, string);
    }

    public static String digitsToSubscript(String string) {
        if (string.length() == 0) {
            return "";
        }
        char[] chars = string.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            int index = chars[i] - 48;
            if (index < 0 || index > 9) continue;
            int newChar = 8320 + index;
            chars[i] = (char)newChar;
        }
        return new String(chars);
    }

    public static String getConventionalStoneType(StoneType type) {
        String string = type.getId();
        return string;
    }

    public static String getConventionalMaterialType(MaterialType<?> type) {
        if (type.getId().equals("raw_ore")) {
            return "raw_materials";
        }
        if (type.getId().equals("raw_ore_block") || type.getId().equals("block")) {
            return "storage_blocks";
        }
        if (type.getId().equals("ore_stone")) {
            return "ore_stones";
        }
        String id = type.getId();
        int index = id.indexOf("_");
        if (index != -1 && type.isSplitName()) {
            if ((id = String.join((CharSequence)"", id.substring(index + 1), "_", id.substring(0, index), "s")).contains("crushed")) {
                id = StringUtils.replace((String)id, (String)"crushed", (String)"ore");
            }
            return id;
        }
        if (id.equals("crushed")) {
            return StringUtils.replace((String)id, (String)"crushed", (String)"crushed_ores");
        }
        return id.charAt(id.length() - 1) == 's' ? id.concat("es") : id.concat("s");
    }

    public static void dropItemInWorldAtTile(BlockEntity tile, Item item, Direction dir) {
        ItemEntity entity = new ItemEntity(tile.m_58904_(), (double)(tile.m_58899_().m_123341_() + dir.m_122429_()), (double)(tile.m_58899_().m_123342_() + dir.m_122430_()), (double)(tile.m_58899_().m_123343_() + dir.m_122431_()), new ItemStack((ItemLike)item, 1));
        tile.m_58904_().m_7967_((Entity)entity);
    }

    public static String[] getLocalizedMaterialType(MaterialType<?> type) {
        String id = type.getId();
        int index = id.indexOf("_");
        if (index != -1 && type.isSplitName()) {
            String joined = String.join((CharSequence)"", id.substring(index + 1), "_", id.substring(0, index));
            return Utils.lowerUnderscoreToUpperSpaced(joined).split(" ");
        }
        return new String[]{Utils.lowerUnderscoreToUpperSpaced(id).replace('_', ' ')};
    }

    public static String getLocalizedType(IGTObject type) {
        String id = type.getId();
        if (type instanceof Material) {
            Material material = (Material)type;
            return material.getDisplayNameString();
        }
        int index = id.indexOf("_");
        if (index != -1) {
            if (type instanceof MaterialType) {
                MaterialType matType = (MaterialType)type;
                return StringUtils.join((Object[])Utils.getLocalizedMaterialType(matType));
            }
            return StringUtils.replaceChars((String)Utils.lowerUnderscoreToUpperSpaced(id), (char)'_', (char)' ');
        }
        return StringUtils.capitalize((String)id);
    }

    public static String getLocalizeStoneType(StoneType type) {
        return Utils.getLocalizedType(type);
    }

    public static boolean doesStackHaveToolTypes(ItemStack stack, TagKey<Item> ... types) {
        if (!stack.m_41619_()) {
            for (TagKey<Item> type : types) {
                if (!stack.m_41720_().m_204114_().m_203656_(type)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean doesStackHaveToolTypes(ItemStack stack, GTToolType ... types) {
        ObjectArrayList ret = new ObjectArrayList();
        for (GTToolType ty : types) {
            ret.add(ty.getForgeTag());
        }
        TagKey[] t = ret.toArray(new TagKey[0]);
        return Utils.doesStackHaveToolTypes(stack, t);
    }

    public static boolean isPlayerHolding(Player player, InteractionHand hand, GTToolType ... t) {
        return Utils.doesStackHaveToolTypes(player.m_21120_(hand), t);
    }

    @Nullable
    public static GTToolType getToolType(Player player) {
        ItemStack stack = player.m_21205_();
        for (GTToolType ty : GTAPI.all(GTToolType.class)) {
            if (!ty.hasOriginalTag() || !stack.m_204117_(ty.getTag())) continue;
            return ty;
        }
        return null;
    }

    public static IRecipe getEmptyRecipe() {
        return new Recipe(Collections.emptyList(), new ItemStack[0], Collections.emptyList(), new FluidStack[0], 1, 1L, 0, 1);
    }

    public static void onInvalidData(String msg) {
        if (Ref.DATA_EXCEPTIONS) {
            throw new IllegalStateException(msg);
        }
        GTLib.LOGGER.error(msg);
    }

    public static void printError(String msg) {
        GTLib.LOGGER.error("====================================================");
        GTLib.LOGGER.error(msg);
        GTLib.LOGGER.error("====================================================");
    }

    public static <T> T cast(Object o) {
        return (T)o;
    }

    static {
        DECIMAL_SYMBOLS.setGroupingSeparator(' ');
        TRANSFORM = new Direction[][]{{Direction.SOUTH, Direction.NORTH, Direction.DOWN, Direction.UP, Direction.WEST, Direction.EAST}, {Direction.NORTH, Direction.SOUTH, Direction.UP, Direction.DOWN, Direction.WEST, Direction.EAST}, {Direction.DOWN, Direction.UP, Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST}, {Direction.DOWN, Direction.UP, Direction.SOUTH, Direction.NORTH, Direction.EAST, Direction.WEST}, {Direction.DOWN, Direction.UP, Direction.WEST, Direction.EAST, Direction.SOUTH, Direction.NORTH}, {Direction.DOWN, Direction.UP, Direction.EAST, Direction.WEST, Direction.NORTH, Direction.SOUTH}};
        TRANSFORM_INVERSE = new Direction[][]{{Direction.NORTH, Direction.SOUTH, Direction.UP, Direction.DOWN, Direction.WEST, Direction.EAST}, {Direction.SOUTH, Direction.NORTH, Direction.DOWN, Direction.UP, Direction.WEST, Direction.EAST}, {Direction.DOWN, Direction.UP, Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST}, {Direction.DOWN, Direction.UP, Direction.SOUTH, Direction.NORTH, Direction.EAST, Direction.WEST}, {Direction.DOWN, Direction.UP, Direction.EAST, Direction.WEST, Direction.NORTH, Direction.SOUTH}, {Direction.DOWN, Direction.UP, Direction.WEST, Direction.EAST, Direction.SOUTH, Direction.NORTH}};
    }
}

