/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.tool.behaviour;

import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.event.ForgeEventFactory;
import org.gtreimagined.gtlib.behaviour.IItemUse;
import org.gtreimagined.gtlib.tool.IBasicGTTool;
import org.gtreimagined.gtlib.util.Utils;

public class BehaviourVanillaShovel
implements IItemUse<IBasicGTTool> {
    public static final BehaviourVanillaShovel INSTANCE = new BehaviourVanillaShovel();
    private static final Object2ObjectOpenHashMap<Block, Block> FLATTENING_MAP = new Object2ObjectOpenHashMap();

    @Override
    public String getId() {
        return "vanilla_shovel";
    }

    @Override
    public InteractionResult onItemUse(IBasicGTTool instance, UseOnContext c) {
        if (c.m_43719_() == Direction.DOWN) {
            return InteractionResult.PASS;
        }
        BlockState state = c.m_43725_().m_8055_(c.m_8083_());
        BlockState changedState = null;
        if (state.m_60734_() instanceof CampfireBlock) {
            if (((Boolean)state.m_61143_((Property)CampfireBlock.f_51227_)).booleanValue() && (changedState = this.getFireModifiedState(state, (BlockState)state.m_61124_((Property)CampfireBlock.f_51227_, (Comparable)Boolean.valueOf(false)), c, "shovel_dig")) != null) {
                c.m_43725_().m_5898_(c.m_43723_(), 1009, c.m_8083_(), 0);
            }
        } else if (state != null && (changedState = this.getToolModifiedState(state, c, "shovel_flatten")) != null) {
            SoundEvent soundEvent = instance.getGTToolType().getUseSound() == null ? SoundEvents.f_12406_ : instance.getGTToolType().getUseSound();
            c.m_43725_().m_5594_(c.m_43723_(), c.m_8083_(), soundEvent, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        if (changedState != null) {
            c.m_43725_().m_7731_(c.m_8083_(), changedState, 11);
            Utils.damageStack(c.m_43722_(), (LivingEntity)c.m_43723_());
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private BlockState getToolModifiedState(BlockState originalState, UseOnContext context, String action) {
        BlockState eventState = ForgeEventFactory.onToolUse((BlockState)originalState, (UseOnContext)context, (ToolAction)ToolAction.get((String)action), (boolean)false);
        if (eventState != originalState) {
            return eventState;
        }
        Block flattened = (Block)FLATTENING_MAP.get((Object)originalState.m_60734_());
        if (flattened == null) {
            return null;
        }
        BlockState state = flattened.m_49966_();
        for (Property property : originalState.m_61147_()) {
            if (!state.m_61138_(property)) continue;
            state = (BlockState)state.m_61124_(property, originalState.m_61143_(property));
        }
        return state;
    }

    private BlockState getFireModifiedState(BlockState originalState, BlockState changedState, UseOnContext context, String action) {
        BlockState eventState = ForgeEventFactory.onToolUse((BlockState)originalState, (UseOnContext)context, (ToolAction)ToolAction.get((String)action), (boolean)false);
        return eventState != originalState ? eventState : changedState;
    }

    public static void addStrippedBlock(Block from, Block to) {
        FLATTENING_MAP.put((Object)from, (Object)to);
    }

    static {
        new ImmutableMap.Builder().put((Object)Blocks.f_50440_, (Object)Blocks.f_152481_).put((Object)Blocks.f_50683_, (Object)Blocks.f_50683_).put((Object)Blocks.f_50684_, (Object)Blocks.f_50684_).build().forEach(BehaviourVanillaShovel::addStrippedBlock);
    }
}

