/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.tool;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Streams;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.DigDurabilityEnchantment;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.gtreimagined.gtlib.Data;
import org.gtreimagined.gtlib.Ref;
import org.gtreimagined.gtlib.capability.energy.ItemEnergyHandler;
import org.gtreimagined.gtlib.datagen.providers.GTItemModelProvider;
import org.gtreimagined.gtlib.integration.curios.CuriosHelper;
import org.gtreimagined.gtlib.item.ICustomDurability;
import org.gtreimagined.gtlib.item.ItemBattery;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.material.MaterialTags;
import org.gtreimagined.gtlib.registration.IGTObject;
import org.gtreimagined.gtlib.texture.Texture;
import org.gtreimagined.gtlib.tool.GTItemTier;
import org.gtreimagined.gtlib.tool.GTToolType;
import org.gtreimagined.gtlib.tool.IBasicGTTool;
import org.gtreimagined.gtlib.util.Utils;
import org.jetbrains.annotations.Nullable;
import tesseract.api.context.TesseractItemContext;
import tesseract.api.forge.TesseractCaps;
import tesseract.api.gt.IEnergyHandlerItem;
import tesseract.api.gt.IEnergyItem;

public interface IGTTool
extends IGTObject,
IBasicGTTool,
IEnergyItem,
ICustomDurability {
    public GTItemTier getGTItemTier();

    @Override
    default public Tier getItemTier() {
        return this.getGTItemTier();
    }

    @Override
    default public String getTextureDomain() {
        return "gtlib";
    }

    default public Material getPrimaryMaterial(ItemStack stack) {
        if (this.getGTToolType().isSimple()) {
            return this.getGTItemTier().getPrimary();
        }
        return Material.get(this.getOrCreateDataTag(stack).m_128461_("m"));
    }

    default public Material getSecondaryMaterial(ItemStack stack) {
        if (this.getGTToolType().isSimple()) {
            return this.getGTItemTier().getSecondary();
        }
        return Material.get(this.getOrCreateDataTag(stack).m_128461_("sm"));
    }

    default public DyeColor getDyeColor(ItemStack stack) {
        CompoundTag data = this.getOrCreateDataTag(stack);
        if (data.m_128441_("sc")) {
            Optional<DyeColor> color = Arrays.stream(DyeColor.values()).filter(t -> t.m_41069_().f_76396_ == data.m_128451_("sc")).findFirst();
            return color.orElse(DyeColor.WHITE);
        }
        return null;
    }

    default public int getPoweredBarColor(ItemStack stack) {
        return 49151;
    }

    default public int getPoweredBarWidth(ItemStack stack) {
        long currentEnergy = this.getCurrentEnergy(stack);
        if (currentEnergy > 0L) {
            double maxAmount = this.getMaxEnergy(stack);
            return (int)(13.0 * ((double)currentEnergy / maxAmount));
        }
        return 0;
    }

    default public boolean isPoweredBarVisible(ItemStack stack) {
        return this.getCurrentEnergy(stack) > 0L;
    }

    default public Material[] getMaterials(ItemStack stack) {
        return new Material[]{this.getPrimaryMaterial(stack), this.getSecondaryMaterial(stack)};
    }

    default public int getSubColour(ItemStack stack) {
        return this.getDyeColor(stack) == null ? 0 : this.getDyeColor((ItemStack)stack).m_41069_().f_76396_;
    }

    default public long getCurrentEnergy(ItemStack stack) {
        return this.getEnergyTag(stack).m_128454_("e");
    }

    default public long getMaxEnergy(ItemStack stack) {
        return this.getEnergyTag(stack).m_128454_("me");
    }

    default public boolean canCreate(TesseractItemContext context) {
        return this.getGTToolType().isPowered();
    }

    public ItemStack asItemStack(Material var1, Material var2);

    public int getEnergyTier();

    default public CompoundTag getEnergyTag(ItemStack stack) {
        CompoundTag dataTag = stack.m_41737_("ied");
        return dataTag != null ? dataTag : this.validateEnergyTag(stack, 0L, 10000L);
    }

    @Override
    default public CompoundTag getOrCreateDataTag(ItemStack stack) {
        CompoundTag dataTag = stack.m_41737_("td");
        return dataTag != null ? dataTag : this.validateTag(stack, this.getGTItemTier().getPrimary(), this.getGTItemTier().getSecondary(), 0L, 10000L);
    }

    @Override
    default public Tier getTier(ItemStack stack) {
        if (this.getGTToolType().isSimple()) {
            return this.getGTItemTier();
        }
        CompoundTag dataTag = this.getOrCreateDataTag(stack);
        Optional<GTItemTier> tier = GTItemTier.get(dataTag.m_128451_("t"));
        return tier.orElseGet(() -> this.resolveTierTag(dataTag));
    }

    default public ItemStack resolveStack(Material primary, Material secondary, long startingEnergy, long maxEnergy) {
        Item item = this.getItem();
        ItemStack stack = new ItemStack((ItemLike)item);
        if (!this.getGTToolType().isSimple() || this.getGTToolType().isPowered()) {
            this.validateTag(stack, primary, secondary, startingEnergy, maxEnergy);
        }
        if (!primary.has(MaterialTags.TOOLS)) {
            return stack;
        }
        ImmutableMap<Enchantment, Integer> mainEnchants = MaterialTags.TOOLS.get(primary).toolEnchantment();
        if (!mainEnchants.isEmpty()) {
            mainEnchants.entrySet().stream().filter(e -> ((Enchantment)e.getKey()).m_6081_(stack)).forEach(e -> stack.m_41663_((Enchantment)e.getKey(), ((Integer)e.getValue()).intValue()));
        }
        return stack;
    }

    default public CompoundTag validateTag(ItemStack stack, Material primary, Material secondary, long startingEnergy, long maxEnergy) {
        CompoundTag dataTag = stack.m_41698_("td");
        if (!this.getGTToolType().isSimple()) {
            dataTag.m_128359_("m", primary.getId());
            dataTag.m_128359_("sm", secondary.getId());
        }
        if (!this.getGTToolType().isPowered()) {
            return dataTag;
        }
        this.validateEnergyTag(stack, startingEnergy, maxEnergy);
        return dataTag;
    }

    default public CompoundTag validateEnergyTag(ItemStack stack, long startingEnergy, long maxEnergy) {
        IEnergyHandlerItem h = stack.getCapability(TesseractCaps.ENERGY_HANDLER_CAPABILITY_ITEM).resolve().orElse(null);
        if (h != null) {
            h.setEnergy(startingEnergy);
            h.setCapacity(maxEnergy);
            stack.m_41751_(h.getContainer().getTag());
        }
        return stack.m_41698_("ied");
    }

    default public GTItemTier resolveTierTag(CompoundTag dataTag) {
        GTItemTier tier = GTItemTier.getOrCreate(dataTag.m_128461_("m"), dataTag.m_128461_("sm"));
        dataTag.m_128405_("t", tier.hashCode());
        return tier;
    }

    default public void onGenericFillItemGroup(CreativeModeTab group, NonNullList<ItemStack> list, long maxEnergy) {
        if (group != Ref.TAB_TOOLS) {
            return;
        }
        if (this.getGTToolType().isPowered()) {
            ItemStack stack = this.asItemStack(Material.NULL, Material.NULL);
            IEnergyHandlerItem h = stack.getCapability(TesseractCaps.ENERGY_HANDLER_CAPABILITY_ITEM).resolve().orElse(null);
            if (h != null) {
                list.add((Object)stack.m_41777_());
                h.setCapacity(maxEnergy);
                h.setEnergy(maxEnergy);
                stack.m_41751_(h.getContainer().getTag());
                list.add((Object)stack);
            }
        } else {
            list.add((Object)this.asItemStack(this.getGTItemTier().getPrimary(), this.getGTItemTier().getSecondary()));
        }
    }

    @Override
    default public void onGenericAddInformation(ItemStack stack, List<Component> tooltip, TooltipFlag flag) {
        DyeColor color;
        Material primary = this.getPrimaryMaterial(stack);
        Material secondary = this.getSecondaryMaterial(stack);
        if (!this.getGTToolType().isSimple()) {
            tooltip.add((Component)Utils.translatable("gtlib.tooltip.material_primary", primary.getDisplayName().getString()));
        }
        if (secondary != Material.NULL) {
            tooltip.add((Component)Utils.translatable("gtlib.tooltip.material_secondary", secondary.getDisplayName().getString()));
        }
        if ((color = this.getDyeColor(stack)) != null) {
            tooltip.add((Component)Utils.translatable("gtlib.tooltip.dye_color", color.m_41065_()));
        }
        if (flag.m_7050_() && this.getGTToolType().isPowered()) {
            tooltip.add((Component)Utils.translatable("gtlib.tooltip.energy", new Object[0]).m_130946_(": " + this.getCurrentEnergy(stack) + " / " + this.getMaxEnergy(stack)));
        }
        tooltip.add((Component)Utils.translatable("gtlib.tooltip.durability", Utils.literal(stack.m_41776_() - stack.m_41773_() + "/" + stack.m_41776_()).m_130940_(ChatFormatting.GREEN)));
        IBasicGTTool.super.onGenericAddInformation(stack, tooltip, flag);
    }

    @Override
    default public void refillTool(ItemStack stack, Player player) {
        if (this.getGTToolType().isPowered()) {
            Streams.concat((Stream[])new Stream[]{player.m_150109_().f_35974_.stream(), player.m_150109_().f_35976_.stream(), CuriosHelper.getCuriosItems(player, "belt", "back")}).forEach(s -> {
                ItemBattery battery;
                Item patt9996$temp;
                if (this.getCurrentEnergy(stack) < this.getMaxEnergy(stack) && (patt9996$temp = s.m_41720_()) instanceof ItemBattery && (battery = (ItemBattery)patt9996$temp).getTier().getIntegerId() >= this.getEnergyTier()) {
                    long inserted;
                    long extracted;
                    IEnergyHandlerItem batteryHandler = s.getCapability(TesseractCaps.ENERGY_HANDLER_CAPABILITY_ITEM).resolve().orElse(null);
                    IEnergyHandlerItem toolHandler = stack.getCapability(TesseractCaps.ENERGY_HANDLER_CAPABILITY_ITEM).resolve().orElse(null);
                    if (batteryHandler != null && toolHandler != null && (extracted = batteryHandler.extractEu(battery.getCapacity(), true)) > 0L && (inserted = toolHandler.insertEu(extracted, true)) > 0L) {
                        toolHandler.insertEu(batteryHandler.extractEu(inserted, false), false);
                    }
                }
            });
        }
    }

    default public ItemStack getGenericContainerItem(ItemStack oldStack) {
        ItemStack stack = oldStack.m_41777_();
        int amount = this.damage(stack, this.getGTToolType().getCraftingDurability());
        if (!this.getGTToolType().isPowered()) {
            int level = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44986_, (ItemStack)stack);
            int j = 0;
            for (int k = 0; level > 0 && k < amount; ++k) {
                if (!DigDurabilityEnchantment.m_44655_((ItemStack)stack, (int)level, (Random)Ref.RNG)) continue;
                ++j;
            }
            amount -= j;
        }
        boolean empty = false;
        if (amount > 0) {
            int l = stack.m_41773_() + amount;
            stack.m_41721_(l);
            boolean bl = empty = l >= stack.m_41776_();
        }
        if (empty) {
            if (!this.getGTToolType().getBrokenItems().containsKey((Object)this.getId())) {
                return ItemStack.f_41583_;
            }
            ItemStack item = (ItemStack)((Function)this.getGTToolType().getBrokenItems().get((Object)this.getId())).apply(oldStack);
            return item;
        }
        return stack;
    }

    default public int getDefaultEnergyUse() {
        return 100;
    }

    default public int damage(ItemStack stack, int amount) {
        if (!this.getGTToolType().isPowered()) {
            return amount;
        }
        IEnergyHandlerItem h = stack.getCapability(TesseractCaps.ENERGY_HANDLER_CAPABILITY_ITEM).resolve().orElse(null);
        if (!(h instanceof ItemEnergyHandler)) {
            return amount;
        }
        long currentEnergy = h.getEnergy();
        Map enchants = EnchantmentHelper.m_44831_((ItemStack)stack);
        int energyEfficiency = enchants.getOrDefault(Data.ENERGY_EFFICIENCY, 0);
        int energyUse = Math.max(1, this.getDefaultEnergyUse() - (int)((float)energyEfficiency * 0.1f * (float)this.getDefaultEnergyUse()));
        int multipliedDamage = amount * energyUse;
        if (Ref.RNG.nextInt(20) == 0) {
            return amount;
        }
        if (currentEnergy >= (long)multipliedDamage) {
            h.extractEu((long)multipliedDamage, false);
            stack.m_41751_(h.getContainer().getTag());
            return 0;
        }
        int leftOver = (int)((long)multipliedDamage - currentEnergy);
        h.extractEu(currentEnergy, false);
        stack.m_41751_(h.getContainer().getTag());
        return Math.max(1, leftOver / this.getDefaultEnergyUse());
    }

    @Override
    default public boolean hasEnoughDurability(ItemStack stack, int damage, boolean energy) {
        if (energy && this.getCurrentEnergy(stack) >= (long)(damage * 100)) {
            return true;
        }
        return stack.m_41773_() >= damage;
    }

    default public void onItemBreak(ItemStack stack, Player entity) {
        String name = this.getId();
        GTToolType type = this.getGTToolType();
        if (!type.getBrokenItems().containsKey((Object)name)) {
            return;
        }
        ItemStack item = (ItemStack)((Function)type.getBrokenItems().get((Object)name)).apply(stack);
        if (!item.m_41619_() && !entity.m_36356_(item)) {
            entity.m_36176_(item, true);
        }
    }

    @Override
    default public int getItemColor(ItemStack stack, @Nullable Block block, int i) {
        return i >= 2 ? -1 : (i == 0 ? this.getPrimaryMaterial(stack).getRGB() : (this.getSubColour(stack) == 0 ? this.getSecondaryMaterial(stack).getRGB() : this.getSubColour(stack)));
    }

    @Override
    default public Texture[] getTextures() {
        ObjectArrayList textures = new ObjectArrayList();
        int layers = this.getGTToolType().getOverlayLayers();
        textures.add(new Texture(this.getTextureDomain(), "item/tool/".concat(this.getGTToolType().getId())));
        if (layers == 1) {
            textures.add(new Texture(this.getTextureDomain(), "item/tool/overlay/".concat(this.getGTToolType().getId())));
        }
        if (layers > 1) {
            for (int i = 1; i <= layers; ++i) {
                textures.add(new Texture(this.getTextureDomain(), String.join((CharSequence)"", "item/tool/overlay/", this.getGTToolType().getId(), "_", Integer.toString(i))));
            }
        }
        return textures.toArray(new Texture[textures.size()]);
    }

    @Override
    default public void onItemModelBuild(ItemLike item, GTItemModelProvider prov) {
        prov.tex(item, "minecraft:item/handheld", (ResourceLocation[])this.getTextures());
    }

    public boolean canDisableShield(ItemStack var1, ItemStack var2, LivingEntity var3, LivingEntity var4);
}

