/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.machine;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import lombok.Generated;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;
import org.gtreimagined.gtlib.Data;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.GTRemapping;
import org.gtreimagined.gtlib.Ref;
import org.gtreimagined.gtlib.block.BlockBasic;
import org.gtreimagined.gtlib.blockentity.BlockEntityMachine;
import org.gtreimagined.gtlib.blockentity.BlockEntityTickable;
import org.gtreimagined.gtlib.capability.ICoverHandler;
import org.gtreimagined.gtlib.client.SoundHelper;
import org.gtreimagined.gtlib.cover.CoverFactory;
import org.gtreimagined.gtlib.cover.CoverReplacements;
import org.gtreimagined.gtlib.cover.ICover;
import org.gtreimagined.gtlib.cover.IHaveCover;
import org.gtreimagined.gtlib.data.GTTools;
import org.gtreimagined.gtlib.datagen.builder.GTBlockModelBuilder;
import org.gtreimagined.gtlib.datagen.builder.GTItemModelBuilder;
import org.gtreimagined.gtlib.datagen.json.JLoaderModel;
import org.gtreimagined.gtlib.datagen.providers.GTBlockStateProvider;
import org.gtreimagined.gtlib.datagen.providers.GTItemModelProvider;
import org.gtreimagined.gtlib.machine.MachineState;
import org.gtreimagined.gtlib.machine.Tier;
import org.gtreimagined.gtlib.machine.types.Machine;
import org.gtreimagined.gtlib.registration.IColorHandler;
import org.gtreimagined.gtlib.registration.IItemBlockProvider;
import org.gtreimagined.gtlib.texture.Texture;
import org.gtreimagined.gtlib.tool.GTToolType;
import org.gtreimagined.gtlib.util.FluidUtils;
import org.gtreimagined.gtlib.util.Utils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockMachine
extends BlockBasic
implements IItemBlockProvider,
EntityBlock,
IColorHandler {
    protected Machine<?> type;
    protected Tier tier;
    protected final StateDefinition<Block, BlockState> stateContainer;

    public BlockMachine(Machine<?> type, Tier tier) {
        this(type, tier, BlockBehaviour.Properties.m_60939_((Material)Data.WRENCH_MATERIAL).m_60913_(1.0f, 10.0f).m_60918_(SoundType.f_56743_).m_60999_());
    }

    public BlockMachine(Machine<?> type, Tier tier, BlockBehaviour.Properties properties) {
        super(type.getDomain(), type.getIdFromTier(tier), (type.has("unculled") ? properties.m_60955_() : properties).m_60922_((blockState, blockGetter, blockPos, object) -> false));
        StateDefinition.Builder builder = new StateDefinition.Builder((Object)this);
        this.type = type;
        this.tier = tier;
        this.m_7926_((StateDefinition.Builder<Block, BlockState>)builder);
        this.stateContainer = builder.m_61101_(Block::m_49966_, BlockState::new);
        this.m_49959_((BlockState)this.stateContainer.m_61090_());
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter level, BlockPos pos) {
        if (this.type.has("unculled")) {
            return Shapes.m_83040_();
        }
        return super.m_7952_(state, level, pos);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (this.type.getShapeGetter() != null) {
            return this.type.getShapeGetter().getShape(state, level, pos, context);
        }
        return super.m_5940_(state, level, pos, context);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        if (this.type == null || this.type.isNoFacing()) {
            return;
        }
        if (this.type.isVerticalFacingAllowed()) {
            builder.m_61104_(new Property[]{BlockStateProperties.f_61372_});
        } else {
            builder.m_61104_(new Property[]{BlockStateProperties.f_61374_});
        }
    }

    public StateDefinition<Block, BlockState> m_49965_() {
        return this.stateContainer;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        if (this.type.isNoFacing()) {
            return this.m_49966_();
        }
        if (this.type.isVerticalFacingAllowed()) {
            Direction dir = context.m_7820_().m_122424_();
            return (BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)this.type.handlePlacementFacing(context, (Property<?>)BlockStateProperties.f_61372_, dir));
        }
        return (BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)this.type.handlePlacementFacing(context, (Property<?>)BlockStateProperties.f_61374_, context.m_8125_().m_122424_()));
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        super.m_6861_(state, worldIn, pos, blockIn, fromPos, isMoving);
        BlockEntityMachine tile = (BlockEntityMachine)worldIn.m_7702_(pos);
        if (tile != null) {
            tile.onBlockUpdate(fromPos);
        }
    }

    @NotNull
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntityMachine tile = (BlockEntityMachine)world.m_7702_(pos);
        if (tile != null) {
            ItemStack stack = player.m_21120_(hand);
            GTToolType type = Utils.getToolType(player);
            InteractionResult ty = tile.onInteractBoth(state, world, pos, player, hand, hit, type);
            if (ty.m_19077_()) {
                return ty;
            }
            if (!world.f_46443_ && hand == InteractionHand.MAIN_HAND) {
                InteractionResult coverInteract;
                Item item = stack.m_41720_();
                if (item instanceof IHaveCover) {
                    IHaveCover cover = (IHaveCover)item;
                    factory = cover.getCover();
                    Direction dir = Utils.getInteractSide(hit);
                    boolean ok = tile.getCoverHandler().map(i -> i.placeCover(player, Utils.getInteractSide(hit), stack, factory.get().get((ICoverHandler<?>)i, cover.getTier(), dir, factory))).orElse(false);
                    if (ok) {
                        return InteractionResult.SUCCESS;
                    }
                } else if (CoverReplacements.hasReplacement(stack.m_41720_())) {
                    factory = CoverReplacements.getReplacement(stack.m_41720_());
                    Direction dir = Utils.getInteractSide(hit);
                    boolean ok = tile.getCoverHandler().map(i -> i.placeCover(player, Utils.getInteractSide(hit), stack, factory.get().get((ICoverHandler<?>)i, null, dir, factory))).orElse(false);
                    if (ok) {
                        return InteractionResult.SUCCESS;
                    }
                }
                if (type == GTTools.WRENCH) {
                    if (tile.wrenchMachine(player, hit, player.m_6047_())) {
                        Utils.damageStack(stack, hand, (LivingEntity)player);
                        return InteractionResult.SUCCESS;
                    }
                } else if (type == GTTools.WRENCH_ALT) {
                    if (tile.setSecondaryOutputFacing(player, Utils.getInteractSide(hit))) {
                        Utils.damageStack(stack, hand, (LivingEntity)player);
                        return InteractionResult.SUCCESS;
                    }
                } else if (type == GTTools.SOFT_HAMMER) {
                    boolean wasDisabled = tile.toggleMachine();
                    if (wasDisabled) {
                        if (tile.getMachineState() == MachineState.DISABLED) {
                            player.m_6352_((Component)Utils.literal("Disabled machine."), player.m_142081_());
                        } else {
                            player.m_6352_((Component)Utils.literal("Enabled machine."), player.m_142081_());
                        }
                        Utils.damageStack(stack, (LivingEntity)player);
                        return InteractionResult.SUCCESS;
                    }
                } else if (type == GTTools.CROWBAR) {
                    if (!player.m_6047_()) {
                        if (tile.getCoverHandler().map(h -> h.removeCover(player, Utils.getInteractSide(hit), false)).orElse(false).booleanValue()) {
                            Utils.damageStack(stack, hand, (LivingEntity)player);
                            return InteractionResult.SUCCESS;
                        }
                    } else if (tile.getCoverHandler().map(h -> h.moveCover(player, hit.m_82434_(), Utils.getInteractSide(hit))).orElse(false).booleanValue()) {
                        Utils.damageStack(stack, hand, (LivingEntity)player);
                        return InteractionResult.SUCCESS;
                    }
                } else if (type == GTTools.SCREWDRIVER) {
                    ICover instance = tile.getCoverHandler().map(h -> h.get(Utils.getInteractSide(hit))).orElse(ICover.empty);
                    if (!player.m_6047_() && !instance.isEmpty() && instance.openGui(player, Utils.getInteractSide(hit))) {
                        Utils.damageStack(stack, hand, (LivingEntity)player);
                        return InteractionResult.SUCCESS;
                    }
                }
                if ((coverInteract = tile.getCoverHandler().map(h -> h.onInteract(player, hand, Utils.getInteractSide(hit), Utils.getToolType(player))).orElse(InteractionResult.PASS)) != InteractionResult.PASS) {
                    return coverInteract;
                }
                if (tile.fluidHandler.map(fh -> {
                    Consumer<ItemStack> consumer = s -> {
                        if (player.m_7500_()) {
                            return;
                        }
                        boolean single = stack.m_41613_() == 1;
                        stack.m_41774_(1);
                        if (single) {
                            player.m_21008_(hand, s);
                        } else if (!player.m_36356_(s)) {
                            player.m_36176_(s, true);
                        }
                    };
                    boolean success = false;
                    if (FluidUtils.fillItemFromContainer(-1, Utils.ca(1, stack), fh, consumer)) {
                        success = true;
                    } else if (FluidUtils.emptyItemIntoContainer(-1, Utils.ca(1, stack), fh, consumer)) {
                        success = true;
                    }
                    return success;
                }).orElse(false).booleanValue()) {
                    return InteractionResult.SUCCESS;
                }
                if (this.getType().has("gui") && tile.canPlayerOpenGui(player)) {
                    NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)tile, extra -> extra.m_130064_(pos));
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.PASS;
            }
        }
        return InteractionResult.CONSUME;
    }

    public List<ItemStack> m_7381_(BlockState state, LootContext.Builder builder) {
        List list = super.m_7381_(state, builder);
        BlockEntity tileentity = (BlockEntity)builder.m_78982_(LootContextParams.f_81462_);
        if (tileentity instanceof BlockEntityMachine) {
            BlockEntityMachine machine = (BlockEntityMachine)tileentity;
            machine.dropCovers(state, builder, list);
            machine.onDrop(state, builder, list);
            machine.dropInventory(state, builder, list);
        }
        return list;
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.m_6402_(world, pos, state, placer, stack);
        BlockEntity tileEntity = world.m_7702_(pos);
        if (tileEntity instanceof BlockEntityMachine) {
            BlockEntityMachine machine = (BlockEntityMachine)tileEntity;
            machine.onPlacedBy(world, pos, state, placer, stack);
        }
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_()) && worldIn.f_46443_) {
            SoundHelper.clear(worldIn, pos);
        }
        super.m_6810_(state, worldIn, pos, newState, isMoving);
    }

    @Override
    public Component getDisplayName(ItemStack stack) {
        return this.getType().getDisplayName(this.getTier());
    }

    @Override
    public CreativeModeTab getItemGroup() {
        return this.getType().getGroup();
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter world, List<Component> tooltip, TooltipFlag flag) {
        if (this.getType().has("basic") && !this.getType().has("fe") && this.getTier().getVoltage() > 0L && this.getType().has("eu")) {
            String in = this.getType().has("generator") ? "out" : "in";
            tooltip.add((Component)Utils.translatable("machine.voltage." + in, new Object[0]).m_130946_(": ").m_7220_((Component)Utils.literal(this.getTier().getVoltage() + " (" + this.getTier().getId().toUpperCase() + ")")).m_130940_(ChatFormatting.GREEN));
            tooltip.add((Component)Utils.translatable("machine.power.capacity", new Object[0]).m_130946_(": ").m_7220_((Component)Utils.literal("" + this.getTier().getVoltage() * (this.getType().has("generator") ? 40L : 64L))).m_130940_(ChatFormatting.BLUE));
        }
        this.type.getTooltipFunctions().forEach(t -> t.getTooltips(this, stack, world, tooltip, flag));
        if (stack.m_41783_() != null && stack.m_41783_().m_128441_("covers")) {
            CompoundTag covers = stack.m_41783_().m_128469_("covers");
            if (!Screen.m_96638_()) {
                tooltip.add((Component)Utils.translatable("gtlib.tooltip.more", new Object[0]));
            } else {
                tooltip.add((Component)Utils.translatable("gtlib.tooltip.cover.covers_on_item", new Object[0]));
                byte sides = covers.m_128445_("vs");
                for (int i = 0; i < Ref.DIRS.length; ++i) {
                    Tier tier;
                    if ((sides & 1 << i) <= 0) continue;
                    Direction dir = Direction.m_122376_((int)i);
                    String domain = covers.m_128461_(dir.m_122411_() + "d");
                    String id = covers.m_128461_(dir.m_122411_() + "i");
                    ResourceLocation location = new ResourceLocation(domain, id);
                    if (GTRemapping.getCoverRemappingMap().containsKey(location)) {
                        location = GTRemapping.getCoverRemappingMap().get(location);
                    }
                    CoverFactory factory = GTAPI.get(CoverFactory.class, location);
                    Tier tier2 = tier = covers.m_128441_(dir.m_122411_() + "t") ? GTAPI.get(Tier.class, covers.m_128461_(dir.m_122411_() + "t")) : null;
                    if (factory == null) continue;
                    ItemStack item = factory.getItem(tier);
                    Component itemTip = item.m_41619_() ? Utils.translatable("cover." + domain + "." + id, new Object[0]) : item.m_41786_();
                    tooltip.add((Component)Utils.translatable("gtlib.tooltip.cover.stack", dir.m_122433_(), itemTip));
                }
            }
        }
    }

    @Override
    public void onItemModelBuild(ItemLike item, GTItemModelProvider prov) {
        GTItemModelBuilder b = (GTItemModelBuilder)((GTItemModelBuilder)prov.getBuilder(item).parent(this.type.getItemModelParent())).texture("base", this.type.getBaseTexture(this.tier, MachineState.IDLE)[0]);
        Texture[] base = this.type.getBaseTexture(this.tier, MachineState.ACTIVE);
        if (base.length >= 6) {
            for (int s = 0; s < 6; ++s) {
                b.texture("base" + Utils.coverRotateFacing(Ref.DIRS[s], Direction.NORTH).m_7912_(), base[s]);
            }
        }
        for (int i = 0; i < this.type.getOverlayLayers(); ++i) {
            Texture[] overlays = this.type.getOverlayTextures(MachineState.ACTIVE, this.tier, i);
            for (int s = 0; s < 6; ++s) {
                String suffix = i == 0 ? "" : String.valueOf(i);
                b.texture("overlay" + Utils.coverRotateFacing(Ref.DIRS[s], Direction.NORTH).m_7912_() + suffix, overlays[s]);
            }
        }
    }

    @Override
    public void onBlockModelBuild(Block block, GTBlockStateProvider prov) {
        GTBlockModelBuilder builder = prov.getBuilder(block);
        this.buildModelsForState(builder, MachineState.IDLE);
        this.buildModelsForState(builder, MachineState.ACTIVE);
        builder.loader(this.type.getModelLoader());
        builder.property("particle", this.getType().getBaseTexture(this.tier, MachineState.IDLE)[0].toString());
        prov.state(block, builder);
    }

    protected void buildModelsForState(GTBlockModelBuilder builder, MachineState state) {
        ArrayList<JLoaderModel> arr = new ArrayList<JLoaderModel>();
        for (Direction dir : Ref.DIRS) {
            ImmutableMap.Builder builder1 = ImmutableMap.builder();
            builder1.put((Object)"base", (Object)this.getType().getBaseTexture(this.tier, dir, state).toString());
            for (int i = 0; i < this.type.getOverlayLayers(); ++i) {
                String suffix = i == 0 ? "" : String.valueOf(i);
                builder1.put((Object)("overlay" + suffix), (Object)this.type.getOverlayTextures(state, this.tier, i)[dir.m_122411_()].toString());
            }
            JLoaderModel obj = builder.addModelObject(JLoaderModel.modelKeepElements(), this.getType().getOverlayModel(state, dir).toString(), (ImmutableMap<String, String>)builder1.build());
            arr.add(obj);
        }
        builder.property(state.toString().toLowerCase(), arr);
    }

    public int m_6378_(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        BlockEntity entity = blockAccess.m_7702_(pos);
        if (entity instanceof BlockEntityMachine) {
            BlockEntityMachine machine = (BlockEntityMachine)entity;
            return machine.getWeakRedstonePower(side == null ? null : side.m_122424_());
        }
        return super.m_6378_(blockState, blockAccess, pos, side);
    }

    public int m_6376_(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        BlockEntity entity = blockAccess.m_7702_(pos);
        if (entity instanceof BlockEntityMachine) {
            BlockEntityMachine machine = (BlockEntityMachine)entity;
            return machine.getStrongRedstonePower(side == null ? null : side.m_122424_());
        }
        return super.m_6376_(blockState, blockAccess, pos, side);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        BlockEntityMachine machine = (BlockEntityMachine)this.getType().getTileType().m_155264_(pos, state);
        return machine;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return BlockEntityTickable::commonTick;
    }

    public void m_7100_(BlockState state, Level level, BlockPos pos, Random random) {
        if (!this.type.isAmbientTicking()) {
            return;
        }
        BlockEntity be = level.m_7702_(pos);
        if (be instanceof BlockEntityMachine) {
            BlockEntityMachine machine = (BlockEntityMachine)be;
            machine.animateTick(state, level, pos, random);
        }
    }

    @Override
    public BlockItem getItemBlock() {
        return this.type.getItemBlockFunction().apply(this);
    }

    @Override
    public int getItemColor(ItemStack stack, @Nullable Block block, int i) {
        int color = this.type.getItemColorHandler().getItemColor(stack, block, i);
        if (color != -1) {
            return color;
        }
        return -1;
    }

    @Override
    public int getBlockColor(BlockState state, @Nullable BlockGetter world, @Nullable BlockPos pos, int i) {
        int color;
        BlockEntity blockEntity;
        BlockEntityMachine machine = null;
        if (world != null && pos != null && (blockEntity = world.m_7702_(pos)) instanceof BlockEntityMachine) {
            BlockEntityMachine machine1;
            machine = machine1 = (BlockEntityMachine)blockEntity;
        }
        if ((color = this.type.getBlockColorHandler().getBlockColor(state, world, pos, machine, i)) != -1) {
            return color;
        }
        return -1;
    }

    @Generated
    public Machine<?> getType() {
        return this.type;
    }

    @Generated
    public Tier getTier() {
        return this.tier;
    }
}

