/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.integration.ct;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.action.base.IAction;
import com.blamejared.crafttweaker.api.action.recipe.ActionAddRecipe;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.fluid.IFluidStack;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraftforge.fluids.FluidStack;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.integration.ct.RecipeManager;
import org.gtreimagined.gtlib.recipe.ingredient.FluidIngredient;
import org.gtreimagined.gtlib.recipe.map.IRecipeMap;
import org.gtreimagined.gtlib.recipe.map.RecipeBuilder;
import org.gtreimagined.gtlib.recipe.map.RecipeMap;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.gtlib.RecipeBuilder")
public class CTRecipeBuilder {
    RecipeBuilder recipeBuilder;
    RecipeManager manager;

    public CTRecipeBuilder(String mapId, RecipeManager manager) {
        IRecipeMap map = GTAPI.get(IRecipeMap.class, mapId);
        if (!(map instanceof RecipeMap)) {
            throw new IllegalArgumentException("Invalid recipe map: " + mapId);
        }
        RecipeMap recipeMap = (RecipeMap)map;
        if (!recipeMap.getRecipeType().equals(manager.getRecipeType())) {
            throw new IllegalArgumentException("Recipe map: " + mapId + " does not use this recipe type! Recipe type: " + manager.getBracketResourceLocation());
        }
        this.recipeBuilder = recipeMap.RB();
        this.manager = manager;
    }

    @ZenCodeType.Method
    public CTRecipeBuilder ii(IIngredient ... itemInput) {
        List<Ingredient> input = itemInput == null ? Collections.emptyList() : Arrays.stream(itemInput).map(IIngredient::asVanillaIngredient).toList();
        this.recipeBuilder.ii(input);
        return this;
    }

    @ZenCodeType.Method
    public CTRecipeBuilder io(IItemStack ... itemOutput) {
        ItemStack[] outputs = itemOutput == null || itemOutput.length == 0 ? IRecipeMap.EMPTY_ITEM : (ItemStack[])Arrays.stream(itemOutput).map(IItemStack::getInternal).toArray(ItemStack[]::new);
        this.recipeBuilder.io(outputs);
        return this;
    }

    @ZenCodeType.Method
    public CTRecipeBuilder fi(IFluidStack ... fluidInput) {
        List<FluidIngredient> fluidIn = fluidInput == null ? Collections.emptyList() : Arrays.stream(fluidInput).map(t -> FluidIngredient.of(t.getInternal())).toList();
        this.recipeBuilder.fi(fluidIn.toArray(new FluidIngredient[0]));
        return this;
    }

    @ZenCodeType.Method
    public CTRecipeBuilder fo(IFluidStack ... fluidOutput) {
        FluidStack[] fluidOut = fluidOutput == null ? IRecipeMap.EMPTY_FLUID : (FluidStack[])Arrays.stream(fluidOutput).map(t -> t.getInternal()).toArray(FluidStack[]::new);
        this.recipeBuilder.fo(fluidOut);
        return this;
    }

    @ZenCodeType.Method
    public CTRecipeBuilder outputChances(double ... chances) {
        this.recipeBuilder.outputChances(chances);
        return this;
    }

    @ZenCodeType.Method
    public CTRecipeBuilder inputChances(double ... chances) {
        this.recipeBuilder.inputChances(chances);
        return this;
    }

    @ZenCodeType.Method
    public CTRecipeBuilder hide() {
        this.recipeBuilder.hide();
        return this;
    }

    @ZenCodeType.Method
    public CTRecipeBuilder fake() {
        this.recipeBuilder.fake();
        return this;
    }

    @ZenCodeType.Method
    public void build(String id, long duration, long power, long special) {
        this.build(id, duration, power, special, 1);
    }

    @ZenCodeType.Method
    public void build(String domain, String id, long duration, long power, long special, int amps) {
        CraftTweakerAPI.apply((IAction)new ActionAddRecipe((IRecipeManager)this.manager, (Recipe)((org.gtreimagined.gtlib.recipe.Recipe)this.recipeBuilder.recipeMapOnly().add(domain, id, duration, power, special, amps))));
    }

    @ZenCodeType.Method
    public void build(String id, long duration, long power, long special, int amps) {
        this.build("crafttweaker", id, duration, power, special, amps);
    }

    @ZenCodeType.Method
    public void build(String id, long duration, long power) {
        this.build(id, duration, power, 0L);
    }

    @ZenCodeType.Method
    public void build(String id, long duration) {
        this.build(id, duration, 0L, 0L);
    }
}

