/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.material;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.gtreimagined.gtlib.Ref;
import org.gtreimagined.gtlib.data.GTMaterialTypes;
import org.gtreimagined.gtlib.data.VanillaStoneTypes;
import org.gtreimagined.gtlib.item.ItemBasic;
import org.gtreimagined.gtlib.material.IMaterialObject;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.material.MaterialTags;
import org.gtreimagined.gtlib.material.MaterialType;
import org.gtreimagined.gtlib.material.MaterialTypeBlock;
import org.gtreimagined.gtlib.material.data.ToolData;
import org.gtreimagined.gtlib.ore.StoneType;
import org.gtreimagined.gtlib.registration.IColorHandler;
import org.gtreimagined.gtlib.registration.IModelProvider;
import org.gtreimagined.gtlib.registration.ISharedGTObject;
import org.gtreimagined.gtlib.registration.ITextureProvider;
import org.gtreimagined.gtlib.texture.Texture;
import org.gtreimagined.gtlib.util.CodeUtils;
import org.gtreimagined.gtlib.util.TagUtils;
import org.gtreimagined.gtlib.util.Utils;
import org.gtreimagined.gtlib.worldgen.WorldGenHelper;
import org.jetbrains.annotations.Nullable;

public class MaterialItem
extends ItemBasic<MaterialItem>
implements ISharedGTObject,
IColorHandler,
ITextureProvider,
IModelProvider,
IMaterialObject {
    protected Material material;
    protected MaterialType<?> type;

    public MaterialItem(String domain, MaterialType<?> type, Material material, Item.Properties properties) {
        super(domain, type.getId() + "_" + material.getId(), MaterialItem.class, properties);
        this.material = material;
        this.type = type;
    }

    public MaterialItem(String domain, MaterialType<?> type, Material material) {
        this(domain, type, material, new Item.Properties().m_41491_(Ref.TAB_MATERIALS));
    }

    public MaterialType<?> getType() {
        return this.type;
    }

    @Override
    public Material getMaterial() {
        return this.material;
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (this.m_41389_(group) && this.getType().isVisible()) {
            items.add((Object)new ItemStack((ItemLike)this));
        }
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        if (this.type == GTMaterialTypes.BEARING_ROCK) {
            tooltip.add((Component)Utils.translatable("gtlib.tooltip.occurrence", new Object[0]).m_7220_((Component)Utils.literal(this.material.getDisplayName().getString()).m_130940_(ChatFormatting.YELLOW)));
        }
    }

    public static void addTooltipsForMaterialItems(ItemStack stack, Material mat, MaterialType<?> type, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        if (mat.has(MaterialTags.TOOLS)) {
            ToolData toolData = MaterialTags.TOOLS.get(mat);
            tooltip.add((Component)Utils.literal("Q: " + toolData.toolQuality() + " - S: " + toolData.toolSpeed() + " - D: " + toolData.toolDurability()).m_130940_(ChatFormatting.BLUE));
        }
        if (!mat.getChemicalFormula().isEmpty()) {
            if (Screen.m_96638_()) {
                tooltip.add((Component)Utils.translatable("gtlib.tooltip.chemical_formula", Utils.literal(mat.getChemicalFormula()).m_130940_(ChatFormatting.DARK_AQUA)));
                tooltip.add((Component)Utils.translatable("gtlib.tooltip.mass", Utils.literal("" + mat.getMass()).m_130940_(ChatFormatting.DARK_AQUA)));
                tooltip.add((Component)Utils.translatable("gtlib.tooltip.atomic_number", Utils.literal("" + mat.getProtons()).m_130940_(ChatFormatting.DARK_AQUA)));
            } else {
                tooltip.add((Component)Utils.translatable("gtlib.tooltip.formula", new Object[0]).m_130940_(ChatFormatting.AQUA).m_130940_(ChatFormatting.ITALIC));
            }
        }
        if (mat.getElement() != null) {
            tooltip.add((Component)Utils.literal("Is Element"));
        }
        if (stack.m_41720_() instanceof MaterialItem) {
            tooltip.add((Component)Utils.translatable("gtlib.tooltip.material_modid", Utils.getModName(mat.materialDomain())));
        }
    }

    public InteractionResult m_6225_(UseOnContext context) {
        if (this.type == GTMaterialTypes.BEARING_ROCK || this.type == GTMaterialTypes.ROCK) {
            return this.tryPlace(new BlockPlaceContext(context));
        }
        return super.m_6225_(context);
    }

    public InteractionResult tryPlace(BlockPlaceContext context) {
        BlockState blockstate;
        if (!context.m_7059_()) {
            return InteractionResult.FAIL;
        }
        if (this.type == GTMaterialTypes.BEARING_ROCK) {
            BlockState existing = WorldGenHelper.getStoneStateForRock(context.m_8083_().m_123342_() - 1, context.m_8083_(), (LevelAccessor)context.m_43725_());
            StoneType type = WorldGenHelper.STONE_MAP.get((Object)existing) != null ? (StoneType)WorldGenHelper.STONE_MAP.get((Object)existing) : VanillaStoneTypes.STONE;
            blockstate = ((MaterialTypeBlock.IOreGetter)GTMaterialTypes.BEARING_ROCK.get()).get(this.material, type).asState();
        } else {
            blockstate = ((MaterialTypeBlock.IBlockGetter)GTMaterialTypes.ROCK.get()).get(this.material).asState();
        }
        if (blockstate == null) {
            return InteractionResult.FAIL;
        }
        if (!context.m_43725_().m_7731_(context.m_8083_(), blockstate, 11)) {
            return InteractionResult.FAIL;
        }
        BlockPos blockpos = context.m_8083_();
        Level world = context.m_43725_();
        Player playerentity = context.m_43723_();
        ItemStack itemstack = context.m_43722_();
        BlockState blockstate1 = world.m_8055_(blockpos);
        Block block = blockstate1.m_60734_();
        if (block == blockstate.m_60734_()) {
            blockstate1 = this.updateBlockStateFromTag(blockpos, world, itemstack, blockstate1);
            this.onBlockPlaced(blockpos, world, playerentity, itemstack, blockstate1);
            block.m_6402_(world, blockpos, blockstate1, (LivingEntity)playerentity, itemstack);
            if (playerentity instanceof ServerPlayer) {
                CriteriaTriggers.f_10591_.m_59469_((ServerPlayer)playerentity, blockpos, itemstack);
            }
        }
        if (!context.m_43723_().m_7500_()) {
            context.m_43722_().m_41774_(1);
        }
        SoundType soundtype = blockstate1.m_60827_();
        world.m_5594_(playerentity, blockpos, blockstate.m_60734_().m_49962_(blockstate1).m_56777_(), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 2.0f, soundtype.m_56774_() * 0.8f);
        return InteractionResult.m_19078_((boolean)world.f_46443_);
    }

    protected boolean onBlockPlaced(BlockPos pos, Level worldIn, @Nullable Player player, ItemStack stack, BlockState state) {
        return BlockItem.m_40582_((Level)worldIn, (Player)player, (BlockPos)pos, (ItemStack)stack);
    }

    private BlockState updateBlockStateFromTag(BlockPos p_219985_1_, Level p_219985_2_, ItemStack p_219985_3_, BlockState p_219985_4_) {
        BlockState blockstate = p_219985_4_;
        CompoundTag compoundnbt = p_219985_3_.m_41783_();
        if (compoundnbt != null) {
            CompoundTag compoundnbt1 = compoundnbt.m_128469_("BlockStateTag");
            StateDefinition statecontainer = p_219985_4_.m_60734_().m_49965_();
            for (String s : compoundnbt1.m_128431_()) {
                Property property = statecontainer.m_61081_(s);
                if (property == null) continue;
                String s1 = compoundnbt1.m_128423_(s).m_7916_();
                blockstate = MaterialItem.updateState(blockstate, property, s1);
            }
        }
        if (blockstate != p_219985_4_) {
            p_219985_2_.m_7731_(p_219985_1_, blockstate, 2);
        }
        return blockstate;
    }

    private static <T extends Comparable<T>> BlockState updateState(BlockState state, Property<T> property, String value) {
        return property.m_6215_(value).map(p_219986_2_ -> (BlockState)state.m_61124_(property, p_219986_2_)).orElse(state);
    }

    public static InteractionResult interactWithCauldron(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, ItemStack stack) {
        int level;
        if (world.m_5776_()) {
            return InteractionResult.PASS;
        }
        MaterialItem item = (MaterialItem)stack.m_41720_();
        MaterialType<?> type = item.getType();
        if (state.m_60734_() instanceof AbstractCauldronBlock && (level = ((Integer)state.m_61143_((Property)LayeredCauldronBlock.f_153514_)).intValue()) > 0) {
            Material material = ((MaterialItem)stack.m_41720_()).getMaterial();
            if (type == GTMaterialTypes.DUST_IMPURE || type == GTMaterialTypes.DUST_PURE) {
                if (material.has(GTMaterialTypes.DUST)) {
                    Material byProduct;
                    stack.m_41774_(1);
                    if (!player.m_36356_(GTMaterialTypes.DUST.get(material, 1))) {
                        player.m_36176_(GTMaterialTypes.DUST.get(material, 1), false);
                    }
                    Material oreByProduct = !material.getByProducts().isEmpty() ? material.getByProducts().get(0) : material;
                    Material oreByProduct2 = material.getByProducts().size() > 1 ? material.getByProducts().get(1) : oreByProduct;
                    Material material2 = byProduct = type == GTMaterialTypes.DUST_IMPURE ? oreByProduct : oreByProduct2;
                    if (byProduct.has(GTMaterialTypes.DUST) && world.f_46441_.nextInt(100) < 50 && !player.m_36356_(GTMaterialTypes.DUST_TINY.get(oreByProduct, 1))) {
                        player.m_36176_(GTMaterialTypes.DUST_TINY.get(oreByProduct, 1), false);
                    }
                    LayeredCauldronBlock.m_153559_((BlockState)state, (Level)world, (BlockPos)pos);
                    world.m_5594_(null, pos, SoundEvents.f_11778_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    return InteractionResult.SUCCESS;
                }
            } else if (type == GTMaterialTypes.CRUSHED && material.has(GTMaterialTypes.CRUSHED_PURIFIED)) {
                Material oreByProduct;
                stack.m_41774_(1);
                if (!player.m_36356_(GTMaterialTypes.CRUSHED_PURIFIED.get(material, 1))) {
                    player.m_36176_(GTMaterialTypes.CRUSHED_PURIFIED.get(material, 1), false);
                }
                Material material3 = oreByProduct = !material.getByProducts().isEmpty() ? material.getByProducts().get(0) : material;
                if (oreByProduct.has(GTMaterialTypes.DUST) && world.f_46441_.nextInt(100) < 50 && !player.m_36356_(GTMaterialTypes.DUST_TINY.get(oreByProduct, 1))) {
                    player.m_36176_(GTMaterialTypes.DUST_TINY.get(oreByProduct, 1), false);
                }
                LayeredCauldronBlock.m_153559_((BlockState)state, (Level)world, (BlockPos)pos);
                world.m_5594_(null, pos, SoundEvents.f_11778_, SoundSource.BLOCKS, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public TagKey<Item> getTag() {
        return TagUtils.getForgelikeItemTag(String.join((CharSequence)"", Utils.getConventionalMaterialType(this.type), "/", this.material.getId()));
    }

    public static boolean hasType(ItemStack stack, MaterialType<?> type) {
        return stack.m_41720_() instanceof MaterialItem && ((MaterialItem)stack.m_41720_()).getType() == type;
    }

    public static boolean hasMaterial(ItemStack stack, Material material) {
        return stack.m_41720_() instanceof MaterialItem && ((MaterialItem)stack.m_41720_()).getMaterial() == material;
    }

    public static MaterialType<?> getType(ItemStack stack) {
        if (!(stack.m_41720_() instanceof MaterialItem)) {
            return null;
        }
        return ((MaterialItem)stack.m_41720_()).getType();
    }

    public static Material getMaterial(ItemStack stack) {
        if (!(stack.m_41720_() instanceof MaterialItem)) {
            return null;
        }
        return ((MaterialItem)stack.m_41720_()).getMaterial();
    }

    public static boolean doesShowExtendedHighlight(ItemStack stack) {
        return MaterialItem.hasType(stack, GTMaterialTypes.PLATE);
    }

    @Override
    public int getItemColor(ItemStack stack, @Nullable Block block, int i) {
        if (i == 0) {
            return this.material.getRGB();
        }
        return -1;
    }

    @OnlyIn(value=Dist.CLIENT)
    private int getChangingMaterialColor() {
        long currentRemainder;
        long l = currentRemainder = Minecraft.m_91087_().f_91074_ != null ? Minecraft.m_91087_().f_91074_.m_183503_().m_46467_() % 100L : -1L;
        if (currentRemainder >= 0L) {
            int direction = (int)(currentRemainder < 50L ? currentRemainder : -(currentRemainder - 50L));
            int rgb = this.material.getRGB();
            short r = CodeUtils.getR(rgb);
            short g = CodeUtils.getG(rgb);
            short b = CodeUtils.getB(rgb);
            int newR = this.material.has(MaterialTags.POSITIVE_CHANGING_RGB) ? r + direction : r - direction;
            int newG = this.material.has(MaterialTags.POSITIVE_CHANGING_RGB) ? g + direction : g - direction;
            int newB = this.material.has(MaterialTags.POSITIVE_CHANGING_RGB) ? b + direction : b - direction;
            return CodeUtils.getRGB(newR, newG, newB);
        }
        return this.material.getRGB();
    }

    @Override
    public Texture[] getTextures() {
        return this.getMaterial().getSet().getTextures(this.getType());
    }
}

