/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.machine.types;

import java.util.List;
import java.util.function.Function;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraftforge.fluids.FluidStack;
import org.gtreimagined.gtlib.Data;
import org.gtreimagined.gtlib.blockentity.BlockEntityTank;
import org.gtreimagined.gtlib.gui.GuiInstance;
import org.gtreimagined.gtlib.gui.ICanSyncData;
import org.gtreimagined.gtlib.gui.IGuiElement;
import org.gtreimagined.gtlib.gui.widget.InfoRenderWidget;
import org.gtreimagined.gtlib.gui.widget.WidgetSupplier;
import org.gtreimagined.gtlib.integration.xei.renderer.IInfoRenderer;
import org.gtreimagined.gtlib.machine.BlockMachine;
import org.gtreimagined.gtlib.machine.Tier;
import org.gtreimagined.gtlib.machine.types.Machine;
import org.gtreimagined.gtlib.util.Utils;

public class TankMachine
extends Machine<TankMachine> {
    final Function<Tier, Integer> capacityPerTier;

    public TankMachine(String domain, String name) {
        this(domain, name, t -> 8000 * (1 + t.getIntegerId()));
    }

    public TankMachine(String domain, String name, Function<Tier, Integer> capacityPerTier) {
        super(domain, name);
        this.capacityPerTier = capacityPerTier;
        this.setTile(BlockEntityTank::new);
        this.addTooltipInfo((BlockMachine machine, ItemStack stack, BlockGetter world, List<Component> tooltip, TooltipFlag flag) -> tooltip.add(Utils.translatable("machine.tank.capacity", capacityPerTier.apply(machine.getTier()))));
        this.addFlags("item", "fluid", "coverable");
        this.setGUI(Data.BASIC_MENU_HANDLER);
        this.frontCovers();
        this.allowFrontIO();
    }

    public Function<Tier, Integer> getCapacityPerTier() {
        return this.capacityPerTier;
    }

    @Override
    protected void setupGui() {
        super.setupGui();
        this.addGuiCallback(t -> t.addWidget(TankRenderWidget.build().onlyIf(h -> h.handler instanceof BlockEntityTank)));
    }

    public static class TankRenderWidget
    extends InfoRenderWidget<TankRenderWidget> {
        public FluidStack stack = FluidStack.EMPTY;

        protected TankRenderWidget(GuiInstance gui, IGuiElement parent, IInfoRenderer<TankRenderWidget> renderer) {
            super(gui, parent, renderer);
        }

        @Override
        public void init() {
            super.init();
            BlockEntityTank tank = (BlockEntityTank)this.gui.handler;
            this.gui.syncFluidStack(() -> tank.fluidHandler.map(t -> t.getFluidInTank(0)).orElse(FluidStack.EMPTY), f -> {
                this.stack = f;
            }, ICanSyncData.SyncDirection.SERVER_TO_CLIENT);
        }

        public static WidgetSupplier build() {
            return TankRenderWidget.builder((a, b) -> new TankRenderWidget((GuiInstance)a, (IGuiElement)b, (IInfoRenderer)((Object)a.handler)));
        }
    }
}

