/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.machine.types;

import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.gtreimagined.gtlib.Data;
import org.gtreimagined.gtlib.block.BlockBasic;
import org.gtreimagined.gtlib.blockentity.multi.BlockEntityBasicMultiMachine;
import org.gtreimagined.gtlib.cover.ICover;
import org.gtreimagined.gtlib.gui.widget.ProgressWidget;
import org.gtreimagined.gtlib.integration.xei.GTLibXEIPlugin;
import org.gtreimagined.gtlib.machine.BlockMachine;
import org.gtreimagined.gtlib.machine.BlockMultiMachine;
import org.gtreimagined.gtlib.machine.ITooltipArgs;
import org.gtreimagined.gtlib.machine.MachineState;
import org.gtreimagined.gtlib.machine.Tier;
import org.gtreimagined.gtlib.machine.types.Machine;
import org.gtreimagined.gtlib.machine.types.MultiMachine;
import org.gtreimagined.gtlib.structure.Pattern;
import org.gtreimagined.gtlib.structure.PatternBuilder;
import org.gtreimagined.gtlib.structure.PonderUtils;
import org.gtreimagined.gtlib.texture.Texture;
import org.gtreimagined.gtlib.util.Utils;

public class BasicMultiMachine<T extends BasicMultiMachine<T>>
extends Machine<T> {
    Function<Tier, BlockBasic> textureBlock;

    public BasicMultiMachine(String domain, String name) {
        super(domain, name);
        this.setTile(BlockEntityBasicMultiMachine::new);
        this.setBlock(BlockMultiMachine::new);
        this.setItemBlockClass(() -> BlockMultiMachine.class);
        this.addFlags("multi", "coverable");
        this.setClientTicking();
        this.setGUI(Data.BASIC_MENU_HANDLER);
        this.setOutputCover(ICover.emptyFactory);
        this.addTooltipInfo((BlockMachine machine, ItemStack stack, BlockGetter world, List<Component> tooltip, TooltipFlag flag) -> {
            if (machine.getType().getStructure(machine.getTier()) != null) {
                tooltip.add(Utils.translatable("machine.structure.form", new Object[0]));
            }
        });
        this.baseTexture((Machine type, Tier tier, MachineState state) -> {
            Texture[] textureArray;
            if (type.getTiers().size() > 1) {
                Texture[] textureArray2 = new Texture[1];
                textureArray = textureArray2;
                textureArray2[0] = new Texture(domain, "block/machine/base/" + type.getId() + "_" + tier.getId());
            } else {
                Texture[] textureArray3 = new Texture[1];
                textureArray = textureArray3;
                textureArray3[0] = new Texture(domain, "block/machine/base/" + type.getId());
            }
            return textureArray;
        });
    }

    @Override
    protected void setupGui() {
        super.setupGui();
        if (!(this instanceof MultiMachine)) {
            this.addGuiCallback(t -> {
                if (this.has("recipe")) {
                    t.addWidget(ProgressWidget.build());
                }
            });
        }
    }

    @Override
    public List<Texture> getTextures() {
        List<Texture> textures = super.getTextures();
        this.getTiers().forEach(t -> textures.addAll(Arrays.asList(this.getBaseTexture((Tier)t, MachineState.INVALID_STRUCTURE))));
        int i = 0;
        while (i < this.overlayLayers) {
            int finalI = i++;
            this.getTiers().forEach(t -> textures.addAll(Arrays.asList(this.getOverlayTextures(MachineState.INVALID_STRUCTURE, (Tier)t, finalI))));
        }
        return textures;
    }

    public final void setStructurePattern(Function<PatternBuilder, Pattern> patterns) {
        this.setStructurePattern(patterns.apply(new PatternBuilder()));
    }

    public final void setStructurePattern(Pattern ... patterns) {
        if (FMLEnvironment.dist.isClient()) {
            if (patterns.length == 0) {
                return;
            }
            GTLibXEIPlugin.registerPatternForJei(this, Arrays.stream(patterns).collect(Collectors.toList()));
            this.tiers.forEach(t -> PonderUtils.registerMultiblock(this, t, Arrays.asList(patterns)));
        }
    }

    public final void setStructurePattern(Tier tier, Function<PatternBuilder, Pattern> patterns) {
        this.setStructurePattern(tier, patterns.apply(new PatternBuilder()));
    }

    public final void setStructurePattern(Tier tier, Pattern ... patterns) {
        if (FMLEnvironment.dist.isClient()) {
            if (patterns.length == 0) {
                return;
            }
            GTLibXEIPlugin.registerPatternForJei(this, tier, Arrays.stream(patterns).collect(Collectors.toList()));
            PonderUtils.registerMultiblock(this, tier, Arrays.asList(patterns));
        }
    }

    public T setTextureBlock(BlockBasic textureBlock) {
        this.textureBlock = t -> textureBlock;
        return (T)this;
    }

    public T setTextureBlock(Function<Tier, BlockBasic> textureBlock) {
        this.textureBlock = textureBlock;
        return (T)this;
    }

    public T addStructureTooltip(Tier tier, int tooltips) {
        return (T)((BasicMultiMachine)this.addTooltipInfo((BlockMachine machine, ItemStack stack, BlockGetter world, List<Component> tooltip, TooltipFlag flag) -> {
            if (machine.getTier() == tier) {
                for (int i = 0; i < tooltips; ++i) {
                    tooltip.add(Utils.translatable("tooltip." + this.getId() + "." + tier.getId() + "." + i, new Object[0]));
                }
            }
        }));
    }

    public T addStructureTooltip(int tooltips) {
        return (T)((BasicMultiMachine)this.addTooltipInfo((BlockMachine machine, ItemStack stack, BlockGetter world, List<Component> tooltip, TooltipFlag flag) -> {
            for (int i = 0; i < tooltips; ++i) {
                tooltip.add(Utils.translatable("tooltip." + this.getId() + "." + i, new Object[0]));
            }
        }));
    }

    public T addStructureTooltip(int tooltips, ITooltipArgs args) {
        return (T)((BasicMultiMachine)this.addTooltipInfo((BlockMachine machine, ItemStack stack, BlockGetter world, List<Component> tooltip, TooltipFlag flag) -> {
            for (int i = 0; i < tooltips; ++i) {
                tooltip.add(Utils.translatable("tooltip." + this.getId() + "." + i, args.getTooltipArgs(machine, stack, world, flag, i)));
            }
        }));
    }

    @Generated
    public Function<Tier, BlockBasic> getTextureBlock() {
        return this.textureBlock;
    }
}

