/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.item;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.gtreimagined.gtlib.Data;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.Ref;
import org.gtreimagined.gtlib.block.BlockFrame;
import org.gtreimagined.gtlib.block.BlockStone;
import org.gtreimagined.gtlib.block.BlockStorage;
import org.gtreimagined.gtlib.block.IInfoProvider;
import org.gtreimagined.gtlib.blockentity.BlockEntityBase;
import org.gtreimagined.gtlib.data.GTMaterialTypes;
import org.gtreimagined.gtlib.item.ItemBasic;
import org.gtreimagined.gtlib.machine.types.Machine;
import org.gtreimagined.gtlib.ore.BlockOre;
import org.gtreimagined.gtlib.pipe.BlockPipe;
import org.gtreimagined.gtlib.util.Utils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScannerItem
extends ItemBasic<ScannerItem> {
    final boolean simple;

    public ScannerItem(String domain, String id, boolean simple) {
        this(domain, id, simple, "", new Item.Properties().m_41491_(Ref.TAB_ITEMS));
    }

    public ScannerItem(String domain, String id, boolean simple, String subDir, Item.Properties properties) {
        super(domain, id, subDir, properties);
        this.simple = simple;
    }

    public ScannerItem(String domain, String id, boolean simple, Item.Properties properties) {
        this(domain, id, simple, "", properties);
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Utils.literal(this.tooltip));
        if (Screen.m_96638_() && this == Data.DEBUG_SCANNER) {
            tooltip.add((Component)Utils.literal("Blocks: " + GTAPI.all(Block.class).size()));
            tooltip.add((Component)Utils.literal("Machines: " + Machine.getTypes("basic", "multi", "hatch").size()));
            tooltip.add((Component)Utils.literal("Pipes: " + GTAPI.all(BlockPipe.class).size()));
            tooltip.add((Component)Utils.literal("Storage: " + GTAPI.all(BlockStorage.class).size()));
            tooltip.add((Component)Utils.literal("Frame: " + GTAPI.all(BlockFrame.class).size()));
            tooltip.add((Component)Utils.literal("Ores: " + GTAPI.all(BlockOre.class).size()));
            tooltip.add((Component)Utils.literal("Stones: " + GTAPI.all(BlockStone.class).size()));
            tooltip.add((Component)Utils.literal("Data:"));
            tooltip.add((Component)Utils.literal("Ore Materials: " + GTMaterialTypes.ORE.all().size()));
            tooltip.add((Component)Utils.literal("Small Ore Materials: " + GTMaterialTypes.ORE_SMALL.all().size()));
        }
    }

    @NotNull
    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        Block block;
        if (context.m_43725_().f_46443_) {
            return InteractionResult.CONSUME;
        }
        BlockState state = context.m_43725_().m_8055_(context.m_8083_());
        BlockEntity tile = context.m_43725_().m_7702_(context.m_8083_());
        boolean success = false;
        if (tile instanceof BlockEntityBase) {
            BlockEntityBase base = (BlockEntityBase)tile;
            base.getInfo(this.simple).forEach(s -> context.m_43723_().m_6352_((Component)Utils.literal(s), context.m_43723_().m_142081_()));
            success = true;
        }
        if ((block = state.m_60734_()) instanceof IInfoProvider) {
            IInfoProvider dynamic = (IInfoProvider)block;
            if (context.m_43723_() != null) {
                dynamic.getInfo((List<String>)new ObjectArrayList(), context.m_43725_(), state, context.m_8083_(), this.simple).forEach(s -> context.m_43723_().m_6352_((Component)Utils.literal(s), context.m_43723_().m_142081_()));
                success = true;
            }
        }
        if (success) {
            return InteractionResult.SUCCESS;
        }
        return super.m_6225_(context);
    }
}

