/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.integration.jade;

import mcp.mobius.waila.api.BlockAccessor;
import mcp.mobius.waila.api.IComponentProvider;
import mcp.mobius.waila.api.IServerDataProvider;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.config.IPluginConfig;
import mcp.mobius.waila.api.ui.IElementHelper;
import mcp.mobius.waila.api.ui.IProgressStyle;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.gtreimagined.gtlib.integration.jade.JadePlugin;
import snownee.jade.VanillaPlugin;
import tesseract.api.forge.TesseractCaps;
import tesseract.api.gt.IEnergyHandler;
import tesseract.api.heat.IHeatHandler;

public class EUProvider
implements IComponentProvider,
IServerDataProvider<BlockEntity> {
    public static EUProvider INSTANCE = new EUProvider();

    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        IProgressStyle progressStyle;
        MutableComponent text;
        String maxText;
        String curText;
        long max;
        long cur;
        IElementHelper helper;
        IEnergyHandler storage;
        BlockEntity blockEntity = accessor.getBlockEntity();
        if (blockEntity == null) {
            return;
        }
        if (Minecraft.m_91087_().f_91074_ == null) {
            return;
        }
        if (config.get(JadePlugin.EU) && (storage = (IEnergyHandler)blockEntity.getCapability(TesseractCaps.ENERGY_HANDLER_CAPABILITY).orElse(null)) != null && (!accessor.isServerConnected() || accessor.getServerData().m_128441_("jadeEU"))) {
            helper = tooltip.getElementHelper();
            if (accessor.isServerConnected()) {
                cur = accessor.getServerData().m_128454_("jadeEU");
                max = accessor.getServerData().m_128454_("jadeMaxEU");
            } else {
                cur = storage.getEnergy();
                max = storage.getCapacity();
            }
            curText = ChatFormatting.WHITE + this.humanReadableNumber(cur, "EU", Minecraft.m_91087_().f_91074_.m_6047_()) + ChatFormatting.GRAY;
            maxText = this.humanReadableNumber(max, "EU", Minecraft.m_91087_().f_91074_.m_6047_());
            text = new TranslatableComponent("jade.fe", new Object[]{curText, maxText}).m_130940_(ChatFormatting.WHITE);
            progressStyle = helper.progressStyle().color(-16711681, -16737895);
            tooltip.add(helper.progress((float)cur / (float)max, (Component)text, progressStyle, helper.borderStyle()).tag(JadePlugin.EU));
        }
        if (config.get(JadePlugin.HU) && (storage = (IHeatHandler)blockEntity.getCapability(TesseractCaps.HEAT_CAPABILITY).orElse(null)) != null && (!accessor.isServerConnected() || accessor.getServerData().m_128441_("jadeHU"))) {
            helper = tooltip.getElementHelper();
            if (accessor.isServerConnected()) {
                cur = accessor.getServerData().m_128454_("jadeHU");
                max = accessor.getServerData().m_128454_("jadeMaxHU");
            } else {
                cur = storage.getHeat();
                max = storage.getHeatCap();
            }
            curText = ChatFormatting.WHITE + this.humanReadableNumber(cur, "HU", Minecraft.m_91087_().f_91074_.m_6047_()) + ChatFormatting.GRAY;
            maxText = this.humanReadableNumber(max, "HU", Minecraft.m_91087_().f_91074_.m_6047_());
            text = new TranslatableComponent("jade.fe", new Object[]{curText, maxText}).m_130940_(ChatFormatting.WHITE);
            progressStyle = helper.progressStyle().color(-65536, -10092544);
            tooltip.add(helper.progress((float)cur / (float)max, (Component)text, progressStyle, helper.borderStyle()).tag(JadePlugin.HU));
        }
    }

    private String humanReadableNumber(double number, String unit, boolean shift) {
        return shift ? number + unit : VanillaPlugin.getDisplayHelper().humanReadableNumber(number, unit, false);
    }

    public void appendServerData(CompoundTag compoundTag, ServerPlayer serverPlayer, Level level, BlockEntity blockEntity, boolean b) {
        IHeatHandler heatHandler;
        IEnergyHandler handler = (IEnergyHandler)blockEntity.getCapability(TesseractCaps.ENERGY_HANDLER_CAPABILITY).orElse(null);
        if (handler != null) {
            compoundTag.m_128356_("jadeEU", handler.getEnergy());
            compoundTag.m_128356_("jadeMaxEU", handler.getCapacity());
        }
        if ((heatHandler = (IHeatHandler)blockEntity.getCapability(TesseractCaps.HEAT_CAPABILITY).orElse(null)) != null) {
            compoundTag.m_128356_("jadeHU", (long)heatHandler.getHeat());
            compoundTag.m_128356_("jadeMaxHU", (long)heatHandler.getHeatCap());
        }
    }
}

