/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.gui.widget;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.gtreimagined.gtlib.gui.ButtonOverlay;
import org.gtreimagined.gtlib.gui.GuiInstance;
import org.gtreimagined.gtlib.gui.IGuiElement;
import org.gtreimagined.gtlib.gui.Widget;
import org.gtreimagined.gtlib.gui.event.GuiEvents;
import org.gtreimagined.gtlib.gui.event.IGuiEvent;
import org.gtreimagined.gtlib.gui.widget.WidgetSupplier;
import org.gtreimagined.gtlib.util.Utils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ButtonWidget
extends Widget {
    static int backgroundCenter = -7631989;
    static int backgroundBlackEdge = -13158601;
    static int backgroundWhiteEdge = -1;
    @NotNull
    protected final ButtonOverlay body;
    @Nullable
    protected String tooltipKey;
    protected Consumer<ButtonWidget> onPress;
    protected boolean pressed = false;
    protected boolean renderBackground = false;

    public ButtonWidget(GuiInstance instance, IGuiElement parent, @NotNull ButtonOverlay body, @Nullable Consumer<ButtonWidget> onPress) {
        super(instance, parent);
        this.body = body;
        this.onPress = onPress;
    }

    protected void setClick(Consumer<ButtonWidget> clicker) {
        this.onPress = clicker;
    }

    public ButtonWidget setTooltipKey(@Nullable String tooltipKey) {
        this.tooltipKey = tooltipKey;
        return this;
    }

    public ButtonWidget setRenderBackground(boolean renderBackground) {
        this.renderBackground = renderBackground;
        return this;
    }

    @Override
    public void onRelease(double mouseX, double mouseY) {
        this.pressed = false;
        super.onRelease(mouseX, mouseY);
    }

    @Override
    public void onClick(double mouseX, double mouseY, int button) {
        if (button != 0) {
            return;
        }
        this.pressed = true;
        super.onClick(mouseX, mouseY, button);
        if (this.onPress != null) {
            if (this.gui.handler.isRemote()) {
                this.clientClick();
            }
            this.onPress.accept(this);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void clientClick() {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
    }

    @Override
    public void mouseOver(PoseStack stack, double mouseX, double mouseY, float partialTicks) {
        super.mouseOver(stack, mouseX, mouseY, partialTicks);
        if (this.getTooltipKey() != null) {
            this.renderTooltip(stack, (Component)Utils.translatable(this.getTooltipKey(), new Object[0]), mouseX, mouseY);
        }
    }

    protected String getTooltipKey() {
        return this.tooltipKey;
    }

    @Override
    public void render(PoseStack matrixStack, double mouseX, double mouseY, float partialTicks) {
        if (this.renderBackground) {
            int x = this.realX();
            int y = this.realY();
            this.fillGradient(matrixStack, x, y, this.getW(), this.getH(), backgroundCenter, backgroundCenter);
            this.fillGradient(matrixStack, x + this.getW(), y - 1, 1, 1, backgroundCenter, backgroundCenter);
            this.fillGradient(matrixStack, x - 1, y + this.getH(), 1, 1, backgroundCenter, backgroundCenter);
            this.fillGradient(matrixStack, x - 1, y - 1, this.getW() + 1, 1, backgroundWhiteEdge, backgroundWhiteEdge);
            this.fillGradient(matrixStack, x - 1, y, 1, this.getH(), backgroundWhiteEdge, backgroundWhiteEdge);
            this.fillGradient(matrixStack, x, y + this.getH(), this.getW() + 1, 1, backgroundBlackEdge, backgroundBlackEdge);
            this.fillGradient(matrixStack, x + this.getW(), y, 1, this.getH(), backgroundBlackEdge, backgroundBlackEdge);
        }
        this.renderButtonBody(matrixStack, mouseX, mouseY, partialTicks);
    }

    protected void renderButtonBody(PoseStack matrixStack, double mouseX, double mouseY, float partialTicks) {
        int xTex = 0;
        int yTex = 0;
        if (this.getBody().isChangedOnHovered() && this.isInside(mouseX, mouseY)) {
            yTex += this.getBody().getH();
        }
        this.drawTexture(matrixStack, this.getBody().getTexture(), this.realX(), this.realY(), xTex, yTex, this.getBody().getW(), this.getBody().getH(), this.getBody().getW(), this.getBody().getH() * (this.getBody().isChangedOnHovered() ? 2 : 1));
    }

    protected ButtonOverlay getBody() {
        return this.body;
    }

    public static WidgetSupplier build(ButtonOverlay body, IGuiEvent.IGuiEventFactory ev, int id, boolean renderBackground) {
        return ButtonWidget.builder((a, b) -> new ButtonWidget((GuiInstance)a, (IGuiElement)b, body, but -> but.gui.sendPacket(but.gui.handler.createGuiPacket(new GuiEvents.GuiEvent(ev, Screen.m_96638_() ? 1 : 0, id)))).setRenderBackground(renderBackground)).clientSide();
    }

    public static WidgetSupplier build(ButtonOverlay body, IGuiEvent.IGuiEventFactory ev, int id, boolean renderBackground, String tooltipKey) {
        return ButtonWidget.builder((a, b) -> new ButtonWidget((GuiInstance)a, (IGuiElement)b, body, but -> but.gui.sendPacket(but.gui.handler.createGuiPacket(new GuiEvents.GuiEvent(ev, Screen.m_96638_() ? 1 : 0, id)))).setRenderBackground(renderBackground).setTooltipKey(tooltipKey)).clientSide();
    }
}

