/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.datagen.providers;

import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectRBTreeMap;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import net.devtech.arrp.json.lang.JLang;
import net.minecraft.Util;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;
import org.apache.commons.lang3.StringUtils;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.Ref;
import org.gtreimagined.gtlib.block.BlockDimensionMarker;
import org.gtreimagined.gtlib.block.BlockFrame;
import org.gtreimagined.gtlib.block.BlockStone;
import org.gtreimagined.gtlib.block.BlockStoneSlab;
import org.gtreimagined.gtlib.block.BlockStoneStair;
import org.gtreimagined.gtlib.block.BlockStoneWall;
import org.gtreimagined.gtlib.block.BlockStorage;
import org.gtreimagined.gtlib.block.BlockSurfaceRock;
import org.gtreimagined.gtlib.cover.CoverFactory;
import org.gtreimagined.gtlib.data.GTMaterialTypes;
import org.gtreimagined.gtlib.datagen.GTLibDynamics;
import org.gtreimagined.gtlib.datagen.IGTLibProvider;
import org.gtreimagined.gtlib.fluid.GTFluid;
import org.gtreimagined.gtlib.item.ItemBasic;
import org.gtreimagined.gtlib.item.ItemStoneCover;
import org.gtreimagined.gtlib.machine.Tier;
import org.gtreimagined.gtlib.machine.types.BasicMultiMachine;
import org.gtreimagined.gtlib.machine.types.Machine;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.material.MaterialItem;
import org.gtreimagined.gtlib.material.MaterialType;
import org.gtreimagined.gtlib.material.MaterialTypeBlock;
import org.gtreimagined.gtlib.material.MaterialTypeItem;
import org.gtreimagined.gtlib.ore.BlockOre;
import org.gtreimagined.gtlib.ore.BlockOreStone;
import org.gtreimagined.gtlib.ore.CobbleStoneType;
import org.gtreimagined.gtlib.ore.StoneType;
import org.gtreimagined.gtlib.pipe.BlockItemPipe;
import org.gtreimagined.gtlib.pipe.BlockPipe;
import org.gtreimagined.gtlib.pipe.types.Cable;
import org.gtreimagined.gtlib.pipe.types.PipeType;
import org.gtreimagined.gtlib.recipe.map.RecipeMap;
import org.gtreimagined.gtlib.registration.IGTObject;
import org.gtreimagined.gtlib.tool.IGTArmor;
import org.gtreimagined.gtlib.tool.IGTTool;
import org.gtreimagined.gtlib.util.Utils;

public class GTLanguageProvider
implements DataProvider,
IGTLibProvider {
    private final String providerDomain;
    private final String providerName;
    private final String locale;
    private final Object2ObjectMap<String, String> data = new Object2ObjectRBTreeMap();
    private static final Object2ObjectMap<String, Object2ObjectMap<String, Object2ObjectMap<String, String>>> GLOBAL_DATA = new Object2ObjectRBTreeMap();

    public GTLanguageProvider(String providerDomain, String providerName, String locale) {
        this.providerDomain = providerDomain;
        this.providerName = providerName;
        this.locale = locale;
    }

    @Override
    public final void run() {
        this.addTranslations();
        ((Object2ObjectMap)GLOBAL_DATA.computeIfAbsent((Object)this.providerDomain, d -> new Object2ObjectRBTreeMap())).merge((Object)this.locale, this.data, (oldV, newV) -> {
            oldV.putAll((Map)newV);
            return oldV;
        });
    }

    @Override
    public final void onCompletion() {
        this.overrides();
    }

    public static void postCompletion() {
        GLOBAL_DATA.forEach((domain, map) -> map.forEach((locale, data) -> {
            JLang lang = JLang.lang();
            data.forEach((arg_0, arg_1) -> ((JLang)lang).entry(arg_0, arg_1));
            GTLibDynamics.DYNAMIC_RESOURCE_PACK.addLang(new ResourceLocation(domain, locale), lang);
        }));
    }

    public void m_6865_(HashCache cache) throws IOException {
    }

    protected void addTranslations() {
        if (this.locale.startsWith("en")) {
            this.english(this.providerDomain, this.locale);
        }
        if (this.providerDomain.equals("gtlib")) {
            this.processGTLibTranslations();
        }
    }

    private String tryComponent(String lang, IGTObject object, Supplier<String> otherwise) {
        String component = object.getLang(lang);
        if (component != null) {
            return component;
        }
        return otherwise.get();
    }

    protected void overrides() {
    }

    protected void english(String domain, String locale) {
        GTAPI.all(ItemBasic.class, domain).forEach(i -> {
            this.add((Item)i, Utils.lowerUnderscoreToUpperSpaced(i.getId()));
            if (!i.getTooltip().isEmpty()) {
                this.add("tooltip." + i.getDomain() + "." + i.getId().replace("/", "."), i.getTooltip());
            }
        });
        GTAPI.all(Machine.class, domain).forEach(i -> {
            String lang = i.getLang(locale);
            if (!(i instanceof BasicMultiMachine) || i.getTiers().size() > 1) {
                lang = lang.concat(" (%s)");
            }
            if (!i.hasTierSpecificLang()) {
                this.add("machine." + i.getId(), lang);
            }
            List<Tier> tiers = i.getTiers();
            String finalLang = lang;
            tiers.forEach(t -> {
                String langCopy = finalLang;
                if (t == Tier.NONE) {
                    langCopy = langCopy.replace(" (%s)", "");
                }
                if (i.hasTierSpecificLang()) {
                    this.add("machine." + i.getId() + "." + t.getId(), langCopy);
                }
                this.add(i.getBlockState((Tier)t), langCopy.replace("%s", t.getId().toUpperCase(Locale.ROOT)));
                if (i instanceof BasicMultiMachine) {
                    this.add(i.getDomain() + ".ponder." + i.getIdFromTier((Tier)t) + ".header", langCopy.replace("%s", t.getId().toUpperCase(Locale.ROOT)).concat(" Multiblock"));
                }
            });
        });
        GTAPI.all(CoverFactory.class, domain).forEach(c -> this.add("cover." + domain + "." + c.getId(), Utils.lowerUnderscoreToUpperSpaced(c.getId())));
        GTAPI.all(Enchantment.class, domain, (en, d, i) -> this.add("enchantment." + d + "." + i, Utils.lowerUnderscoreToUpperSpaced(i)));
        GTAPI.all(BlockDimensionMarker.class, domain).forEach(i -> this.add((Block)i, Utils.lowerUnderscoreToUpperSpaced(i.getDimension())));
        if (domain.equals("gtlib")) {
            GTAPI.all(IGTTool.class, t -> {
                String customName;
                String string = customName = t.getGTToolType().getCustomName().isEmpty() ? Utils.getLocalizedType(t.getGTToolType()) : t.getGTToolType().getCustomName();
                if (t.getGTToolType().isPowered()) {
                    String defaultName = Utils.getLocalizedType(t.getGTToolType());
                    this.add(t.getItem().m_5524_(), Utils.lowerUnderscoreToUpperSpacedRotated(t.getId()).replace(defaultName, customName));
                } else if (t.getGTToolType().isSimple()) {
                    this.add(t.getItem().m_5524_(), Utils.getLocalizedType(t.getPrimaryMaterial(t.getItem().m_7968_())) + " " + customName);
                } else {
                    this.add(t.getItem().m_5524_(), customName);
                }
            });
            GTAPI.all(BlockPipe.class).forEach(s -> {
                BlockItemPipe itemPipe;
                Object str = s.getSize().getId();
                if (((String)str).equals("vtiny")) {
                    str = "very_tiny";
                }
                if (s.getType() instanceof Cable) {
                    str = s.getSize().getCableThickness() + "x";
                }
                if (s instanceof BlockItemPipe && (itemPipe = (BlockItemPipe)s).isRestricted()) {
                    str = "restrictive_" + (String)str;
                }
                String prefix = ((String)str).contains("_") ? Utils.lowerUnderscoreToUpperSpaced((String)str) : ((String)str).substring(0, 1).toUpperCase() + ((String)str).substring(1);
                this.add((Block)s, StringUtils.join((Object[])new String[]{prefix, " ", Utils.getLocalizedType(((PipeType)s.getType()).getMaterial()), " ", Utils.lowerUnderscoreToUpperSpaced(((PipeType)s.getType()).getType())}));
            });
            GTAPI.all(Material.class).forEach(m -> this.add("material.".concat(m.getId()), Utils.getLocalizedType(m)));
            GTAPI.all(BlockOre.class, o -> {
                String nativeSuffix;
                String string = nativeSuffix = o.getMaterial().getElement() != null ? "Native " : "";
                if (o.getOreType() == GTMaterialTypes.ORE) {
                    this.add((Block)o, String.join((CharSequence)"", Utils.getLocalizeStoneType(o.getStoneType()) + " ", nativeSuffix, Utils.getLocalizedType(o.getMaterial()), " Ore"));
                } else {
                    this.add((Block)o, String.join((CharSequence)"", "Small ", Utils.getLocalizeStoneType(o.getStoneType()) + " ", nativeSuffix, Utils.getLocalizedType(o.getMaterial()), " Ore"));
                }
            });
            GTAPI.all(BlockOreStone.class, o -> this.add((Block)o, Utils.getLocalizedType(o.getMaterial())));
            GTAPI.all(BlockStone.class).forEach(s -> {
                Object localized = Utils.getLocalizedType(s);
                if (s.getSuffix().contains("mossy")) {
                    localized = "Mossy " + ((String)localized).replace(" Mossy", "");
                }
                if (s.getSuffix().contains("chiseled")) {
                    localized = "Chiseled " + ((String)localized).replace(" Chiseled", "");
                }
                if (s.getSuffix().contains("cracked")) {
                    localized = "Cracked " + ((String)localized).replace(" Cracked", "");
                }
                if (s.getSuffix().contains("smooth")) {
                    localized = "Polished " + ((String)localized).replace(" Smooth", "");
                }
                this.add((Block)s, (String)localized);
            });
            GTAPI.all(ItemStoneCover.class).forEach(i -> {
                Object localized = Utils.getLocalizedType(i);
                if (i.getSuffix().contains("mossy")) {
                    localized = "Mossy " + ((String)localized).replace(" Mossy", "");
                }
                if (i.getSuffix().contains("chiseled")) {
                    localized = "Chiseled " + ((String)localized).replace(" Chiseled", "");
                }
                if (i.getSuffix().contains("cracked")) {
                    localized = "Cracked " + ((String)localized).replace(" Cracked", "");
                }
                if (i.getSuffix().contains("smooth")) {
                    localized = "Polished " + ((String)localized).replace(" Smooth", "");
                }
                this.override(i.m_5524_(), (String)localized);
            });
            GTAPI.all(BlockStoneSlab.class).forEach(s -> {
                Object localized = Utils.getLocalizedType(s);
                if (s.getSuffix().contains("mossy")) {
                    localized = "Mossy " + ((String)localized).replace(" Mossy", "");
                }
                if (s.getSuffix().contains("chiseled")) {
                    localized = "Chiseled " + ((String)localized).replace(" Chiseled", "");
                }
                if (s.getSuffix().contains("cracked")) {
                    localized = "Cracked " + ((String)localized).replace(" Cracked", "");
                }
                if (s.getSuffix().contains("smooth")) {
                    localized = "Polished " + ((String)localized).replace(" Smooth", "");
                }
                this.add((Block)s, (String)localized);
            });
            GTAPI.all(BlockStoneStair.class).forEach(s -> {
                Object localized = Utils.getLocalizedType(s);
                if (s.getSuffix().contains("mossy")) {
                    localized = "Mossy " + ((String)localized).replace(" Mossy", "");
                }
                if (s.getSuffix().contains("chiseled")) {
                    localized = "Chiseled " + ((String)localized).replace(" Chiseled", "");
                }
                if (s.getSuffix().contains("cracked")) {
                    localized = "Cracked " + ((String)localized).replace(" Cracked", "");
                }
                if (s.getSuffix().contains("smooth")) {
                    localized = "Polished " + ((String)localized).replace(" Smooth", "");
                }
                this.add((Block)s, (String)localized);
            });
            GTAPI.all(BlockStoneWall.class).forEach(s -> {
                Object localized = Utils.getLocalizedType(s);
                if (s.getSuffix().contains("mossy")) {
                    localized = "Mossy " + ((String)localized).replace(" Mossy", "");
                }
                if (s.getSuffix().contains("chiseled")) {
                    localized = "Chiseled " + ((String)localized).replace(" Chiseled", "");
                }
                if (s.getSuffix().contains("cracked")) {
                    localized = "Cracked " + ((String)localized).replace(" Cracked", "");
                }
                if (s.getSuffix().contains("smooth")) {
                    localized = "Polished " + ((String)localized).replace(" Smooth", "");
                }
                this.add((Block)s, (String)localized);
            });
            GTAPI.all(GTFluid.class).forEach(s -> {
                this.add(Util.m_137492_((String)"fluid_type", (ResourceLocation)s.getLoc()), this.tryComponent(locale, (IGTObject)s, () -> Utils.lowerUnderscoreToUpperSpaced(s.getId())));
                Item bucket = GTAPI.get(Item.class, s.getId() + "_bucket", "antimatter_shared");
                if (bucket != null) {
                    this.add(bucket, this.tryComponent(locale, (IGTObject)s, () -> Utils.lowerUnderscoreToUpperSpaced(s.getId())) + " Bucket");
                }
            });
            GTAPI.all(BlockStorage.class).forEach(block -> {
                MaterialType<?> type = block.getType();
                this.add((Block)block, type.getLang().apply(block.getMaterial()));
            });
            GTAPI.all(BlockFrame.class).forEach(block -> this.add((Block)block, String.join((CharSequence)"", Utils.getLocalizedType(block.getMaterial()), " ", Utils.getLocalizedType(block.getType()))));
            GTAPI.all(BlockSurfaceRock.class).forEach(b -> this.add((Block)b, String.join((CharSequence)"", new CharSequence[]{Utils.getLocalizeStoneType(b.getStoneType()) + " ", b.getMaterial() == Material.NULL ? "" : Utils.getLocalizedType(b.getMaterial()) + " ", "Surface Rock"})));
            GTAPI.all(MaterialType.class).stream().filter(t -> t instanceof MaterialTypeBlock || t instanceof MaterialTypeItem).forEach(t -> {
                if (t.get() instanceof MaterialTypeBlock.IOreGetter) {
                    GTAPI.all(StoneType.class, s -> this.add("gtlib.rei.group." + t.getId() + "." + s.getId(), Utils.getLocalizedType(s) + " " + Utils.getLocalizedType(t) + "s"));
                    if (t != GTMaterialTypes.BEARING_ROCK) {
                        return;
                    }
                }
                String[] split = Utils.getLocalizedMaterialType(t);
                if (t == GTMaterialTypes.CRUSHED) {
                    this.add("gtlib.rei.group." + t.getId(), String.join((CharSequence)"", "Crushed Ores"));
                } else if (t == GTMaterialTypes.CRUSHED_PURIFIED) {
                    this.add("gtlib.rei.group." + t.getId(), String.join((CharSequence)"", "Purified Ores"));
                } else if (t == GTMaterialTypes.CRUSHED_REFINED) {
                    this.add("gtlib.rei.group." + t.getId(), String.join((CharSequence)"", "Refined Ores"));
                } else if (t == GTMaterialTypes.RAW_ORE_BLOCK) {
                    this.add("gtlib.rei.group." + t.getId(), "Raw Ore Blocks");
                } else if (t == GTMaterialTypes.ITEM_CASING) {
                    this.add("gtlib.rei.group." + t.getId(), String.join((CharSequence)"", "Item Casings"));
                } else if (split.length > 1) {
                    if (t.isSplitName()) {
                        this.add("gtlib.rei.group." + t.getId(), String.join((CharSequence)"", split[0], " ", split[1], "s"));
                    } else {
                        this.add("gtlib.rei.group." + t.getId(), String.join((CharSequence)"", split[1], " ", split[0], "s"));
                    }
                } else {
                    this.add("gtlib.rei.group." + t.getId(), split[0] + "s");
                }
            });
            GTAPI.all(StoneType.class, s -> {
                if (s instanceof CobbleStoneType) {
                    this.add("gtlib.rei.group." + s.getId(), Utils.getLocalizedType(s));
                }
            });
            GTAPI.all(MaterialItem.class).forEach(item -> {
                MaterialType<?> type = item.getType();
                this.add((Item)item, type.getLang().apply(item.getMaterial()));
            });
            GTAPI.all(IGTArmor.class, t -> this.add(t.getItem().m_5524_(), Utils.getLocalizedType(t.getMat()) + " " + Utils.getLocalizedType(t.getGTArmorType())));
            this.customTranslations();
            this.pipeTranslations();
            GTAPI.all(RecipeMap.class, t -> {
                String id = "jei.category." + t.getId();
                this.add(id, Utils.lowerUnderscoreToUpperSpaced(t.getId().replace('.', '_'), 0));
            });
        }
    }

    protected void customTranslations() {
        this.add("machine.voltage.in", "Voltage IN");
        this.add("machine.voltage.out", "Voltage OUT");
        this.add("machine.power.capacity", "Capacity");
        this.add("machine.tank.capacity", "Stores %sMb of fluid");
        this.add("machine.structure.form", "Right click structure to form it after placing blocks");
        this.add("machine.generator.efficiency", "Efficiency: %s");
        this.add("generic.amp", "Amperage");
        this.add("gtlib.tooltip.formula", "Hold Shift to show formula.");
        this.add("gtlib.tooltip.chemical_formula", "Formula: %s");
        this.add("gtlib.tooltip.mass", "Mass: %s");
        this.add("gtlib.tooltip.atomic_number", "Atomic Number: %s");
        this.add("gtlib.tooltip.more", "Hold Shift to show more information.");
        this.add("gtlib.tooltip.stacks", "Stacks");
        this.add("gtlib.tooltip.fluid.amount", "Amount: %s");
        this.add("gtlib.tooltip.fluid.temp", "Temperature: %s K");
        this.add("gtlib.tooltip.fluid.liquid", "State: Liquid");
        this.add("gtlib.tooltip.fluid.gas", "State: Gas");
        this.add("gtlib.tooltip.cover.output.no_input", "Inputs blocked");
        this.add("gtlib.tooltip.cover.output.allow_input", "Inputs allowed");
        this.add("gtlib.tooltip.cover.covers_on_item", "Covers");
        this.add("gtlib.tooltip.cover.stack", "%s: %s");
        this.add("gtlib.tooltip.valid_structure", "Structure Formed");
        this.add("gtlib.tooltip.invalid_structure", "Structure Invalid");
        this.add("generic.tier", "Tier");
        this.add("generic.voltage", "Voltage");
        this.add("generic.loss", "Loss (per block)");
        this.add("message.discharge.on", "Discharge enabled");
        this.add("message.discharge.off", "Discharge disabled");
        this.add("item.charge", "Energy");
        this.add("item.reusable", "Reusable");
        this.add("item.amps", "Warning: outputs %s amps");
        this.add("gtlib.tooltip.battery.tier", "%s Battery");
        this.add("gtlib.tooltip.material_primary", "Primary Material: %s");
        this.add("gtlib.tooltip.material_secondary", "Secondary Material: %s");
        this.add("gtlib.tooltip.dye_color", "Handle Color: %s");
        this.add("gtlib.tooltip.tool_speed", "Mining Speed: %s");
        this.add("gtlib.tooltip.crafting_uses", "Crafting Uses: %s");
        this.add("gtlib.tooltip.mining_level", "Mining Level %s");
        this.add("gtlib.tooltip.durability", "Durability: %s");
        this.add("gtlib.gui.show_recipes", "Show Recipes");
        this.add("gtlib.tooltip.bandwidth", "Bandwidth: %s");
        this.add("gtlib.tooltip.capacity", "Capacity: %s");
        this.add("gtlib.tooltip.stepsize", "Stepsize: %s");
        this.add("gtlib.tooltip.gas_proof", "Can handle Gases");
        this.add("gtlib.tooltip.acid_proof", "Can handle Acids");
        this.add("gtlib.tooltip.max_temperature", "Max Temperature");
        this.add("gtlib.tooltip.energy", "Energy");
        this.add("gtlib.tooltip.heat_capacity", "Heat capacity");
        this.add("gtlib.tooltip.heat_capacity_total", "Heat capacity (total)");
        this.add("gtlib.tooltip.material_modid", "Material added by: %s");
        this.add("gtlib.tooltip.occurrence", "Indicates occurrence of %s");
        this.add("gtlib.tooltip.behaviour.aoe_enabled", "%s Enabled");
        this.add("gtlib.tooltip.behaviour.aoe_disabled", "%s Disabled");
        this.add("gtlib.tooltip.behaviour.aoe_right_click", "Sneak right click to Enable/Disable %s");
        this.add("gtlib.tooltip.io_widget.fluid", "Fluid Auto-Output");
        this.add("gtlib.tooltip.io_widget.item", "Item Auto-Output");
        this.add("gtlib.behaviour.3x3", "3x3 Mining");
        this.add("gtlib.behaviour.1x0x2", "1x2 Mining");
        this.add("jei.category.gtlib.veins", "Vein Stats");
        this.add("jei.category.gtlib.small_ores", "Small Ore Stats");
    }

    private final void pipeTranslations() {
        this.add("gtlib.pipe.cable.info", "Transmits amperages between machines. \nFor each cable the cable loss is subtracted \nfrom the total energy.");
        this.add("gtlib.pipe.item.info", "Transfers up to capacity item stacks per tick. \nThis capacity is per stack and not per item transferred.");
        this.add("gtlib.pipe.fluid.info", "Transfers up to capacity per tick, with a buffer of 20 times the capacity. \nEvery tick the capacity of the pipe is replenished, up to 20 times. \nThis allows large transfers at once, but \ncontinuous transfers is limited by capacity");
        this.add("gtlib.pipe.item.input_side.enabled", "Accepting from selected Side enabled");
        this.add("gtlib.pipe.item.output_side.enabled", "Emitting to selected Side enabled");
        this.add("gtlib.pipe.item.input_side.disabled", "Accepting from selected Side disabled");
        this.add("gtlib.pipe.item.output_side.disabled", "Emitting to selected Side disabled");
    }

    private void processGTLibTranslations() {
        this.add(Ref.TAB_BLOCKS, "GT Blocks");
        this.add(Ref.TAB_ITEMS, "GT Items");
        this.add(Ref.TAB_MACHINES, "GT Machines");
        this.add(Ref.TAB_MATERIALS, "GT Material Items");
        this.add(Ref.TAB_TOOLS, "GT Tools");
    }

    public String m_6055_() {
        return this.providerName;
    }

    public void addBlock(Supplier<? extends Block> key, String name) {
        this.add(key.get(), name);
    }

    public void add(Block key, String name) {
        this.add(key.m_7705_(), name);
    }

    public void addItem(Supplier<? extends Item> key, String name) {
        this.add(key.get(), name);
    }

    public void add(Item key, String name) {
        this.add(key.m_5524_(), name);
    }

    public void addItemStack(Supplier<ItemStack> key, String name) {
        this.add(key.get(), name);
    }

    public void add(ItemStack key, String name) {
        this.add(key.m_41778_(), name);
    }

    public void addEnchantment(Supplier<? extends Enchantment> key, String name) {
        this.add(key.get(), name);
    }

    public void add(Enchantment key, String name) {
        this.add(key.m_44704_(), name);
    }

    public void addEffect(Supplier<? extends MobEffect> key, String name) {
        this.add(key.get(), name);
    }

    public void add(MobEffect key, String name) {
        this.add(key.m_19481_(), name);
    }

    public void addEntityType(Supplier<? extends EntityType<?>> key, String name) {
        this.add(key.get(), name);
    }

    public void add(EntityType<?> key, String name) {
        this.add(key.m_20675_(), name);
    }

    public void addItemGroup(Supplier<? extends CreativeModeTab> key, String name) {
        this.add(key.get(), name);
    }

    public void add(CreativeModeTab key, String name) {
        this.add("itemGroup." + key.m_40783_(), name);
    }

    public void add(String key, String value) {
        try {
            if (this.data.containsKey((Object)key)) {
                throw new IllegalStateException("Duplicate translation key " + key + ", Name is " + value);
            }
            this.data.put((Object)key, (Object)value);
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
    }

    public void override(String key, String value) {
        this.data.put((Object)key, (Object)value);
    }

    public void override(Machine<?> i, Tier t, String value) {
        if (i.hasTierSpecificLang()) {
            this.override("machine." + i.getId() + "." + t.getId(), value);
        }
        this.override(i.getBlockState(t).m_7705_(), value);
        if (i instanceof BasicMultiMachine) {
            this.override(i.getDomain() + ".ponder." + i.getIdFromTier(t) + ".header", value.concat(" Multiblock"));
        }
    }

    public void override(String domain, String key, String value) {
        Map map;
        Map mapMap = (Map)GLOBAL_DATA.get((Object)domain);
        if (mapMap != null && (map = (Map)mapMap.get(this.locale)) != null) {
            map.put(key, value);
        }
    }
}

