/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.datagen.providers;

import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.block.BlockFrame;
import org.gtreimagined.gtlib.block.BlockStone;
import org.gtreimagined.gtlib.block.BlockStoneSlab;
import org.gtreimagined.gtlib.block.BlockStoneStair;
import org.gtreimagined.gtlib.block.BlockStoneWall;
import org.gtreimagined.gtlib.block.BlockStorage;
import org.gtreimagined.gtlib.data.GTLibTags;
import org.gtreimagined.gtlib.data.GTMaterialTypes;
import org.gtreimagined.gtlib.data.GTTools;
import org.gtreimagined.gtlib.data.VanillaStoneTypes;
import org.gtreimagined.gtlib.datagen.providers.GTTagProvider;
import org.gtreimagined.gtlib.fluid.GTFluid;
import org.gtreimagined.gtlib.machine.BlockMachine;
import org.gtreimagined.gtlib.machine.BlockMultiMachine;
import org.gtreimagined.gtlib.material.MaterialTags;
import org.gtreimagined.gtlib.ore.BlockOre;
import org.gtreimagined.gtlib.ore.BlockOreStone;
import org.gtreimagined.gtlib.pipe.BlockItemPipe;
import org.gtreimagined.gtlib.pipe.BlockPipe;
import org.gtreimagined.gtlib.pipe.types.PipeType;
import org.gtreimagined.gtlib.util.TagUtils;
import org.gtreimagined.gtlib.util.Utils;

public class GTBlockTagProvider
extends GTTagProvider<Block> {
    private final boolean replace;

    public GTBlockTagProvider(String providerDomain, String providerName, boolean replace) {
        super(Registry.f_122824_, providerDomain, providerName, "blocks");
        this.replace = replace;
    }

    @Override
    protected void processTags(String domain) {
        if (domain.equals("gtlib")) {
            GTAPI.all(BlockOre.class, o -> {
                TagKey<Block> tagKey;
                int stoneMiningLevel;
                int maxLevel;
                int oreMiningLevel;
                this.tag(TagUtils.getForgelikeBlockTag(String.join((CharSequence)"", Utils.getConventionalStoneType(o.getStoneType()), "_", Utils.getConventionalMaterialType(o.getOreType()), "/", o.getMaterial().getId()))).add((Block)o).replace(this.replace);
                this.tag(TagUtils.getForgelikeBlockTag(String.join((CharSequence)"", Utils.getConventionalMaterialType(o.getOreType()), "/", o.getMaterial().getId()))).add((Block)o).replace(this.replace);
                this.tag(TagUtils.getForgelikeBlockTag(Utils.getConventionalMaterialType(o.getOreType()))).add((Block)o).replace(this.replace);
                this.tag(TagUtils.getForgelikeBlockTag(Utils.getConventionalStoneType(o.getStoneType()) + "_" + Utils.getConventionalMaterialType(o.getOreType()))).add((Block)o).replace(this.replace);
                if (o.getStoneType() == VanillaStoneTypes.SAND || o.getStoneType() == VanillaStoneTypes.SAND_RED || o.getStoneType() == VanillaStoneTypes.GRAVEL) {
                    this.tag(BlockTags.f_144283_).add((BlockOre)o).replace(this.replace);
                } else {
                    this.tag(BlockTags.f_144282_).add((BlockOre)o).replace(this.replace);
                }
                int n = oreMiningLevel = o.getMaterial().has(MaterialTags.MINING_LEVEL) ? MaterialTags.MINING_LEVEL.getInt(o.getMaterial()) : 0;
                if (o.getOreType() == GTMaterialTypes.ORE_SMALL && oreMiningLevel > 0) {
                    --oreMiningLevel;
                }
                if ((maxLevel = Math.max(oreMiningLevel, stoneMiningLevel = o.getStoneType().getHarvestLevel())) > 0 && (tagKey = this.fromMiningLevel(maxLevel)) != null) {
                    this.tag(tagKey).add((Block)o);
                }
                if (o.getOreType() == GTMaterialTypes.ORE) {
                    this.tag(TagUtils.getForgelikeBlockTag("ores")).add((Block)o);
                }
            });
            GTAPI.all(BlockStone.class, s -> {
                TagKey<Block> tagKey;
                if (s.getSuffix().isEmpty()) {
                    this.tag(TagUtils.getForgelikeBlockTag("stone")).add((Block)s);
                } else if (s.getSuffix().equals("cobble")) {
                    this.tag(TagUtils.getForgelikeBlockTag("cobblestone")).add((Block)s);
                } else if (s.getSuffix().contains("bricks")) {
                    this.tag(BlockTags.f_13091_).add((BlockStone)s);
                }
                this.tag(BlockTags.f_144282_).add((BlockStone)s).replace(this.replace);
                int stoneMiningLevel = s.getType().getHarvestLevel();
                if (stoneMiningLevel > 0 && (tagKey = this.fromMiningLevel(stoneMiningLevel)) != null) {
                    this.tag(tagKey).add((Block)s);
                }
                this.tag(TagUtils.getBlockTag(new ResourceLocation("gtlib", "blocks/".concat(s.getId())))).add((Block)s).replace(this.replace);
            });
            GTAPI.all(BlockStoneWall.class, b -> {
                this.tag(BlockTags.f_144282_).add((BlockStoneWall)b).replace(this.replace);
                this.tag(BlockTags.f_13032_).add((BlockStoneWall)b);
            });
            GTAPI.all(BlockStoneSlab.class, b -> {
                this.tag(BlockTags.f_144282_).add((BlockStoneSlab)b).replace(this.replace);
                this.tag(BlockTags.f_13031_).add((BlockStoneSlab)b);
            });
            GTAPI.all(BlockStoneStair.class, b -> {
                this.tag(BlockTags.f_144282_).add((BlockStoneStair)b).replace(this.replace);
                this.tag(BlockTags.f_13030_).add((BlockStoneStair)b);
            });
            GTAPI.all(BlockOreStone.class, s -> {
                String id = "ore_stones/" + s.getMaterial().getId();
                this.tag(BlockTags.f_144282_).add((BlockOreStone)s).replace(this.replace);
                this.tag(TagUtils.getForgelikeBlockTag("ores")).add((Block)s);
                this.tag(TagUtils.getForgelikeBlockTag(id)).add((Block)s);
            });
            GTAPI.all(BlockStorage.class, block -> {
                this.tag(block.getType().getTag()).add(block).replace(this.replace);
                String name = String.join((CharSequence)"", block.getType().getTag().f_203868_().m_135815_(), "/", block.getType().getId().equals("raw_ore_block") ? "raw_" : "", block.getMaterial().getId());
                if (block.getMaterial().has(MaterialTags.MINED_WITH_AXE)) {
                    this.tag(GTTools.AXE.getToolType()).add((Block)block);
                } else {
                    this.tag(GTTools.PICKAXE.getToolType()).add((Block)block);
                }
                this.tag(TagUtils.getForgelikeBlockTag(name)).add((Block)block);
            });
            GTAPI.all(BlockFrame.class, block -> {
                this.tag(block.getType().getTag()).add(block).replace(this.replace);
                String name = String.join((CharSequence)"", block.getType().getTag().f_203868_().m_135815_(), "/", block.getType().getId().equals("raw_ore_block") ? "raw_" : "", block.getMaterial().getId());
                if (block.getMaterial().has(MaterialTags.MINED_WITH_AXE)) {
                    this.tag(GTTools.AXE.getToolType()).add((Block)block);
                } else {
                    this.tag(GTTools.WRENCH.getToolType()).add((Block)block).replace(this.replace);
                }
                this.tag(TagUtils.getForgelikeBlockTag(name)).add((Block)block);
            });
            GTAPI.all(BlockItemPipe.class, pipe -> this.tag(TagUtils.getBlockTag(new ResourceLocation("gtlib", "item_pipe"))).add((Block)pipe));
            GTAPI.all(BlockPipe.class, pipe -> {
                this.tag(pipe.getToolType().getToolType()).add((Block)pipe);
                if (((PipeType)pipe.getType()).getMaterial().has(MaterialTags.MINED_WITH_AXE)) {
                    this.tag(GTTools.AXE.getToolType()).add((Block)pipe);
                }
            });
            GTAPI.all(BlockMachine.class, pipe -> this.tag(pipe.getType().getToolTag()).add((Block)pipe));
            GTAPI.all(BlockMultiMachine.class, pipe -> this.tag(pipe.getType().getToolTag()).add((Block)pipe));
            GTAPI.all(GTFluid.class, f -> this.tag(TagUtils.getBlockTag(new ResourceLocation("replaceable"))).add((Block)f.getFluidBlock()));
        }
    }

    public TagKey<Block> fromMiningLevel(int miningLevels) {
        return switch (miningLevels) {
            case 1 -> BlockTags.f_144286_;
            case 2 -> BlockTags.f_144285_;
            case 3 -> BlockTags.f_144284_;
            case 4 -> GTLibTags.NEEDS_NETHERITE_TOOL;
            case 5 -> GTLibTags.NEEDS_ADAMANTIUM_TOOL;
            default -> null;
        };
    }
}

