/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.capability.machine;

import java.util.Arrays;
import org.gtreimagined.gtlib.blockentity.multi.BlockEntityMultiMachine;
import org.gtreimagined.gtlib.capability.machine.MachineEnergyHandler;
import org.gtreimagined.gtlib.machine.Tier;
import tesseract.api.gt.IEnergyHandler;
import tesseract.api.gt.IGTNode;

public class MultiMachineEnergyHandler<T extends BlockEntityMultiMachine<T>>
extends MachineEnergyHandler<T> {
    protected MachineEnergyHandler<?>[] inputs;
    protected MachineEnergyHandler<?>[] outputs;
    protected long cachedCapacity;

    public MultiMachineEnergyHandler(T tile, long energy, long capacity, int voltage_in, int voltage_out, int amperage_in, int amperage_out) {
        super(tile, energy, capacity, voltage_in, voltage_out, amperage_in, amperage_out);
    }

    public MultiMachineEnergyHandler(T tile) {
        super(tile, 0L, 0L, 0L, 0L, 0, 0);
    }

    public void onStructureBuild() {
        this.cacheInputs();
        this.cacheOutputs();
        IEnergyHandler handler = this.anyHandler();
        if (handler != null) {
            this.voltageIn = handler.getInputVoltage();
            this.voltageOut = handler.getOutputVoltage();
        }
        this.cachedCapacity = super.getCapacity() + Arrays.stream(this.inputs).mapToLong(IGTNode::getCapacity).sum() + Arrays.stream(this.outputs).mapToLong(IGTNode::getCapacity).sum();
    }

    private void cacheInputs() {
        this.inputs = (MachineEnergyHandler[])((BlockEntityMultiMachine)this.tile).getComponentsByHandlerId(this.inputComponentString()).stream().filter(t -> t.getEnergyHandler().isPresent()).map(t -> t.getEnergyHandler().get()).toArray(MachineEnergyHandler[]::new);
    }

    protected String inputComponentString() {
        return "energy";
    }

    protected String outputComponentString() {
        return "dynamo";
    }

    private void cacheOutputs() {
        this.outputs = (MachineEnergyHandler[])((BlockEntityMultiMachine)this.tile).getComponentsByHandlerId(this.outputComponentString()).stream().filter(t -> t.getEnergyHandler().isPresent()).map(t -> t.getEnergyHandler().get()).toArray(MachineEnergyHandler[]::new);
    }

    private IEnergyHandler anyHandler() {
        if (this.inputs != null && this.inputs.length > 0) {
            return this.inputs[0];
        }
        if (this.outputs != null && this.outputs.length > 0) {
            return this.outputs[0];
        }
        return null;
    }

    public void invalidate() {
        this.cachedCapacity = super.getCapacity();
        this.inputs = null;
        this.outputs = null;
    }

    @Override
    public long getEnergy() {
        return super.getEnergy() + (this.inputs == null ? 0L : Arrays.stream(this.inputs).mapToLong(IGTNode::getEnergy).sum()) + (this.outputs == null ? 0L : Arrays.stream(this.outputs).mapToLong(IGTNode::getEnergy).sum());
    }

    @Override
    public long getCapacity() {
        return this.cachedCapacity;
    }

    @Override
    public boolean canOutput() {
        return false;
    }

    @Override
    public boolean canInput() {
        return false;
    }

    @Override
    public long extractEu(long voltage, boolean simulate) {
        if (this.inputs == null) {
            return 0L;
        }
        long extracted = 0L;
        long toExtract = Math.min(voltage, this.getEnergy());
        for (MachineEnergyHandler<?> handler : this.inputs) {
            long extract = handler.extractEu(toExtract, simulate);
            extracted += extract;
            if ((toExtract -= extract) <= 0L) break;
        }
        if (toExtract > 0L) {
            extracted += super.extractEu(voltage, simulate);
        }
        return extracted;
    }

    @Override
    public long insertInternal(long voltage, boolean simulate) {
        if (this.outputs == null) {
            return 0L;
        }
        long inserted = 0L;
        long toInsert = Math.min(voltage, this.getCapacity() - this.getEnergy());
        for (MachineEnergyHandler<?> handler : this.outputs) {
            long insert = handler.insertInternal(toInsert, simulate);
            inserted += insert;
            if ((toInsert -= insert) <= 0L) break;
        }
        if (toInsert > 0L) {
            inserted += super.insertInternal(voltage, simulate);
        }
        return inserted;
    }

    public Tier getAccumulatedPower() {
        Tier tier;
        if (this.inputs == null) {
            return Tier.ULV;
        }
        long voltage = Arrays.stream(this.inputs).mapToLong(t -> t.getInputVoltage() * t.getInputAmperage()).sum();
        return voltage >= (tier = Tier.getTier(voltage)).getVoltage() ? tier : Tier.getTier(voltage >> 2);
    }
}

