/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.capability.machine;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import org.gtreimagined.gtlib.Ref;
import org.gtreimagined.gtlib.blockentity.BlockEntityBase;
import org.gtreimagined.gtlib.blockentity.BlockEntityMachine;
import org.gtreimagined.gtlib.capability.Dispatch;
import org.gtreimagined.gtlib.capability.IMachineHandler;
import org.gtreimagined.gtlib.capability.machine.MachineItemHandler;
import org.gtreimagined.gtlib.capability.rf.FEHandler;
import org.gtreimagined.gtlib.gui.SlotType;
import org.gtreimagined.gtlib.machine.event.IMachineEvent;
import org.gtreimagined.gtlib.machine.event.MachineEvent;
import org.gtreimagined.gtlib.util.Utils;
import tesseract.api.fe.IFENode;

public class MachineFEHandler<T extends BlockEntityMachine<T>>
extends FEHandler
implements IMachineHandler,
Dispatch.Sided<IFENode> {
    protected final T tile;
    protected List<IEnergyStorage> cachedItems = new ObjectArrayList();
    protected int offsetInsert = 0;
    protected int offsetExtract = 0;

    public MachineFEHandler(T tile, int energy, int capacity, int maxIn, int maxOut) {
        super(energy, capacity, maxIn, maxOut);
        this.tile = tile;
    }

    public MachineFEHandler(T tile, int capacity, boolean isGenerator) {
        this(tile, 0, capacity, isGenerator ? 0 : (int)((BlockEntityMachine)tile).getMachineTier().getVoltage(), isGenerator ? (int)((BlockEntityMachine)tile).getMachineTier().getVoltage() : 0);
    }

    public void onUpdate() {
        for (Direction dir : Ref.DIRS) {
            BlockEntity tile;
            if (!this.canExtract(dir) || (tile = ((BlockEntityBase)((Object)this.tile)).getCachedBlockEntity(dir)) == null) continue;
            Optional handle = tile.getCapability(CapabilityEnergy.ENERGY, dir.m_122424_()).resolve();
            handle.ifPresent(eh -> Utils.transferEnergy((IEnergyStorage)this, eh));
        }
    }

    @Override
    public void init() {
        this.cachedItems = (List)((BlockEntityMachine)this.tile).itemHandler.map(MachineItemHandler::getFEChargeableItems).map(ImmutableList::copyOf).orElse(ImmutableList.of());
    }

    @Override
    public int getMaxEnergyStored() {
        if (this.canChargeItem()) {
            return super.getMaxEnergyStored() + (this.cachedItems != null ? this.cachedItems.stream().mapToInt(IEnergyStorage::getMaxEnergyStored).sum() : 0);
        }
        return super.getMaxEnergyStored();
    }

    @Override
    public int receiveEnergy(int maxAmount, boolean simulate) {
        int inserted = super.receiveEnergy(maxAmount, simulate);
        int i = this.offsetInsert;
        for (int j = 0; j < this.cachedItems.size(); ++j) {
            int insert;
            IEnergyStorage handler = this.cachedItems.get(i);
            if (handler.canReceive() && (insert = handler.receiveEnergy(maxAmount, simulate)) > 0) {
                this.offsetInsert = (this.offsetInsert + 1) % this.cachedItems.size();
                inserted += insert;
            }
            i = i == this.cachedItems.size() - 1 ? 0 : i + 1;
        }
        if (inserted > 0) {
            ((BlockEntityMachine)this.tile).onMachineEvent(MachineEvent.ENERGY_INPUTTED, new Object[0]);
        }
        return inserted;
    }

    @Override
    public int extractEnergy(int maxAmount, boolean simulate) {
        int extracted = super.extractEnergy(maxAmount, simulate);
        int i = this.offsetInsert;
        for (int j = 0; j < this.cachedItems.size(); ++j) {
            int extract;
            IEnergyStorage handler = this.cachedItems.get(i);
            if (handler.canExtract() && (extract = handler.extractEnergy(maxAmount, simulate)) > 0) {
                this.offsetInsert = (this.offsetInsert + 1) % this.cachedItems.size();
                extracted += extract;
            }
            i = i == this.cachedItems.size() - 1 ? 0 : i + 1;
        }
        if (extracted > 0) {
            ((BlockEntityMachine)this.tile).onMachineEvent(MachineEvent.ENERGY_INPUTTED, new Object[0]);
        }
        return extracted;
    }

    @Override
    public int getEnergyStored() {
        if (this.canChargeItem()) {
            return super.getEnergyStored() + (this.cachedItems != null ? this.cachedItems.stream().mapToInt(IEnergyStorage::getEnergyStored).sum() : 0);
        }
        return super.getEnergyStored();
    }

    @Override
    public boolean canReceive(Direction direction) {
        return super.canReceive(direction) && (((BlockEntityMachine)this.tile).getFacing() != direction || ((BlockEntityMachine)this.tile).getMachineType().allowsFrontIO());
    }

    public boolean canChargeItem() {
        return true;
    }

    @Override
    public void onMachineEvent(IMachineEvent event, Object ... data) {
        if (event == SlotType.ENERGY) {
            ((BlockEntityMachine)this.tile).itemHandler.ifPresent(h -> {
                this.cachedItems = h.getFEChargeableItems();
                this.offsetInsert = 0;
                this.offsetExtract = 0;
            });
        }
    }

    @Override
    public LazyOptional<? extends IFENode> forSide(Direction side) {
        return LazyOptional.of(() -> this);
    }

    @Override
    public LazyOptional<? extends IFENode> forNullSide() {
        return LazyOptional.of(() -> this);
    }

    public void onRemove() {
    }
}

