/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.blockentity.pipe;

import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.gtreimagined.gtlib.blockentity.IPreTickTile;
import org.gtreimagined.gtlib.blockentity.pipe.BlockEntityPipe;
import org.gtreimagined.gtlib.blockentity.pipe.IFluidPipe;
import org.gtreimagined.gtlib.capability.Dispatch;
import org.gtreimagined.gtlib.capability.FluidHandler;
import org.gtreimagined.gtlib.capability.fluid.FluidHandlerNullSideWrapper;
import org.gtreimagined.gtlib.capability.fluid.PipeFluidHandlerSidedWrapper;
import org.gtreimagined.gtlib.capability.pipe.PipeFluidHandler;
import org.gtreimagined.gtlib.cover.ICover;
import org.gtreimagined.gtlib.data.GTLibTags;
import org.gtreimagined.gtlib.pipe.PipeSize;
import org.gtreimagined.gtlib.pipe.TileTicker;
import org.gtreimagined.gtlib.pipe.types.FluidPipe;
import org.gtreimagined.gtlib.util.CodeUtils;
import org.gtreimagined.gtlib.util.FluidUtils;
import org.gtreimagined.gtlib.util.Utils;

public class BlockEntityFluidPipe<T extends FluidPipe<T>>
extends BlockEntityPipe<T>
implements IFluidPipe,
IPreTickTile,
Dispatch.Sided<IFluidHandler> {
    protected Optional<PipeFluidHandler> fluidHandler;
    public static byte[] SBIT = new byte[]{1, 2, 4, 8, 16, 32};
    byte[] lastSide;
    int transferredAmount = 0;
    long mTemperature = 293L;
    private boolean mHasToAddTimer = true;

    public BlockEntityFluidPipe(T type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        int count = this.getPipeSize() == PipeSize.QUADRUPLE ? 4 : (this.getPipeSize() == PipeSize.NONUPLE ? 9 : 1);
        this.fluidHandler = Optional.of(new PipeFluidHandler(this, ((FluidPipe)type).getPressure(this.getPipeSize()) * 2, count, 0));
        this.pipeCapHolder.set(() -> this);
        this.lastSide = new byte[count];
        for (int i = 0; i < count; ++i) {
            this.lastSide[i] = 0;
        }
    }

    @Override
    public void onLoad() {
        super.onLoad();
        if (BlockEntityFluidPipe.even(this.m_58899_().m_123341_(), this.m_58899_().m_123342_(), this.m_58899_().m_123343_())) {
            TileTicker.SERVER_TICK_PRE.add(this);
        } else {
            TileTicker.SERVER_TICK_PR2.add(this);
        }
    }

    @Override
    public void onBlockUpdate(BlockPos neighbour) {
        super.onBlockUpdate(neighbour);
    }

    @Override
    protected void register() {
    }

    @Override
    protected boolean deregister() {
        return true;
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("fl")) {
            this.fluidHandler.ifPresent(t -> t.deserialize(tag.m_128469_("fl")));
        }
        ListTag tags = tag.m_128437_("lastSide", 1);
        for (int i = 0; i < tags.size(); ++i) {
            this.lastSide[i] = ((ByteTag)tags.get(i)).m_7063_();
        }
        this.mTemperature = tag.m_128454_("temperature");
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        this.fluidHandler.ifPresent(t -> tag.m_128365_("fl", (Tag)t.serialize(new CompoundTag())));
        ListTag tags = new ListTag();
        for (int i = 0; i < this.lastSide.length; ++i) {
            tags.add((Object)ByteTag.m_128266_((byte)this.lastSide[i]));
        }
        tag.m_128365_("lastSide", (Tag)tags);
        tag.m_128356_("temperature", this.mTemperature);
    }

    @Override
    public void onRemove() {
        this.fluidHandler.ifPresent(FluidHandler::onRemove);
        TileTicker.SERVER_TICK_PR2.remove(this);
        TileTicker.SERVER_TICK_PRE.remove(this);
        super.onRemove();
    }

    @Override
    public boolean isGasProof() {
        return ((FluidPipe)this.getPipeType()).isGasProof();
    }

    @Override
    public int getCapacity() {
        return 1;
    }

    @Override
    public long getPressure() {
        return ((FluidPipe)this.getPipeType()).getPressure(this.getPipeSize());
    }

    @Override
    public int getTemperature() {
        return ((FluidPipe)this.getPipeType()).getMaxTemperature();
    }

    public long getCurrentTemperature() {
        return this.fluidHandler.map(f -> {
            long currentTemp = -1L;
            for (int i = 0; i < f.getTanks(); ++i) {
                FluidStack fluid = f.getFluidInTank(i);
                if (fluid.isEmpty()) continue;
                currentTemp = Math.max((long)FluidUtils.getFluidTemperature(fluid.getFluid()), currentTemp);
            }
            return currentTemp == -1L ? 293L : currentTemp;
        }).orElse(293L);
    }

    @Override
    public boolean connects(Direction direction) {
        return this.canConnect(direction.m_122411_());
    }

    @Override
    public boolean validate(Direction dir) {
        if (!super.validate(dir)) {
            return false;
        }
        return FluidUtils.getFluidHandler(this.f_58857_, this.m_58899_().m_142300_(dir), this.getCachedBlockEntity(dir), dir.m_122424_()).isPresent();
    }

    public void setLastSide(Direction lastSide, int tank) {
        int n = tank;
        this.lastSide[n] = (byte)(this.lastSide[n] | SBIT[lastSide.m_122411_()]);
    }

    @Override
    protected void serverTick(Level level, BlockPos pos, BlockState state) {
        super.serverTick(level, pos, state);
    }

    @Override
    public void onUnregisterPre() {
        this.mHasToAddTimer = true;
    }

    @Override
    public void onServerTickPre(Level level, BlockPos pos, boolean aFirst) {
        this.transferredAmount = 0;
        IFluidHandler[] adjacentFluidHandlers = new IFluidHandler[6];
        PipeFluidHandler pipeFluidHandler = this.fluidHandler.orElse(null);
        if (pipeFluidHandler == null) {
            return;
        }
        for (Direction tSide : Direction.values()) {
            if (!this.connects(tSide)) continue;
            FluidUtils.getFluidHandler(level, pos.m_142300_(tSide), this.getCachedBlockEntity(tSide), tSide.m_122424_()).ifPresent(fluidHandler1 -> {
                adjacentFluidHandlers[tSide.m_122411_()] = fluidHandler1;
            });
        }
        boolean tCheckTemperature = true;
        for (int i = 0; i < pipeFluidHandler.getInputTanks().getTanks(); ++i) {
            FluidTank tTank = pipeFluidHandler.getInputTanks().getTank(i);
            FluidStack tFluid = tTank.getFluid();
            if (!tFluid.isEmpty()) {
                this.mTemperature = tCheckTemperature ? (long)FluidUtils.getFluidTemperature(tFluid.getFluid()) : Math.max(this.mTemperature, (long)FluidUtils.getFluidTemperature(tFluid.getFluid()));
                tCheckTemperature = false;
                if (!this.isGasProof() && FluidUtils.isFluidGaseous(tFluid.getFluid())) {
                    this.transferredAmount += tTank.drain(Utils.ca(8, tFluid), IFluidHandler.FluidAction.EXECUTE).getAmount();
                    level.m_5594_(null, pos, SoundEvents.f_11937_, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                if (!((FluidPipe)this.type).isAcidProof() && tFluid.getFluid().m_205067_(GTLibTags.ACID)) {
                    this.transferredAmount += tTank.drain(Utils.ca(16, tFluid), IFluidHandler.FluidAction.EXECUTE).getAmount();
                    level.m_5594_(null, pos, SoundEvents.f_11937_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    if (level.f_46441_.nextInt(100) == 0) {
                        tTank.drain(tTank.getFluidAmount(), IFluidHandler.FluidAction.EXECUTE);
                        level.m_7731_(pos, Blocks.f_50083_.m_49966_(), 3);
                        return;
                    }
                }
            }
            if (this.mTemperature > (long)this.getTemperature()) {
                BlockEntityFluidPipe.burn(level, pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
                if (level.f_46441_.nextInt(100) == 0) {
                    tTank.drain(tTank.getFluidAmount(), IFluidHandler.FluidAction.EXECUTE);
                    level.m_7731_(pos, Blocks.f_50083_.m_49966_(), 3);
                    return;
                }
            }
            if (!tTank.getFluid().isEmpty()) {
                this.distribute(level, tTank, i, adjacentFluidHandlers);
            }
            this.lastSide[i] = 0;
        }
    }

    public void distribute(Level level, FluidTank aTank, int i, IFluidHandler[] fluidHandlers) {
        if (aTank.isEmpty()) {
            return;
        }
        ArrayList<Pair<Direction, IFluidHandler>> tTanks = new ArrayList<Pair<Direction, IFluidHandler>>();
        ArrayList<Pair<Direction, IFluidHandler>> tPipes = new ArrayList<Pair<Direction, IFluidHandler>>();
        int tAmount = aTank.getFluid().getAmount();
        int tTargetCount = 1;
        for (Direction tSide : Direction.values()) {
            int insert;
            ICover cover;
            if ((this.lastSide[i] & SBIT[tSide.m_122411_()]) != 0 || !this.connects(tSide) || !(cover = this.coverHandler.map(c -> c.get(tSide)).orElse(ICover.empty)).isEmpty() && (cover.blocksOutput(IFluidHandler.class, tSide) || cover.onTransfer(aTank.getFluid().copy(), false, true)) || fluidHandlers[tSide.m_122411_()] == null || (insert = fluidHandlers[tSide.m_122411_()].fill(Utils.ca(Integer.MAX_VALUE, aTank.getFluid()), IFluidHandler.FluidAction.SIMULATE)) <= 0) continue;
            if (fluidHandlers[tSide.m_122411_()] instanceof PipeFluidHandlerSidedWrapper) {
                tPipes.add(level.f_46441_.nextInt(tPipes.size() + 1), (Pair<Direction, IFluidHandler>)Pair.of((Object)tSide, (Object)fluidHandlers[tSide.m_122411_()]));
            } else {
                tTanks.add(level.f_46441_.nextInt(tTanks.size() + 1), (Pair<Direction, IFluidHandler>)Pair.of((Object)tSide, (Object)fluidHandlers[tSide.m_122411_()]));
            }
            ++tTargetCount;
        }
        if (tTargetCount <= 1) {
            return;
        }
        tAmount = CodeUtils.bindInt(CodeUtils.divup(tAmount, tTargetCount));
        this.distributeToTanks(aTank, tPipes, tAmount);
        if (aTank.isEmpty()) {
            return;
        }
        this.distributeToTanks(aTank, tTanks, tAmount);
        if (aTank.isEmpty()) {
            return;
        }
        if (tPipes.isEmpty()) {
            return;
        }
        tAmount = (aTank.getFluid().getAmount() - aTank.getCapacity() / 2) / tPipes.size();
        if (tAmount > 0) {
            this.distributeToTanks(aTank, tPipes, tAmount);
        }
    }

    public void distributeToTanks(FluidTank aTank, List<Pair<Direction, IFluidHandler>> tTanks, int tAmount) {
        for (Pair<Direction, IFluidHandler> tPipe : tTanks) {
            FluidStack resource = aTank.getFluid().copy();
            int oldAmount = resource.getAmount();
            ICover cover = this.coverHandler.map(c -> c.get((Direction)tPipe.key())).orElse(ICover.empty);
            if (!cover.isEmpty() && cover.onTransfer(resource, false, false)) {
                int amountDrained = oldAmount - resource.getAmount();
                if (amountDrained <= 0) continue;
                this.transferredAmount += aTank.drain(amountDrained, IFluidHandler.FluidAction.EXECUTE).getAmount();
                continue;
            }
            this.transferredAmount += aTank.drain(Utils.ca(((IFluidHandler)tPipe.value()).fill(Utils.ca(tAmount, aTank.getFluid()), IFluidHandler.FluidAction.EXECUTE), aTank.getFluid()), IFluidHandler.FluidAction.EXECUTE).getAmount();
        }
    }

    public static void burn(Level aWorld, int aX, int aY, int aZ) {
        BlockPos pos = new BlockPos(aX, aY, aZ);
        for (Direction tSide : Direction.values()) {
            BlockEntityFluidPipe.fire(aWorld, pos.m_142300_(tSide), false);
        }
    }

    public static boolean fire(Level aWorld, BlockPos pos, boolean aCheckFlammability) {
        BlockState tBlock = aWorld.m_8055_(pos);
        if (tBlock.m_60767_() == Material.f_76307_ || tBlock.m_60767_() == Material.f_76309_) {
            return false;
        }
        if (tBlock.m_60767_() == Material.f_76299_ || tBlock.m_60812_((BlockGetter)aWorld, pos).m_83281_()) {
            if (tBlock.getFlammability((BlockGetter)aWorld, pos, Direction.NORTH) > 0) {
                return aWorld.m_7731_(pos, Blocks.f_50083_.m_49966_(), 3);
            }
            if (aCheckFlammability) {
                for (Direction tSide : Direction.values()) {
                    BlockState tAdjacent = aWorld.m_8055_(pos.m_142300_(tSide));
                    if (tAdjacent.m_60734_() == Blocks.f_50087_ || tAdjacent.m_60734_() == Blocks.f_50325_) {
                        return aWorld.m_7731_(pos, Blocks.f_50083_.m_49966_(), 3);
                    }
                    if (tAdjacent.getFlammability((BlockGetter)aWorld, pos.m_142300_(tSide), tSide.m_122424_()) <= 0) continue;
                    return aWorld.m_7731_(pos, Blocks.f_50083_.m_49966_(), 3);
                }
            } else {
                return aWorld.m_7731_(pos, Blocks.f_50083_.m_49966_(), 3);
            }
        }
        return false;
    }

    @Override
    public Class<?> getCapClass() {
        return IFluidHandler.class;
    }

    @Override
    public LazyOptional<? extends IFluidHandler> forSide(Direction side) {
        if (this.fluidHandler.isEmpty()) {
            return LazyOptional.empty();
        }
        if (side == null) {
            return LazyOptional.of(() -> new FluidHandlerNullSideWrapper(this.fluidHandler.get()));
        }
        return LazyOptional.of(() -> new PipeFluidHandlerSidedWrapper(this.fluidHandler.get(), this, side));
    }

    @Override
    public LazyOptional<? extends IFluidHandler> forNullSide() {
        return this.forSide(null);
    }

    @Override
    public List<String> getInfo(boolean simple) {
        List<String> list = super.getInfo(simple);
        this.fluidHandler.ifPresent(t -> {
            for (int i = 0; i < t.getTanks(); ++i) {
                FluidStack stack = t.getFluidInTank(i);
                list.add("Tank " + (i + 1) + ": " + (String)(stack.isEmpty() ? "Empty" : stack.getAmount() + "mb of " + FluidUtils.getFluidDisplayName(stack).getString()));
            }
        });
        if (simple) {
            return list;
        }
        list.add("Pressure: " + ((FluidPipe)this.getPipeType()).getPressure(this.getPipeSize()));
        list.add("Max temperature: " + ((FluidPipe)this.getPipeType()).getMaxTemperature());
        list.add(((FluidPipe)this.getPipeType()).isGasProof() ? "Gas proof." : "Cannot handle gas.");
        list.add(((FluidPipe)this.getPipeType()).isAcidProof() ? "Acid proof." : "Cannot handle acids.");
        return list;
    }

    public static boolean even(int ... aCoords) {
        int i = 0;
        for (int tCoord : aCoords) {
            if (tCoord % 2 != 0) continue;
            ++i;
        }
        return i % 2 == 0;
    }

    @Generated
    public Optional<PipeFluidHandler> getFluidHandler() {
        return this.fluidHandler;
    }
}

