/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.blockentity;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.gtreimagined.gtlib.GTLib;
import org.gtreimagined.gtlib.blockentity.IExtendingBlockEntity;
import org.gtreimagined.gtlib.capability.Dispatch;
import org.gtreimagined.gtlib.util.Utils;
import org.jetbrains.annotations.Nullable;

public abstract class BlockEntityBase<T extends BlockEntityBase<T>>
extends BlockEntity {
    protected final Dispatch dispatch;
    protected final Cache<Direction, BlockEntity> blockEntityCache = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build();

    public BlockEntityBase(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.dispatch = new Dispatch();
    }

    public BlockEntity getCachedBlockEntity(Direction side) {
        if (this.f_58857_ == null) {
            return null;
        }
        try {
            BlockEntity entity;
            if (!this.blockEntityCache.asMap().containsKey(side)) {
                entity = this.f_58857_.m_7702_(this.m_58899_().m_142300_(side));
                if (entity instanceof IExtendingBlockEntity) {
                    IExtendingBlockEntity extendingBlockEntity = (IExtendingBlockEntity)entity;
                    entity = extendingBlockEntity.getExtendedBlockEntity(side);
                }
                if (entity == null) {
                    return null;
                }
            } else {
                entity = null;
            }
            BlockEntity finalEntity = entity;
            return (BlockEntity)this.blockEntityCache.get((Object)side, () -> finalEntity);
        }
        catch (ExecutionException e) {
            GTLib.LOGGER.error((Object)e);
            return null;
        }
    }

    public void onBlockUpdate(BlockPos neighbor) {
        Direction facing = Utils.getOffsetFacing(this.m_58899_(), neighbor);
        if (facing != null) {
            this.blockEntityCache.invalidate((Object)facing);
        }
    }

    public void m_7651_() {
        super.m_7651_();
        this.onRemove();
    }

    public void onLoad() {
        super.onLoad();
    }

    public void onRemove() {
    }

    public boolean isClientSide() {
        return this.f_58857_.f_46443_;
    }

    public boolean isServerSide() {
        return !this.f_58857_.f_46443_;
    }

    public List<String> getInfo(boolean simple) {
        ObjectArrayList info = new ObjectArrayList();
        if (!simple) {
            info.add("Tile: " + ((Object)((Object)this)).getClass().getSimpleName());
        }
        return info;
    }

    public void sidedSync(boolean renderUpdate) {
        if (this.f_58859_) {
            return;
        }
        if (this.m_58904_() == null) {
            return;
        }
        if (!this.m_58904_().f_46443_) {
            this.m_6596_();
            Utils.markTileForNBTSync(this);
        } else if (renderUpdate) {
            Utils.markTileForRenderUpdate(this);
        }
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        CompoundTag compoundtag = pkt.m_131708_();
        if (compoundtag != null) {
            this.m_142466_(compoundtag);
        }
        this.sidedSync(true);
    }

    public static interface BlockEntitySupplier<T extends BlockEntity, U> {
        public T create(U var1, BlockPos var2, BlockState var3);
    }

    public static class BlockEntityGetter<T extends BlockEntity, U>
    implements BlockEntityType.BlockEntitySupplier<T> {
        private final U value;
        private final BlockEntitySupplier<T, U> supplier;

        public BlockEntityGetter(BlockEntitySupplier<T, U> supp, U value) {
            this.value = value;
            this.supplier = supp;
        }

        public T m_155267_(BlockPos p_155268_, BlockState p_155269_) {
            return this.supplier.create(this.value, p_155268_, p_155269_);
        }
    }
}

