/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.recipe;

import com.google.gson.JsonObject;
import java.util.List;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraftforge.fluids.FluidStack;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.recipe.IRecipeValidator;
import org.gtreimagined.gtlib.recipe.ingredient.FluidIngredient;
import org.gtreimagined.gtlib.recipe.map.RecipeMap;
import org.gtreimagined.gtlib.recipe.serializer.MachineRecipeSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IRecipe
extends Recipe<Container> {
    public boolean isValid();

    public void invalidate();

    public int getAmps();

    public void addOutputChances(int[] var1);

    public void addInputChances(int[] var1);

    public void setHidden(boolean var1);

    public void setFake(boolean var1);

    public void addTags(Set<String> var1);

    public boolean hasInputItems();

    public boolean hasOutputItems();

    public boolean hasInputFluids();

    public boolean hasOutputFluids();

    public boolean hasOutputChances();

    public boolean hasInputChances();

    public void setIds(ResourceLocation var1, String var2);

    public void setId(ResourceLocation var1);

    public void setMapId(String var1);

    public void sortInputItems();

    public List<Ingredient> getInputItems();

    public ItemStack[] getOutputItems();

    public ItemStack[] getOutputItems(boolean var1);

    public ItemStack[] getFlatOutputItems();

    public boolean hasSpecialIngredients();

    @NotNull
    public List<FluidIngredient> getInputFluids();

    @Nullable
    public FluidStack[] getOutputFluids();

    public int getDuration();

    public long getPower();

    @Nullable
    public int[] getOutputChances();

    @Nullable
    public int[] getInputChances();

    default public long getTotalPower() {
        return (long)this.getDuration() * this.getPower();
    }

    public int getSpecialValue();

    public boolean isHidden();

    public boolean isFake();

    public Set<String> getTags();

    public String getMapId();

    default public JsonObject toJson() {
        JsonObject json = new JsonObject();
        RecipeMap recipeMap = GTAPI.get(RecipeMap.class, this.getMapId());
        if (recipeMap != null) {
            recipeMap.getRecipeSerializer().toJson(json, this);
        } else {
            MachineRecipeSerializer.INSTANCE.toJson(json, this);
        }
        return json;
    }

    public List<IRecipeValidator> getValidators();
}

