/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.fluid;

import lombok.Generated;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.registration.IRegistryEntryProvider;
import org.gtreimagined.gtlib.registration.ISharedGTObject;

public class GTFluid
implements ISharedGTObject,
IRegistryEntryProvider {
    public static final ResourceLocation OVERLAY_TEXTURE = new ResourceLocation("block/water_overlay");
    public static final ResourceLocation LIQUID_STILL_TEXTURE = new ResourceLocation("gtlib", "block/liquid/still");
    public static final ResourceLocation LIQUID_FLOW_TEXTURE = new ResourceLocation("gtlib", "block/liquid/flow");
    public static final ResourceLocation LIQUID_HOT_STILL_TEXTURE = new ResourceLocation("gtlib", "block/liquid/hot_still");
    public static final ResourceLocation LIQUID_HOT_FLOW_TEXTURE = new ResourceLocation("gtlib", "block/liquid/hot_flow");
    public static final ResourceLocation GAS_TEXTURE = new ResourceLocation("gtlib", "block/liquid/gas");
    public static final ResourceLocation GAS_FLOW_TEXTURE = new ResourceLocation("gtlib", "block/liquid/gas");
    public static final ResourceLocation PLASMA_TEXTURE = new ResourceLocation("gtlib", "block/liquid/plasma");
    public static final ResourceLocation PLASMA_FLOW_TEXTURE = new ResourceLocation("gtlib", "block/liquid/plasma");
    private final String domain;
    private final String id;
    protected ForgeFlowingFluid.Properties fluidProperties;
    protected ForgeFlowingFluid.Source source;
    protected ForgeFlowingFluid.Flowing flowing;
    protected BlockBehaviour.Properties blockProperties;
    protected FluidAttributes attributes;
    protected LiquidBlock fluidBlock;
    protected Item containerItem = Items.f_41852_;

    public GTFluid(String domain, String id, FluidAttributes.Builder builder, BlockBehaviour.Properties blockProperties) {
        this.domain = domain;
        this.id = id;
        this.fluidProperties = new ForgeFlowingFluid.Properties(this::getFluid, this::getFlowingFluid, builder).bucket(this::getContainerItem).block(this::getFluidBlock);
        this.blockProperties = blockProperties;
        this.attributes = builder.translationKey(Util.m_137492_((String)"fluid_type", (ResourceLocation)this.getLoc())).build((Fluid)this.source);
    }

    public GTFluid(String domain, String id) {
        this(domain, id, GTFluid.getDefaultAttributesBuilder(), GTFluid.getDefaultBlockProperties());
    }

    public GTFluid(String domain, String id, FluidAttributes.Builder builder) {
        this(domain, id, builder, GTFluid.getDefaultBlockProperties());
    }

    public GTFluid(String domain, String id, ResourceLocation stillLoc, ResourceLocation flowLoc) {
        this(domain, id, FluidAttributes.builder((ResourceLocation)stillLoc, (ResourceLocation)flowLoc), GTFluid.getDefaultBlockProperties());
    }

    public GTFluid(String domain, String id, BlockBehaviour.Properties properties) {
        this(domain, id, GTFluid.getDefaultAttributesBuilder(), properties);
    }

    @Override
    public void onRegistryBuild(IForgeRegistry<?> registry) {
        if (registry == ForgeRegistries.ITEMS) {
            this.containerItem = new BucketItem(this::getFluid, new Item.Properties().m_41487_(1).m_41495_(Items.f_42446_).m_41491_(CreativeModeTab.f_40753_));
            GTAPI.register(Item.class, this.getId() + "_bucket", this.getDomain(), this.containerItem);
        } else if (registry == ForgeRegistries.BLOCKS) {
            this.source = new ForgeFlowingFluid.Source(this.fluidProperties);
            this.flowing = new ForgeFlowingFluid.Flowing(this.fluidProperties);
            this.fluidBlock = new LiquidBlock(this::getFluid, this.blockProperties);
            GTAPI.register(Block.class, "block_fluid_".concat(this.getId()), this.getDomain(), this.fluidBlock);
        } else if (registry == ForgeRegistries.FLUIDS) {
            GTAPI.register(Fluid.class, this.getId(), this.getDomain(), this.source);
            GTAPI.register(FlowingFluid.class, "flowing_".concat(this.getId()), this.getDomain(), this.flowing);
        }
    }

    public GTFluid source(ForgeFlowingFluid.Source source) {
        this.source = source;
        return this;
    }

    public GTFluid flowing(ForgeFlowingFluid.Flowing flowing) {
        this.flowing = flowing;
        return this;
    }

    public GTFluid flowingBlock(LiquidBlock fluidBlock) {
        this.fluidBlock = fluidBlock;
        return this;
    }

    public GTFluid containerItem(Item item) {
        this.containerItem = item;
        return this;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public ForgeFlowingFluid.Source getFluid() {
        return this.source;
    }

    public ForgeFlowingFluid.Flowing getFlowingFluid() {
        return this.flowing;
    }

    protected static BlockBehaviour.Properties getDefaultBlockProperties() {
        return BlockBehaviour.Properties.m_60939_((Material)Material.f_76305_).m_60978_(100.0f).m_60993_();
    }

    protected static FluidAttributes.Builder getDefaultAttributesBuilder() {
        return GTFluid.getDefaultAttributesBuilder(false);
    }

    protected static FluidAttributes.Builder getDefaultAttributesBuilder(boolean hot) {
        if (hot) {
            return FluidAttributes.builder((ResourceLocation)LIQUID_HOT_STILL_TEXTURE, (ResourceLocation)LIQUID_HOT_FLOW_TEXTURE).overlay(OVERLAY_TEXTURE).sound(SoundEvents.f_11783_, SoundEvents.f_11780_);
        }
        return FluidAttributes.builder((ResourceLocation)LIQUID_STILL_TEXTURE, (ResourceLocation)LIQUID_FLOW_TEXTURE).overlay(OVERLAY_TEXTURE).sound(SoundEvents.f_11781_, SoundEvents.f_11778_);
    }

    @Generated
    public BlockBehaviour.Properties getBlockProperties() {
        return this.blockProperties;
    }

    @Generated
    public FluidAttributes getAttributes() {
        return this.attributes;
    }

    @Generated
    public LiquidBlock getFluidBlock() {
        return this.fluidBlock;
    }

    @Generated
    public Item getContainerItem() {
        return this.containerItem;
    }
}

