/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.datagen;

import com.google.common.collect.Sets;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraftforge.fml.loading.FMLPaths;
import org.gtreimagined.gtlib.GTLibConfig;
import org.gtreimagined.gtlib.worldgen.IWorldgenObject;
import org.jetbrains.annotations.Nullable;

public class DynamicDataPack
implements PackResources {
    protected static final ObjectSet<String> SERVER_DOMAINS = new ObjectOpenHashSet();
    protected static final Map<ResourceLocation, JsonObject> DATA = new HashMap<ResourceLocation, JsonObject>();
    private final String name;

    public DynamicDataPack(String name, Collection<String> domains) {
        this.name = name;
        SERVER_DOMAINS.addAll(domains);
    }

    public static void clearServer() {
        DATA.clear();
    }

    public static void addWorldgenObject(IWorldgenObject<?> object) {
        Path parent = FMLPaths.CONFIGDIR.get().getParent().resolve("dumped/gtlib-dynamic-data/data");
        if (GTLibConfig.EXPORT_DEFAULT_DATA_AND_ASSETS.get()) {
            DynamicDataPack.writeJson(object.getLoc(), "gt_worldgen/" + object.getSubDirectory() + "/", parent, object.toJson());
        }
        DATA.put(DynamicDataPack.getWorldgenLoc(object.getLoc(), object.getSubDirectory()), object.toJson());
    }

    public static void addRecipe(FinishedRecipe recipe) {
        JsonObject recipeJson = recipe.m_125966_();
        Path parent = FMLPaths.CONFIGDIR.get().getParent().resolve("dumped/gtlib-dynamic-data/data");
        if (GTLibConfig.EXPORT_DEFAULT_DATA_AND_ASSETS.get()) {
            DynamicDataPack.writeJson(recipe.m_6445_(), "recipes", parent, recipeJson);
        }
        DATA.put(DynamicDataPack.getRecipeLoc(recipe.m_6445_()), recipeJson);
        if (recipe.m_5860_() != null) {
            JsonObject advancement = recipe.m_5860_();
            if (GTLibConfig.EXPORT_DEFAULT_DATA_AND_ASSETS.get()) {
                DynamicDataPack.writeJson(recipe.m_6448_(), "advancements", parent, advancement);
            }
            DATA.put(DynamicDataPack.getAdvancementLoc(Objects.requireNonNull(recipe.m_6448_())), advancement);
        }
    }

    private static void writeJson(ResourceLocation id, String subdir, Path parent, JsonObject json) {
        try {
            Path file = parent.resolve(id.m_135827_()).resolve(subdir).resolve(id.m_135815_() + ".json");
            Files.createDirectories(file.getParent(), new FileAttribute[0]);
            try (OutputStream output = Files.newOutputStream(file, new OpenOption[0]);){
                output.write(json.toString().getBytes());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addAdvancement(ResourceLocation loc, JsonObject obj) {
        ResourceLocation l = DynamicDataPack.getAdvancementLoc(loc);
        Map<ResourceLocation, JsonObject> map = DATA;
        synchronized (map) {
            DATA.put(l, obj);
        }
    }

    public InputStream m_8031_(PackType type, ResourceLocation location) throws IOException {
        if (type == PackType.SERVER_DATA) {
            if (DATA.containsKey(location)) {
                return new ByteArrayInputStream(DATA.get(location).toString().getBytes(StandardCharsets.UTF_8));
            }
            throw new FileNotFoundException("Can't find " + location + " " + this.m_8017_());
        }
        return new ByteArrayInputStream(new byte[0]);
    }

    public InputStream m_5542_(String fileName) {
        throw new UnsupportedOperationException("Dynamic Resource Pack cannot have root resources");
    }

    public boolean m_7211_(PackType type, ResourceLocation location) {
        if (type == PackType.CLIENT_RESOURCES) {
            return false;
        }
        return DATA.containsKey(location);
    }

    public Collection<ResourceLocation> m_7466_(PackType type, String namespace, String path, int maxDepth, Predicate<String> filter) {
        if (type == PackType.SERVER_DATA) {
            return DATA.keySet().stream().filter(loc -> loc.m_135815_().startsWith(path) && filter.test(loc.m_135815_())).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public Set<String> m_5698_(PackType type) {
        return type == PackType.SERVER_DATA ? SERVER_DOMAINS : Set.of();
    }

    public String m_8017_() {
        return this.name;
    }

    @Nullable
    public <T> T m_5550_(MetadataSectionSerializer<T> metaReader) {
        if (metaReader.m_7991_().equals("pack")) {
            JsonObject object = new JsonObject();
            object.addProperty("pack_format", (Number)9);
            object.addProperty("description", "runtime data pack");
            return (T)metaReader.m_6322_(object);
        }
        return (T)metaReader.m_6322_(new JsonObject());
    }

    public void close() {
    }

    public static ResourceLocation getRecipeLoc(ResourceLocation recipeId) {
        return new ResourceLocation(recipeId.m_135827_(), String.join((CharSequence)"", "recipes/", recipeId.m_135815_(), ".json"));
    }

    public static ResourceLocation getWorldgenLoc(ResourceLocation worldgenId, String subDirectory) {
        return new ResourceLocation(worldgenId.m_135827_(), String.join((CharSequence)"", "gt_worldgen/", subDirectory, "/", worldgenId.m_135815_(), ".json"));
    }

    public static ResourceLocation getAdvancementLoc(ResourceLocation advancementId) {
        return new ResourceLocation(advancementId.m_135827_(), String.join((CharSequence)"", "advancements/", advancementId.m_135815_(), ".json"));
    }

    public static ResourceLocation getTagLoc(String identifier, ResourceLocation tagId) {
        return new ResourceLocation(tagId.m_135827_(), String.join((CharSequence)"", "tags/", identifier, "/", tagId.m_135815_(), ".json"));
    }

    static {
        SERVER_DOMAINS.addAll((Collection)Sets.newHashSet((Object[])new String[]{"gtlib", "antimatter_shared", "minecraft", "forge", "c"}));
    }
}

