/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.capability.machine;

import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;
import org.gtreimagined.gtlib.blockentity.multi.BlockEntityMultiMachine;
import org.gtreimagined.gtlib.capability.FluidHandler;
import org.gtreimagined.gtlib.capability.IComponentHandler;
import org.gtreimagined.gtlib.capability.fluid.FluidTanks;
import org.gtreimagined.gtlib.capability.machine.MachineFluidHandler;

public class MultiMachineFluidHandler<T extends BlockEntityMultiMachine<T>>
extends MachineFluidHandler<T> {
    MachineFluidHandler<?>[] inputs = new MachineFluidHandler[0];
    MachineFluidHandler<?>[] outputs = new MachineFluidHandler[0];

    public MultiMachineFluidHandler(T tile) {
        super(tile);
        this.tanks.clear();
    }

    protected void cacheInputs() {
        this.inputs = (MachineFluidHandler[])((BlockEntityMultiMachine)this.tile).getComponentsByHandlerId(this.inputComponentString()).stream().map(IComponentHandler::getFluidHandler).map(Optional::get).sorted(this::compareInputHatches).toArray(MachineFluidHandler[]::new);
        this.tanks.put(FluidHandler.FluidDirection.INPUT, new FluidTanks(Arrays.stream(this.inputs).filter(t -> t.getInputTanks() != null).flatMap(t -> Arrays.stream(t.getInputTanks().getBackingTanks())).collect(Collectors.toList())));
    }

    protected int compareInputHatches(MachineFluidHandler<?> a, MachineFluidHandler<?> b) {
        return 0;
    }

    protected String inputComponentString() {
        return "fluid_input";
    }

    protected String outputComponentString() {
        return "fluid_output";
    }

    protected void cacheOutputs() {
        this.outputs = (MachineFluidHandler[])((BlockEntityMultiMachine)this.tile).getComponentsByHandlerId(this.outputComponentString()).stream().map(IComponentHandler::getFluidHandler).map(Optional::get).sorted(this::compareOutputHatches).toArray(MachineFluidHandler[]::new);
        this.tanks.put(FluidHandler.FluidDirection.OUTPUT, new FluidTanks(Arrays.stream(this.outputs).filter(t -> t.getOutputTanks() != null).flatMap(t -> Arrays.stream(t.getOutputTanks().getBackingTanks())).collect(Collectors.toList())));
    }

    protected int compareOutputHatches(MachineFluidHandler<?> a, MachineFluidHandler<?> b) {
        return 0;
    }

    public void invalidate() {
        this.tanks.clear();
        this.inputs = new MachineFluidHandler[0];
        this.outputs = new MachineFluidHandler[0];
    }

    public void onStructureBuild() {
        this.cacheInputs();
        this.cacheOutputs();
    }
}

