/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.capability.item;

import java.util.function.Predicate;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import org.gtreimagined.gtlib.capability.CoverHandler;
import org.gtreimagined.gtlib.capability.item.IItemNode;
import org.gtreimagined.gtlib.capability.item.TrackedItemHandler;
import org.gtreimagined.gtlib.util.Utils;
import org.jetbrains.annotations.NotNull;

public class SidedCombinedInvWrapper
extends CombinedInvWrapper
implements IItemNode {
    protected Direction side;
    protected CoverHandler<?> coverHandler;
    protected final Predicate<Direction> inputFunction;
    protected final Predicate<Direction> outputFunction;

    public SidedCombinedInvWrapper(Direction side, CoverHandler<?> coverHandler, Predicate<Direction> inputFunction, Predicate<Direction> outputFunction, IItemHandlerModifiable ... itemHandler) {
        super(itemHandler);
        this.side = side;
        this.coverHandler = coverHandler;
        this.inputFunction = inputFunction;
        this.outputFunction = outputFunction;
    }

    public SidedCombinedInvWrapper(Direction side, CoverHandler<?> coverHandler, IItemHandlerModifiable ... itemHandler) {
        this(side, coverHandler, (Direction d) -> true, (Direction d) -> true, itemHandler);
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        TrackedItemHandler trackedItemHandler;
        if (!this.inputFunction.test(this.side)) {
            return stack;
        }
        if (this.coverHandler != null) {
            if (this.coverHandler.blocksInput(IItemHandler.class, this.side)) {
                return stack;
            }
            ItemStack copy = stack.m_41777_();
            if (this.coverHandler.onTransfer(copy, this.side, true, simulate)) {
                return copy;
            }
        }
        int index = this.getIndexForSlot(slot);
        IItemHandlerModifiable handler = this.getHandlerFromIndex(index);
        int slot2 = this.getSlotFromIndex(slot, index);
        if (handler instanceof TrackedItemHandler && (trackedItemHandler = (TrackedItemHandler)handler).hasSlotDiversity()) {
            for (int i = 0; i < trackedItemHandler.getSize(); ++i) {
                if (i == slot2 || trackedItemHandler.getStackInSlot(i).m_41619_() || !Utils.equals(trackedItemHandler.getStackInSlot(i), stack)) continue;
                return stack;
            }
        }
        return super.insertItem(slot, stack, simulate);
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (!this.outputFunction.test(this.side)) {
            return ItemStack.f_41583_;
        }
        if (this.coverHandler != null && (this.coverHandler.blocksOutput(IItemHandler.class, this.side) || this.coverHandler.onTransfer(this.getStackInSlot(slot), this.side, false, simulate))) {
            return ItemStack.f_41583_;
        }
        return super.extractItem(slot, amount, simulate);
    }

    @Override
    public int getPriority(Direction direction) {
        return this.coverHandler == null ? 0 : this.coverHandler.get(direction).getPriority(IItemHandler.class);
    }

    @Override
    public boolean isEmpty(int slot) {
        return this.getStackInSlot(slot).m_41619_();
    }

    @Override
    public boolean canOutput() {
        return this.coverHandler == null || !this.coverHandler.blocksOutput(IItemHandler.class, this.side);
    }

    @Override
    public boolean canInput() {
        return this.coverHandler == null || !this.coverHandler.blocksInput(IItemHandler.class, this.side);
    }

    @Override
    public boolean canInput(Direction direction) {
        return this.coverHandler == null || !this.coverHandler.blocksInput(IItemHandler.class, direction);
    }

    @Override
    public boolean canOutput(Direction direction) {
        return this.coverHandler == null || !this.coverHandler.blocksOutput(IItemHandler.class, direction);
    }
}

