/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.blockentity.multi;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.Font;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.gtreimagined.gtlib.Ref;
import org.gtreimagined.gtlib.blockentity.BlockEntityMachine;
import org.gtreimagined.gtlib.blockentity.multi.BlockEntityBasicMultiMachine;
import org.gtreimagined.gtlib.capability.IComponentHandler;
import org.gtreimagined.gtlib.capability.machine.MultiMachineEnergyHandler;
import org.gtreimagined.gtlib.capability.machine.MultiMachineFluidHandler;
import org.gtreimagined.gtlib.capability.machine.MultiMachineItemHandler;
import org.gtreimagined.gtlib.gui.event.IGuiEvent;
import org.gtreimagined.gtlib.gui.widget.InfoRenderWidget;
import org.gtreimagined.gtlib.gui.widget.WidgetSupplier;
import org.gtreimagined.gtlib.integration.xei.renderer.IInfoRenderer;
import org.gtreimagined.gtlib.machine.MachineState;
import org.gtreimagined.gtlib.machine.Tier;
import org.gtreimagined.gtlib.machine.types.Machine;
import org.gtreimagined.gtlib.util.Utils;
import org.gtreimagined.tesseract.api.hu.IHeatHandler;

public class BlockEntityMultiMachine<T extends BlockEntityMultiMachine<T>>
extends BlockEntityBasicMultiMachine<T>
implements IInfoRenderer<InfoRenderWidget.MultiRenderWidget> {
    protected long EUt;
    protected List<IHeatHandler> heatHandlers = Collections.emptyList();

    public BlockEntityMultiMachine(Machine<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        if (type.has("item") || type.has("cell")) {
            this.itemHandler.set(() -> new MultiMachineItemHandler<BlockEntityMultiMachine>(this));
        }
        if (type.has("eu")) {
            this.energyHandler.set(() -> new MultiMachineEnergyHandler<BlockEntityMultiMachine>(this));
        }
        if (type.has("fluid")) {
            this.fluidHandler.set(() -> new MultiMachineFluidHandler<BlockEntityMultiMachine>(this));
        }
    }

    public List<IHeatHandler> getHeatHandlers() {
        return this.heatHandlers;
    }

    @Override
    public Tier getPowerLevel() {
        return this.energyHandler.map(t -> ((MultiMachineEnergyHandler)t).getAccumulatedPower()).orElse(super.getPowerLevel());
    }

    @Override
    public void afterStructureFormed() {
        this.components.forEach((k, v) -> v.forEach(c -> c.onStructureFormed(this)));
        if (this.isClientSide()) {
            return;
        }
        this.itemHandler.ifPresent(handle -> ((MultiMachineItemHandler)handle).onStructureBuild());
        this.energyHandler.ifPresent(handle -> ((MultiMachineEnergyHandler)handle).onStructureBuild());
        this.fluidHandler.ifPresent(handle -> ((MultiMachineFluidHandler)handle).onStructureBuild());
        List heats = (List)this.components.get((Object)"components");
        this.heatHandlers = heats != null ? heats.stream().map(IComponentHandler::getHeatHandler).filter(Optional::isPresent).map(Optional::get).toList() : Collections.emptyList();
    }

    @Override
    public void onStructureInvalidated() {
        this.components.forEach((k, v) -> v.forEach(c -> c.onStructureInvalidated(this)));
        if (this.isClientSide()) {
            return;
        }
        this.itemHandler.ifPresent(handle -> ((MultiMachineItemHandler)handle).invalidate());
        this.energyHandler.ifPresent(handle -> ((MultiMachineEnergyHandler)handle).invalidate());
        this.fluidHandler.ifPresent(handle -> ((MultiMachineFluidHandler)handle).invalidate());
        this.heatHandlers = Collections.emptyList();
    }

    @Override
    public void onGuiEvent(IGuiEvent event, Player playerEntity) {
        super.onGuiEvent(event, playerEntity);
    }

    @Override
    public long getMaxInputVoltage() {
        List<IComponentHandler> hatches = this.getComponentsByHandlerId("energy");
        return hatches.size() >= 1 ? hatches.stream().mapToLong(t -> t.getEnergyHandler().map(eh -> eh.getInputVoltage()).orElse(0L)).sum() : Ref.V[0];
    }

    public WidgetSupplier getInfoWidget() {
        return InfoRenderWidget.MultiRenderWidget.build().setPos(10, 10);
    }

    @Override
    public int drawInfo(InfoRenderWidget.MultiRenderWidget instance, PoseStack stack, Font renderer, int left, int top) {
        renderer.m_92883_(stack, this.m_5446_().getString(), (float)left, (float)top, 0xFAFAFF);
        if (this.getMachineState() != MachineState.ACTIVE) {
            renderer.m_92883_(stack, "Inactive.", (float)left, (float)(top + 8), 0xFAFAFF);
            return 16;
        }
        if (instance.drawActiveInfo()) {
            renderer.m_92883_(stack, "Progress: " + instance.currentProgress + "/" + instance.maxProgress, (float)left, (float)(top + 8), 0xFAFAFF);
            renderer.m_92883_(stack, "Overclock: " + instance.overclock, (float)left, (float)(top + 16), 0xFAFAFF);
            renderer.m_92883_(stack, "EU/t: " + instance.euT, (float)left, (float)(top + 24), 0xFAFAFF);
            return 32;
        }
        return 8;
    }

    public void explodeMultiblock() {
        this.components.forEach((s, l) -> l.forEach(c -> {
            BlockEntity patt11234$temp = c.getTile();
            if (patt11234$temp instanceof BlockEntityMachine) {
                BlockEntityMachine machine = (BlockEntityMachine)patt11234$temp;
                Utils.createExplosion(this.f_58857_, machine.m_58899_(), 6.0f, Explosion.BlockInteraction.DESTROY);
            }
        }));
        Utils.createExplosion(this.f_58857_, this.m_58899_(), 6.0f, Explosion.BlockInteraction.DESTROY);
    }
}

