/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.tool.behaviour;

import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.UseHoeEvent;
import net.minecraftforge.eventbus.api.Event;
import org.gtreimagined.gtlib.behaviour.IItemUse;
import org.gtreimagined.gtlib.tool.IBasicGTTool;
import org.gtreimagined.gtlib.util.Utils;

public class BehaviourBlockTilling
implements IItemUse<IBasicGTTool> {
    public static final BehaviourBlockTilling INSTANCE = new BehaviourBlockTilling();
    private static final Object2ObjectMap<BlockState, BlockState> TILLING_MAP = new Object2ObjectOpenHashMap();

    @Override
    public String getId() {
        return "block_tilling";
    }

    @Override
    public InteractionResult onItemUse(IBasicGTTool instance, UseOnContext c) {
        if (c.m_43719_() != Direction.DOWN && c.m_43725_().m_46859_(c.m_8083_().m_7494_())) {
            BlockState blockstate = this.getToolModifiedState(c.m_43725_().m_8055_(c.m_8083_()), c, "hoe_dig");
            if (blockstate == null) {
                return InteractionResult.PASS;
            }
            if (MinecraftForge.EVENT_BUS.post((Event)new UseHoeEvent(c))) {
                return InteractionResult.PASS;
            }
            Utils.damageStack(c.m_43722_(), (LivingEntity)c.m_43723_());
            SoundEvent soundEvent = instance.getGTToolType().getUseSound() == null ? SoundEvents.f_11955_ : instance.getGTToolType().getUseSound();
            c.m_43725_().m_5594_(c.m_43723_(), c.m_8083_(), soundEvent, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!c.m_43725_().f_46443_) {
                c.m_43725_().m_7731_(c.m_8083_(), blockstate, 11);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private BlockState getToolModifiedState(BlockState originalState, UseOnContext context, String action) {
        BlockState eventState = ForgeEventFactory.onToolUse((BlockState)originalState, (UseOnContext)context, (ToolAction)ToolAction.get((String)action), (boolean)false);
        return eventState != originalState ? eventState : (BlockState)TILLING_MAP.get((Object)originalState);
    }

    public static void addStrippedBlock(Block from, Block to) {
        BehaviourBlockTilling.addStrippedState(from.m_49966_(), to.m_49966_());
    }

    public static void addStrippedState(BlockState from, BlockState to) {
        TILLING_MAP.put((Object)from, (Object)to);
    }

    static {
        ImmutableMap.of((Object)Blocks.f_50440_, (Object)Blocks.f_50093_, (Object)Blocks.f_152481_, (Object)Blocks.f_50093_, (Object)Blocks.f_50493_, (Object)Blocks.f_50093_, (Object)Blocks.f_50546_, (Object)Blocks.f_50493_).forEach(BehaviourBlockTilling::addStrippedBlock);
    }
}

