/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.recipe.material;

import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.recipe.container.MirroredShapedRecipe;
import org.gtreimagined.gtlib.recipe.ingredient.PropertyIngredient;
import org.gtreimagined.gtlib.recipe.material.MaterialSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MaterialRecipe
extends MirroredShapedRecipe {
    private static final Map<Provider, ResourceLocation> IDS = new Object2ObjectOpenHashMap();
    public final Map<String, Set<Integer>> materialSlots;
    public final ItemBuilder builder;
    private final int size;
    public final String builderId;
    public final NonNullList<ItemStack> outputs;

    public static Provider registerProvider(String loc, String domain, Provider obj) {
        if (loc.contains("/")) {
            throw new RuntimeException("invalid input identifier to MaterialRecipe.Provider, contains /");
        }
        GTAPI.register(Provider.class, loc, domain, obj);
        IDS.put(obj, new ResourceLocation(domain, loc));
        return obj;
    }

    public MaterialRecipe(ResourceLocation idIn, String groupIn, int recipeWidthIn, int recipeHeightIn, NonNullList<Ingredient> recipeItemsIn, NonNullList<ItemStack> recipeOutputIn, String builderId, Map<String, Set<Integer>> materialSlots) {
        super(idIn, groupIn, recipeWidthIn, recipeHeightIn, recipeItemsIn, (ItemStack)recipeOutputIn.get(0), false);
        this.materialSlots = ImmutableMap.copyOf(materialSlots);
        this.size = materialSlots.values().stream().mapToInt(Set::size).sum();
        String[] ids = builderId.split("/");
        ResourceLocation lookup = new ResourceLocation(ids[0]);
        this.builderId = builderId;
        this.builder = Objects.requireNonNull(GTAPI.get(Provider.class, lookup.m_135815_(), lookup.m_135827_()), "Failed to get builder provider in MaterialRecipe" + builderId).provide(ids[1]);
        this.outputs = recipeOutputIn;
    }

    public List<ItemStack> stacksToLookup() {
        return this.outputs;
    }

    @Override
    public boolean m_5818_(CraftingContainer inv, Level worldIn) {
        return this.build(inv, true) != null;
    }

    private Result build(CraftingContainer inv, boolean regularTest) {
        for (int i = 0; i <= inv.m_39347_() - this.m_44220_(); ++i) {
            for (int j = 0; j <= inv.m_39346_() - this.m_44221_(); ++j) {
                Result m = this.build(inv, i, j, regularTest, false);
                if (m == null) continue;
                return m;
            }
        }
        return null;
    }

    private Result build(CraftingContainer inv, int width, int height, boolean regularTest, boolean mirrored) {
        Int2ObjectOpenHashMap result = new Int2ObjectOpenHashMap(this.size);
        Object2ObjectOpenHashMap ret = new Object2ObjectOpenHashMap(5, 0.25f);
        Object2ObjectOpenHashMap whichStacks = new Object2ObjectOpenHashMap(5, 0.25f);
        for (int i = 0; i < inv.m_39347_(); ++i) {
            for (int j = 0; j < inv.m_39346_(); ++j) {
                int k = i - width;
                int l = j - height;
                if (k >= 0 && l >= 0 && k < this.m_44220_() && l < this.m_44221_()) {
                    int offset = mirrored ? this.m_44220_() - k - 1 + l * this.m_44220_() : k + l * this.m_44220_();
                    Ingredient ingredient = (Ingredient)this.m_7527_().get(offset);
                    ItemStack stack = inv.m_8020_(i + j * inv.m_39347_());
                    if (ingredient instanceof PropertyIngredient) {
                        Object obj = MaterialRecipe.getMat((PropertyIngredient)ingredient, stack);
                        if (obj == null) {
                            return null;
                        }
                        result.put(offset, obj);
                    }
                    if (regularTest && !ingredient.test(stack)) {
                        return null;
                    }
                    whichStacks.put(ingredient, stack);
                    continue;
                }
                if (!regularTest || Ingredient.f_43901_.test(inv.m_8020_(i + j * inv.m_39347_()))) continue;
                return null;
            }
        }
        for (Set<Integer> l : this.materialSlots.values()) {
            Object mat = null;
            for (int i : l) {
                Object innerMat = result.get(i);
                if (innerMat == null) {
                    return null;
                }
                if (mat == null) {
                    mat = innerMat;
                    continue;
                }
                if (innerMat.equals(mat)) continue;
                return null;
            }
            ret.put(((PropertyIngredient)((Object)this.m_7527_().get(l.iterator().next().intValue()))).getId(), mat);
        }
        for (Set<Integer> value : ret.values()) {
            if (value != null) continue;
            return null;
        }
        return new Result((Map<String, Object>)ret, (Map<Ingredient, ItemStack>)whichStacks);
    }

    @Nullable
    public static Object getMat(PropertyIngredient type, ItemStack stack) {
        return type.getMat(stack);
    }

    public ItemStack m_5874_(CraftingContainer inv) {
        Result m = this.build(inv, false);
        return this.builder.build(inv, m);
    }

    @Override
    public RecipeSerializer<?> m_7707_() {
        return MaterialSerializer.INSTANCE;
    }

    public static interface Provider {
        public ItemBuilder provide(String var1);

        default public String get(String identifier) {
            if (identifier.contains("/")) {
                throw new RuntimeException("invalid input identifier to MaterialRecipe.Provider, contains /");
            }
            return IDS.get(this) + "/" + identifier;
        }
    }

    public static interface ItemBuilder {
        public ItemStack build(@Nullable CraftingContainer var1, Result var2);

        public Map<String, Object> getFromResult(@NotNull ItemStack var1);
    }

    public static final class Result {
        public final Map<String, Object> mats;
        public final Map<Ingredient, ItemStack> items;

        public Result(Map<String, Object> mats, Map<Ingredient, ItemStack> items) {
            this.mats = mats;
            this.items = items;
        }
    }
}

