/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.pipe.types;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import net.minecraft.world.level.block.Block;
import org.gtreimagined.gtlib.blockentity.pipe.BlockEntityFluidPipe;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.material.MaterialTags;
import org.gtreimagined.gtlib.pipe.BlockFluidPipe;
import org.gtreimagined.gtlib.pipe.PipeSize;
import org.gtreimagined.gtlib.pipe.types.PipeType;

public class FluidPipe<T extends FluidPipe<T>>
extends PipeType<T> {
    protected int maxTemperature;
    protected boolean gasProof;
    protected boolean acidProof = false;
    protected boolean heatProof = false;
    protected int[] caps;
    protected int[] pressures;

    public FluidPipe(String domain, Material material, int maxTemperature, boolean gasProof) {
        super(domain, material, BlockEntityFluidPipe::new);
        this.maxTemperature = maxTemperature;
        this.gasProof = gasProof;
        material.flags(MaterialTags.FLUIDPIPE);
        this.sizes(PipeSize.TINY, PipeSize.SMALL, PipeSize.NORMAL, PipeSize.LARGE, PipeSize.HUGE, PipeSize.QUADRUPLE, PipeSize.NONUPLE);
    }

    @Override
    public String getTypeName() {
        return "fluid_pipe";
    }

    @Override
    public String getType() {
        return "fluid_pipe";
    }

    @Override
    public Set<Block> getBlocks() {
        return this.sizes.stream().map(s -> new BlockFluidPipe<FluidPipe>(this, (PipeSize)s)).collect(Collectors.toSet());
    }

    public int getPressure(PipeSize size) {
        if (size == PipeSize.NONUPLE) {
            return this.getPressure(PipeSize.SMALL);
        }
        if (size == PipeSize.QUADRUPLE) {
            return this.getPressure(PipeSize.NORMAL);
        }
        return this.pressures[size.ordinal()];
    }

    public T caps(int baseCap) {
        this.caps = new int[]{baseCap, baseCap, baseCap, baseCap, baseCap, baseCap};
        return (T)this;
    }

    public T caps(int ... caps) {
        this.caps = caps;
        return (T)this;
    }

    public T pressures(int basePressure) {
        this.pressures = new int[]{basePressure /= 20, basePressure * 2, basePressure * 3, basePressure * 4, basePressure * 5, basePressure * 6};
        return (T)this;
    }

    public T pressures(int ... pressures) {
        this.pressures = Arrays.stream(pressures).map(t -> t / 20).toArray();
        return (T)this;
    }

    public T acidProof(boolean acidProof) {
        this.acidProof = acidProof;
        return (T)this;
    }

    public T heatProof(boolean heatProof) {
        this.heatProof = heatProof;
        return (T)this;
    }

    @Generated
    public int getMaxTemperature() {
        return this.maxTemperature;
    }

    @Generated
    public boolean isGasProof() {
        return this.gasProof;
    }

    @Generated
    public boolean isAcidProof() {
        return this.acidProof;
    }

    @Generated
    public boolean isHeatProof() {
        return this.heatProof;
    }
}

